/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.options;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.jEdit;

public class PluginOptionGroup
extends OptionGroup {
    public PluginOptionGroup() {
        super("Plugin Options");
        this.createOptionTreeModel();
    }

    public OptionTreeModel createOptionTreeModel() {
        OptionTreeModel paneTreeModel = new OptionTreeModel();
        OptionGroup rootGroup = (OptionGroup)paneTreeModel.getRoot();
        this.setSort(true);
        EditPlugin[] plugins = jEdit.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            EditPlugin ep = plugins[i];
            if (ep instanceof EditPlugin.Broken) continue;
            String className = ep.getClassName();
            String optionPane = jEdit.getProperty("plugin." + className + ".option-pane");
            if (optionPane != null) {
                this.addOptionPane(optionPane);
                continue;
            }
            String options = jEdit.getProperty("plugin." + className + ".option-group");
            if (options == null) continue;
            this.addOptionGroup(new OptionGroup("plugin." + className, jEdit.getProperty("plugin." + className + ".name"), options));
        }
        if (this.getMemberCount() == 0) {
            this.addOptionPane(new NoPluginsPane());
        }
        rootGroup.addOptionGroup(this);
        return paneTreeModel;
    }

    public static class NoPluginsPane
    extends AbstractOptionPane {
        public NoPluginsPane() {
            super("no-plugins");
        }
    }

    public class OptionTreeModel
    implements TreeModel {
        private OptionGroup root = new OptionGroup(null);
        private EventListenerList listenerList = new EventListenerList();

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMember(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberIndex(child);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            return !(node instanceof OptionGroup);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        protected void fireNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(modelEvent);
            }
        }

        protected void fireNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(modelEvent);
            }
        }

        protected void fireNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(modelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(modelEvent);
            }
        }
    }
}

