/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;

class PluginDetailPanel
extends JPanel {
    private final JEditorPane pluginDetail;
    private final JLabel title;
    private ManagePanel.Entry entry;

    PluginDetailPanel() {
        this.setLayout(new BorderLayout());
        this.pluginDetail = new JEditorPane();
        this.pluginDetail.setEditable(false);
        this.pluginDetail.setContentType("text/html");
        this.pluginDetail.setBackground(jEdit.getColorProperty("view.bgColor"));
        this.pluginDetail.setForeground(jEdit.getColorProperty("view.fgColor"));
        this.pluginDetail.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.title = new JLabel();
        this.add((Component)this.title, "North");
        JScrollPane scroll = new JScrollPane(this.pluginDetail);
        scroll.setHorizontalScrollBarPolicy(31);
        this.add(scroll);
    }

    void setPlugin(ManagePanel.Entry entry) {
        if (entry != this.entry) {
            if (entry.status.equals("loaded")) {
                if (entry.name == null) {
                    this.title.setText("<html><b>" + entry.jar + "</b></html>");
                } else {
                    this.title.setText("<html><b>" + entry.name + "</b></html>");
                }
                StringBuilder builder = new StringBuilder();
                if (entry.version != null) {
                    builder.append("<b>Version</b>: ").append(entry.version).append("<br>");
                }
                if (entry.author != null) {
                    builder.append("<b>Author</b>: ").append(entry.author).append("<br>");
                }
                if (entry.description != null) {
                    builder.append("<br>").append(entry.description);
                }
                this.pluginDetail.setText(builder.toString());
            } else {
                this.title.setText("<html><b>" + entry.jar + "</b></html>");
                this.pluginDetail.setText(null);
            }
            this.entry = entry;
        }
    }
}

