/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;

public class LocalFileSaveTask
extends Task {
    private static final int BUFFER_SIZE = 4096;
    private File file;
    private String body;
    private String charset;

    public LocalFileSaveTask(File file, String body, String charset) {
        this.file = file;
        this.body = body;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _run() {
        FileOutputStream os = null;
        FileChannel ch = null;
        try {
            os = new FileOutputStream(this.file);
            ch = os.getChannel();
            byte[] src = this.body.getBytes(this.charset);
            os = new FileOutputStream(this.file);
            ch = os.getChannel();
            ByteBuffer buff = ByteBuffer.allocate(4096);
            int length = src.length;
            this.setMaximum(length);
            this.setStatus("Saving " + length + " bytes to " + this.file.getPath());
            for (int written = 0; written < length; written += ch.write((ByteBuffer)buff.put(src, written, Math.min(4096, length - written)).flip())) {
                buff.rewind();
                this.setValue(written);
            }
        }
        catch (IOException e) {
            try {
                Log.log(9, this, e, e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(ch);
                IOUtilities.closeQuietly((Closeable)os);
                throw throwable;
            }
            IOUtilities.closeQuietly(ch);
            IOUtilities.closeQuietly((Closeable)os);
        }
        IOUtilities.closeQuietly(ch);
        IOUtilities.closeQuietly((Closeable)os);
    }
}

