/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.Asset;
import sidekick.SideKick;
import sidekick.SideKickParsedData;
import sidekick.SideKickUpdate;

public class SideKickToolBar
extends JToolBar
implements ActionListener {
    private View view;
    private JButton select;
    private JComboBox combo;
    private boolean followCaret;
    private CaretListener caretListener;
    private Timer caretTimer;
    private SideKickParsedData data;
    private boolean automaticUpdate = false;
    private int delayMs;
    private boolean splitCombo;
    private JPanel splitComboPanel;
    private ArrayList<JComboBox> combos;
    private ComboCellRenderer renderer;
    private boolean singleIconInCombo;

    public SideKickToolBar(View view) {
        this.view = view;
        this.setFloatable(jEdit.getBooleanProperty((String)"view.toolbar.floatable"));
        this.select = new JButton(jEdit.getProperty((String)"sidekick-toolbar.select"));
        this.select.addActionListener(this);
        this.add(this.select);
        this.renderer = new ComboCellRenderer();
        this.splitCombo = jEdit.getBooleanProperty((String)"sidekick.splitCombo");
        if (this.splitCombo) {
            this.createSplitComboPanel();
        } else {
            this.createSingleCombo();
        }
        this.singleIconInCombo = jEdit.getBooleanProperty((String)"sidekick.singleIconInCombo");
        this.followCaret = SideKick.isFollowCaret();
        this.update();
        this.delayMs = jEdit.getIntegerProperty((String)"sidekick.toolBarUpdateDelay", (int)200);
        if (this.followCaret) {
            this.addCaretListener();
        }
        EditBus.addToBus((Object)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.select) {
            Object o = this.combo.getSelectedItem();
            if (!(o instanceof NodeWrapper)) {
                return;
            }
            NodeWrapper nw = (NodeWrapper)o;
            nw.select();
        }
    }

    @EditBus.EBHandler
    public void handleSideKickUpdate(SideKickUpdate msg) {
        if (msg.getView() == this.view) {
            this.update();
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        boolean newSingleIconInCombo;
        boolean newSplitCombo = jEdit.getBooleanProperty((String)"sidekick.splitCombo");
        if (newSplitCombo != this.splitCombo) {
            this.splitCombo = newSplitCombo;
            if (this.splitCombo) {
                this.removeSingleCombo();
                this.createSplitComboPanel();
            } else {
                this.removeSplitComboPanel();
                this.createSingleCombo();
            }
            this.update();
        } else if (!this.splitCombo && (newSingleIconInCombo = jEdit.getBooleanProperty((String)"sidekick.singleIconInCombo")) != this.singleIconInCombo) {
            this.singleIconInCombo = newSingleIconInCombo;
            this.update();
        }
        this.delayMs = jEdit.getIntegerProperty((String)"sidekick.toolBarUpdateDelay", (int)200);
        boolean newFollowCaret = SideKick.isFollowCaret();
        if (newFollowCaret != this.followCaret) {
            this.followCaret = newFollowCaret;
            if (this.followCaret) {
                this.addCaretListener();
            } else {
                this.removeCaretListener();
            }
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate epu) {
        if (!this.followCaret) {
            return;
        }
        EditPane editPane = epu.getEditPane();
        if (epu.getWhat() == EditPaneUpdate.CREATED) {
            editPane.getTextArea().addCaretListener(this.caretListener);
        } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
            editPane.getTextArea().removeCaretListener(this.caretListener);
        }
    }

    private void addCaretListener() {
        this.caretListener = new CaretHandler();
        for (EditPane ep : this.view.getEditPanes()) {
            ep.getTextArea().addCaretListener(this.caretListener);
        }
    }

    private void removeCaretListener() {
        for (EditPane ep : this.view.getEditPanes()) {
            ep.getTextArea().removeCaretListener(this.caretListener);
        }
        this.caretListener = null;
    }

    private void update() {
        this.automaticUpdate = true;
        this.data = SideKickParsedData.getParsedData(this.view);
        if (this.splitCombo) {
            this.updateSplitCombo();
        } else {
            this.updateSingleCombo();
        }
        if (this.followCaret) {
            this.updateSelectionByCaretPosition();
        }
        this.automaticUpdate = false;
    }

    private void updateSelectionByCaretPosition() {
        int caret;
        JEditTextArea textArea = this.view.getTextArea();
        Selection s = textArea.getSelectionAtOffset(caret = textArea.getCaretPosition());
        this.selectItemAtPosition(s == null ? caret : s.getStart());
    }

    public void dispose() {
        EditBus.removeFromBus((Object)this);
    }

    private void selectItemAtPosition(int position) {
        if (this.splitCombo) {
            this.selectItemAtPositionSplitCombo(position);
        } else {
            this.selectItemAtPositionSingleCombo(position);
        }
    }

    private void createSingleCombo() {
        this.combo = new JComboBox();
        this.combo.setRenderer(this.renderer);
        this.combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SideKickToolBar.this.automaticUpdate) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                Object o = e.getItem();
                if (!(o instanceof NodeWrapper)) {
                    return;
                }
                ((NodeWrapper)o).jump();
            }
        });
        this.add(this.combo);
    }

    private void removeSingleCombo() {
        if (this.combo == null) {
            return;
        }
        this.remove(this.combo);
        this.combo = null;
    }

    private void updateSingleCombo() {
        this.combo.removeAllItems();
        if (this.data == null) {
            this.combo.addItem(jEdit.getProperty((String)"sidekick-tree.not-parsed"));
        } else {
            this.addTree(this.data.root, null);
        }
    }

    private void addTree(TreeNode node, NodeWrapper parent) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            NodeWrapper nw = new NodeWrapper(parent, child);
            if (nw.isAsset()) {
                this.combo.addItem(nw);
            }
            this.addTree(child, nw);
        }
    }

    private void selectItemAtPositionSingleCombo(int position) {
        NodeWrapper selected = null;
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            NodeWrapper nw;
            Object itemAt = this.combo.getItemAt(i);
            if (itemAt == null || !(itemAt instanceof NodeWrapper) || !(nw = (NodeWrapper)itemAt).contains(position) || !nw.isBetterThan(selected)) continue;
            selected = nw;
        }
        if (selected != null) {
            this.automaticUpdate = true;
            this.combo.setSelectedItem(selected);
            this.automaticUpdate = false;
        }
    }

    private void createSplitComboPanel() {
        this.combos = new ArrayList();
        this.splitComboPanel = new JPanel(new FlowLayout(0));
        this.add(this.splitComboPanel);
        this.getSplitCombo(0);
    }

    private void removeSplitComboPanel() {
        if (this.combos == null) {
            return;
        }
        for (JComboBox c : this.combos) {
            this.splitComboPanel.remove(c);
        }
        this.combos = null;
        this.remove(this.splitComboPanel);
        this.splitComboPanel = null;
    }

    private void updateSplitCombo() {
        JComboBox c = this.combos.get(0);
        c.removeAllItems();
        if (this.data == null) {
            c.addItem(jEdit.getProperty((String)"sidekick-tree.not-parsed"));
        } else {
            this.addFirstTreeLevel(this.data.root);
        }
    }

    private void addFirstTreeLevel(TreeNode node) {
        JComboBox c = this.combos.get(0);
        this.addChildrenToSplitCombo(node, c, 0);
    }

    private void addChildrenToSplitCombo(TreeNode node, JComboBox c, int index) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            NodeWrapper nw = new NodeWrapper(child);
            c.addItem(nw);
        }
        Object o = c.getSelectedItem();
        if (o != null) {
            this.updateNextTreeLevel((NodeWrapper)o, index + 1);
        }
    }

    private JComboBox getSplitCombo(final int index) {
        if (index < this.combos.size()) {
            return this.combos.get(index);
        }
        JComboBox c = new JComboBox();
        c.setRenderer(this.renderer);
        this.combos.add(c);
        this.splitComboPanel.add(c);
        c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SideKickToolBar.this.automaticUpdate) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                Object o = e.getItem();
                if (!(o instanceof NodeWrapper)) {
                    return;
                }
                NodeWrapper nw = (NodeWrapper)o;
                SideKickToolBar.this.updateNextTreeLevel(nw, index + 1);
            }
        });
        return c;
    }

    private void updateNextTreeLevel(NodeWrapper nw, int index) {
        if (nw.node == null) {
            return;
        }
        int children = nw.node.getChildCount();
        if (children == 0) {
            while (this.combos.size() > index) {
                JComboBox removed = this.combos.remove(index);
                this.splitComboPanel.remove(removed);
            }
            if (!this.automaticUpdate) {
                nw.jump();
            }
        } else {
            JComboBox c = this.getSplitCombo(index);
            c.removeAllItems();
            this.addChildrenToSplitCombo(nw.node, c, index);
        }
    }

    private void selectItemAtPositionSplitCombo(int position) {
        TreePath tp = this.data.getTreePathForPosition(position);
        if (tp == null) {
            return;
        }
        for (int i = 1; i < tp.getPathCount(); ++i) {
            Object o = tp.getPathComponent(i);
            JComboBox c = this.getSplitCombo(i - 1);
            boolean found = false;
            for (int j = 0; j < c.getItemCount(); ++j) {
                NodeWrapper nw = (NodeWrapper)c.getItemAt(j);
                if (nw.node != o) continue;
                this.automaticUpdate = true;
                c.setSelectedIndex(j);
                this.updateNextTreeLevel(nw, i);
                this.automaticUpdate = false;
                found = true;
                break;
            }
            if (!found) break;
        }
    }

    private class ComboCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public ComboCellRenderer() {
            this.setLayout(new FlowLayout(0, 3, 1));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color foreground;
            ((FlowLayout)this.getLayout()).setHgap(SideKickToolBar.this.singleIconInCombo ? 7 : 3);
            this.removeAll();
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                foreground = list.getSelectionForeground();
            } else {
                this.setBackground(list.getBackground());
                foreground = list.getForeground();
            }
            if (value instanceof NodeWrapper) {
                NodeWrapper nw = (NodeWrapper)value;
                nw.addLabel(this, foreground);
            }
            return this;
        }
    }

    private class NodeWrapper {
        public NodeWrapper parent;
        public String str;
        public Icon icon;
        public Asset asset;
        public TreeNode node;

        public NodeWrapper(TreeNode node) {
            this(null, node);
        }

        public NodeWrapper(NodeWrapper parent, TreeNode node) {
            this.parent = parent;
            this.node = node;
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
                Object o = dmtn.getUserObject();
                if (o == null) {
                    this.str = "";
                } else if (o instanceof Asset) {
                    this.asset = (Asset)o;
                    this.icon = this.asset.getIcon();
                    this.str = this.asset.getShortString();
                } else {
                    this.str = o.toString();
                }
            }
        }

        public void jump() {
            if (this.asset == null) {
                return;
            }
            SideKickToolBar.this.view.getTextArea().setCaretPosition(this.asset.start.getOffset());
        }

        public void select() {
            if (this.asset == null) {
                return;
            }
            SideKickToolBar.this.view.getTextArea().setSelection((Selection)new Selection.Range(this.asset.start.getOffset(), this.asset.end.getOffset()));
        }

        public boolean contains(int position) {
            return this.asset != null && this.asset.getStart().getOffset() <= position && this.asset.getEnd().getOffset() > position;
        }

        public boolean isBetterThan(NodeWrapper other) {
            return other == null || this.asset.getStart().getOffset() > other.asset.getStart().getOffset() || this.asset.getEnd().getOffset() < other.asset.getEnd().getOffset();
        }

        public boolean isAsset() {
            return this.asset != null;
        }

        public void addParentLabel(JPanel p, Icon childIcon, Color fg) {
            if (this.parent != null) {
                this.parent.addParentLabel(p, childIcon, fg);
            }
            JLabel l = new JLabel();
            l.setForeground(fg);
            l.setText(this.str);
            if (SideKickToolBar.this.singleIconInCombo) {
                if (this.parent == null) {
                    l.setIcon(childIcon);
                }
            } else {
                l.setIcon(this.icon);
            }
            p.add(l);
        }

        public void addLabel(JPanel p, Color fg) {
            if (this.parent != null) {
                this.parent.addParentLabel(p, this.icon, fg);
            }
            JLabel l = new JLabel();
            l.setForeground(fg);
            l.setText(this.str);
            if (!SideKickToolBar.this.singleIconInCombo || this.parent == null) {
                l.setIcon(this.icon);
            }
            p.add(l);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (e.getSource() != SideKickToolBar.this.view.getTextArea()) {
                return;
            }
            if (SideKickToolBar.this.caretTimer != null) {
                SideKickToolBar.this.caretTimer.stop();
            } else {
                SideKickToolBar.this.caretTimer = new Timer(0, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        SideKickToolBar.this.updateSelectionByCaretPosition();
                    }
                });
                SideKickToolBar.this.caretTimer.setRepeats(false);
            }
            SideKickToolBar.this.caretTimer.setInitialDelay(SideKickToolBar.this.delayMs);
            SideKickToolBar.this.caretTimer.start();
        }
    }
}

