/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.StreamTask;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SimpleInputStreamTask
extends StreamTask {
    private PipedOutputStream userInput;
    private OutputStream processOutput;
    protected int SLEEP_DELAY = 100;

    public SimpleInputStreamTask(OutputStream processOutput, PipedOutputStream userInput) {
        super("Input thread");
        this.processOutput = processOutput;
        this.userInput = userInput;
    }

    protected void actionInsideWaitingLoop(BufferedReader inr) throws Exception {
    }

    protected void beforeWorking() throws Exception {
    }

    protected void flushData(String _line) throws Exception {
        this.processOutput.write(_line.getBytes());
        this.processOutput.flush();
    }

    protected void afterWorking() {
    }

    protected void exception_dumpToLog(Exception e) {
        Log.log((int)9, (Object)e, (Object)e);
    }

    protected void exception_dumpToOwner(Exception e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String _line = "";
        try {
            this.beforeWorking();
            PipedInputStream pipeIn = new PipedInputStream(this.userInput);
            try {
                BufferedReader inr = new BufferedReader(new InputStreamReader(pipeIn));
                while (!this.abortFlag) {
                    try {
                        while (true) {
                            if (this.abortFlag) {
                                throw new InterruptedException("Break the main loop: aborting");
                            }
                            if (inr.ready()) {
                                _line = inr.readLine();
                                if (_line == null) {
                                    throw new InterruptedException("Break the main loop: input stream is empty");
                                }
                                break;
                            }
                            if (this.finishFlag) {
                                throw new InterruptedException("End the main loop.");
                            }
                            Thread.sleep(this.SLEEP_DELAY);
                            this.actionInsideWaitingLoop(inr);
                        }
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    _line = _line + '\n';
                    _line = new String(_line.getBytes(), jEdit.getProperty((String)"console.encoding"));
                    this.flushData(_line);
                }
            }
            finally {
                this.afterWorking();
                pipeIn.close();
            }
        }
        catch (Exception e) {
            this.exception_dumpToLog(e);
            this.exception_dumpToOwner(e);
        }
    }
}

