/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.commando.CommandoCommand;
import console.commando.CommandoDialog;
import java.io.StringReader;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.This;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CommandoHandler
extends DefaultHandler {
    private View view;
    private CommandoCommand command;
    private CommandoDialog.SettingsPane settings;
    private CommandoDialog.SettingsPane pane;
    private NameSpace nameSpace;
    private List<This> components;
    private List<Script> scripts;
    private String varName;
    private String defaultValue;
    private String eval;
    private String optionValue;
    private String choiceLabel;
    private String label;
    private boolean confirm;
    private boolean toBuffer;
    private String mode;
    private String shell;
    private String code;
    private Vector<Option> options;
    private Stack<String> stateStack;

    CommandoHandler(View view, CommandoCommand command, CommandoDialog.SettingsPane settings, NameSpace nameSpace, List<This> components, List<Script> scripts) {
        this.view = view;
        this.command = command;
        this.settings = this.pane = settings;
        this.nameSpace = nameSpace;
        this.components = components;
        this.scripts = scripts;
        this.stateStack = new Stack();
        this.options = new Vector();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.endsWith("commando.dtd")) {
            return new InputSource(new StringReader("<!-- -->"));
        }
        return null;
    }

    public void attribute(String aname, String value) {
        aname = aname == null ? null : aname.intern();
        String string = value = value == null ? null : value.intern();
        if (aname == "LABEL") {
            this.label = value;
        } else if (aname == "VARNAME") {
            this.varName = value;
        } else if (aname == "DEFAULT") {
            this.defaultValue = value;
        } else if (aname == "EVAL") {
            this.eval = value;
        } else if (aname == "VALUE") {
            this.optionValue = value;
        } else if (aname == "CONFIRM") {
            this.confirm = "TRUE".equals(value);
        } else if (aname == "TO_BUFFER") {
            this.toBuffer = "TRUE".equals(value);
        } else if (aname == "BUFFER_MODE") {
            this.mode = value;
        } else if (aname == "SHELL") {
            this.shell = value;
        }
    }

    @Override
    public void characters(char[] c, int off, int len) {
        String tag = this.peekElement();
        String text = new String(c, off, len);
        if (tag == "COMMAND") {
            this.code = this.code == null ? text : this.code + text;
        }
    }

    @Override
    public void startElement(String ns, String localName, String qName, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aname = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            this.attribute(aname, value);
        }
        this.pushElement(localName);
        String tag = this.peekElement();
        if (tag == "CAPTION") {
            this.pane = new CommandoDialog.SettingsPane();
            this.pane.setBorder(new TitledBorder(this.label));
            this.settings.addComponent(this.pane);
            this.label = null;
        } else if (tag == "CHOICE") {
            this.choiceLabel = this.label;
            this.options = new Vector();
        }
    }

    @Override
    public void endElement(String ns, String localName, String qName) {
        if (localName == null) {
            return;
        }
        String tag = this.peekElement();
        if (localName.equals(tag)) {
            if (tag == "OPTION") {
                this.options.addElement(new Option(this.label, this.optionValue));
                this.optionValue = null;
                this.label = null;
            } else if (tag == "CAPTION") {
                this.pane = this.settings;
            } else if (tag != "COMMANDS" && tag != "UI" && tag != "COMMANDO") {
                if (tag == "COMMAND") {
                    this.scripts.add(new Script(this.confirm, this.toBuffer, this.mode, this.shell, this.code));
                    this.confirm = false;
                    this.toBuffer = false;
                    this.code = null;
                    this.shell = null;
                } else {
                    try {
                        NameSpace tmp = new NameSpace(BeanShell.getNameSpace(), "commando");
                        tmp.setVariable("pane", (Object)this.pane);
                        tmp.setVariable("ns", (Object)this.nameSpace);
                        if (tag == "CHOICE") {
                            tmp.setVariable("label", (Object)this.choiceLabel);
                        } else {
                            tmp.setVariable("label", (Object)this.label);
                        }
                        tmp.setVariable("var", (Object)this.varName);
                        tmp.setVariable("options", this.options);
                        this.defaultValue = jEdit.getProperty((String)(this.command.getPropertyPrefix() + this.varName), (String)this.defaultValue);
                        if (this.eval != null) {
                            this.defaultValue = String.valueOf(BeanShell.eval((View)this.view, (NameSpace)tmp, (String)this.eval));
                        }
                        if (this.defaultValue == null) {
                            this.nameSpace.setVariable(this.varName, (Object)"");
                        } else {
                            this.nameSpace.setVariable(this.varName, (Object)this.defaultValue);
                        }
                        String script = "commando" + tag + "(view,pane,ns,label,var,options)";
                        Object value = BeanShell.eval((View)this.view, (NameSpace)tmp, (String)script);
                        this.components.add((This)value);
                    }
                    catch (Exception e) {
                        Log.log((int)9, (Object)this, (Object)e);
                    }
                    this.eval = null;
                    this.defaultValue = null;
                    this.varName = null;
                    this.label = null;
                }
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    @Override
    public void startDocument() {
        this.pushElement(null);
    }

    private void pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }

    public static class Option {
        public String label;
        public String value;

        Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }
    }

    static class Command {
        boolean confirm;
        boolean toBuffer;
        String mode;
        String shell;
        String command;

        Command(boolean confirm, boolean toBuffer, String mode, String shell, String command) {
            this.confirm = confirm;
            this.toBuffer = toBuffer;
            this.mode = mode;
            this.shell = shell;
            this.command = command;
        }
    }

    class Script {
        boolean confirm;
        boolean toBuffer;
        String mode;
        String shell;
        String code;

        Script(boolean confirm, boolean toBuffer, String mode, String shell, String code) {
            this.confirm = confirm;
            this.toBuffer = toBuffer;
            this.mode = mode;
            this.shell = shell;
            this.code = code;
        }

        Command getCommand() {
            Object command = BeanShell.eval((View)CommandoHandler.this.view, (NameSpace)CommandoHandler.this.nameSpace, (String)this.code);
            if (command == null) {
                return null;
            }
            return new Command(this.confirm, this.toBuffer, this.mode, this.shell, String.valueOf(command));
        }
    }
}

