/*
 * Decompiled with CFR 0.152.
 */
package sidekick.util;

import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.gjt.sp.jedit.Buffer;
import sidekick.util.SideKickAsset;
import sidekick.util.SideKickElement;

public class ElementUtil {
    public static Position createStartPosition(Buffer buffer, SideKickElement sideKickElement) {
        int n = buffer.getLineStartOffset(Math.max(sideKickElement.getStartLocation().line - 1, 0));
        int[] nArray = new int[1];
        int n2 = buffer.getOffsetOfVirtualColumn(Math.max(sideKickElement.getStartLocation().line - 1, 0), Math.max(sideKickElement.getStartLocation().column - 1, 0), nArray);
        if (n2 == -1) {
            n2 = nArray[0];
        }
        Position position = ElementUtil.createPosition(n, n2);
        sideKickElement.setStartPosition(position);
        return position;
    }

    public static Position createEndPosition(Buffer buffer, SideKickElement sideKickElement) {
        int n = buffer.getLineStartOffset(Math.max(Math.min(sideKickElement.getEndLocation().line - 1, buffer.getLineCount() - 1), 0));
        int[] nArray = new int[1];
        int n2 = -1;
        try {
            n2 = buffer.getOffsetOfVirtualColumn(Math.max(sideKickElement.getEndLocation().line - 1, 0), Math.max(sideKickElement.getEndLocation().column - 1, 0), nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n2 = buffer.getLineEndOffset(buffer.getLineCount() - 1);
        }
        if (n2 == -1) {
            n2 = nArray[0];
        }
        Position position = ElementUtil.createPosition(n, n2);
        sideKickElement.setEndPosition(position);
        return position;
    }

    public static Position createPosition(int n, int n2) {
        final int n3 = n;
        final int n4 = n2;
        return new Position(){

            public int getOffset() {
                return n3 + n4;
            }
        };
    }

    public static void convert(Buffer buffer, DefaultMutableTreeNode defaultMutableTreeNode) {
        final Buffer buffer2 = buffer;
        final DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ElementUtil._convert(buffer2, defaultMutableTreeNode2);
            }
        });
    }

    private static void _convert(Buffer buffer, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ElementUtil._convert(buffer, (DefaultMutableTreeNode)enumeration.nextElement());
        }
        if (defaultMutableTreeNode.getUserObject() instanceof SideKickElement) {
            SideKickElement sideKickElement = (SideKickElement)defaultMutableTreeNode.getUserObject();
            Position position = ElementUtil.createStartPosition(buffer, sideKickElement);
            Position position2 = ElementUtil.createEndPosition(buffer, sideKickElement);
            SideKickAsset sideKickAsset = new SideKickAsset(sideKickElement);
            sideKickAsset.setStart(position);
            sideKickAsset.setEnd(position2);
            defaultMutableTreeNode.setUserObject(sideKickAsset);
        }
    }
}

