/*
 * Decompiled with CFR 0.152.
 */
package sidekick.enhanced;

import errorlist.DefaultErrorSource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.enhanced.PartialParser;
import sidekick.enhanced.SourceAsset;

public class SourceParser
extends SideKickParser
implements PartialParser {
    public ImageIcon PACKAGE_ICON;
    public ImageIcon USE_ICON;
    public ImageIcon SUB_ICON;
    public ImageIcon PACKAGE_INVALID_ICON;
    public ImageIcon USE_INVALID_ICON;
    public ImageIcon SUB_INVALID_ICON;
    public ImageIcon COMMENT_ICON;
    public String LINE_COMMENT;
    public String COMMENT;
    public String MAIN;
    public String USE;
    public String USE_KEY = "---use---";
    public String SUB_KEY = "---sub---";
    public String PKG_KEY = "---pkg---";
    protected SideKickParsedData data;
    protected PackageMap packages;
    protected ArrayList commentList;
    protected SourceAsset _asset;
    protected SourceAsset _pkgAsset;
    protected Position _start;
    protected Position _end;
    protected int _lastLineNumber = 0;
    protected int startLine = 0;

    public SourceParser(String string) {
        super(string);
        this.loadIcons(string, this.getClass());
    }

    public SourceParser(String string, Class clazz) {
        super(string);
        this.loadIcons(string, clazz);
    }

    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource defaultErrorSource) {
        this.data = new SideKickParsedData(buffer.getName());
        this.packages = new PackageMap(new PackageComparator());
        this.commentList = new ArrayList();
        this.parseBuffer(buffer, defaultErrorSource);
        this.completePackageAsset(this._end, this._lastLineNumber);
        Log.log((int)1, (Object)this, (Object)"parsing completed");
        this.buildTrees();
        Log.log((int)1, (Object)this, (Object)"tree built");
        return this.data;
    }

    public SideKickParsedData parse(Buffer buffer, String string, DefaultErrorSource defaultErrorSource) {
        return this.parse(buffer, defaultErrorSource);
    }

    public void setStartLine(int n) {
        this.startLine = n;
    }

    protected void parseBuffer(Buffer buffer, DefaultErrorSource defaultErrorSource) {
    }

    protected void loadIcons(String string, Class clazz) {
        this.PACKAGE_ICON = this.loadIcon(string, clazz, "package-icon");
        this.USE_ICON = this.loadIcon(string, clazz, "use-icon");
        this.SUB_ICON = this.loadIcon(string, clazz, "sub-icon");
        this.PACKAGE_INVALID_ICON = this.loadIcon(string, clazz, "package_invalid-icon");
        this.USE_INVALID_ICON = this.loadIcon(string, clazz, "use-invalid-icon");
        this.SUB_INVALID_ICON = this.loadIcon(string, clazz, "sub-invalid-icon");
        this.COMMENT_ICON = this.loadIcon(string, clazz, "comment-icon");
    }

    protected ImageIcon loadIcon(String string, Class clazz, String string2) {
        String string3 = jEdit.getProperty((String)("sidekick.parser." + string + "." + string2));
        URL uRL = clazz.getResource("/icons/" + string3);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    protected void completeAsset(Position position) {
        if (this._asset != null) {
            this._asset.setEnd(position);
        }
        this._asset = null;
    }

    protected void completeAsset(Position position, String string) {
        if (this._asset != null) {
            this._asset.setLongDescription(string);
        }
        this.completeAsset(position);
    }

    protected void completeAsset(Position position, int n) {
        if (this._asset != null) {
            this._asset.setLongDescription(this._asset.getLongDescription() + "-" + n);
        }
        this._lastLineNumber = n;
        this.completeAsset(position);
    }

    protected void completePackageAsset(Position position, int n) {
        this.completeAsset(position, n);
        this._asset = this._pkgAsset;
        this.completeAsset(position, n);
    }

    protected void addAsset(String string, String string2, String string3, int n, Position position) {
        this.completeAsset(position, n);
        this._asset = new SourceAsset(string3, n, position);
        this.packages.addToList(string, string2, this._asset);
    }

    protected void addLineAsset(String string, String string2, String string3, int n, Position position, Position position2) {
        SourceAsset sourceAsset = new SourceAsset(string3, n, position);
        sourceAsset.setEnd(position2);
        this.packages.addToList(string, string2, sourceAsset);
    }

    protected void addCommentAsset(String string, int n, Position position) {
        this.completeAsset(position, n);
        this._asset = new SourceAsset(string, n, position);
        this.commentList.add(this._asset);
    }

    protected void addPackageAsset(String string, int n, Position position) {
        SourceAsset sourceAsset;
        this.completePackageAsset(position, n);
        this._pkgAsset = sourceAsset = new SourceAsset(string, n, position);
        this.packages.addPackage(string, sourceAsset);
    }

    protected void buildTrees() {
        Set set = this.packages.keySet();
        for (String string : set) {
            HashMap hashMap = (HashMap)this.packages.get(string);
            SourceAsset sourceAsset = (SourceAsset)hashMap.get(this.PKG_KEY);
            sourceAsset.setIcon(this.PACKAGE_ICON);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(sourceAsset);
            this.newTree(defaultMutableTreeNode, this.USE, (ArrayList)hashMap.get(this.USE_KEY), this.USE_ICON);
            this.addList(defaultMutableTreeNode, (ArrayList)hashMap.get(this.SUB_KEY), this.SUB_ICON);
            this.data.root.add(defaultMutableTreeNode);
        }
        this.newTree(this.data.root, this.COMMENT, this.commentList, this.COMMENT_ICON);
    }

    protected void newTree(DefaultMutableTreeNode defaultMutableTreeNode, String string, ArrayList arrayList, ImageIcon imageIcon) {
        if (arrayList.size() == 0) {
            return;
        }
        SourceAsset sourceAsset = (SourceAsset)arrayList.get(0);
        SourceAsset sourceAsset2 = new SourceAsset(string, sourceAsset.getLineNo(), sourceAsset.getStart());
        sourceAsset2.setIcon(imageIcon);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(sourceAsset2);
        this.addList(defaultMutableTreeNode2, arrayList, null);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    protected void addList(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList arrayList, ImageIcon imageIcon) {
        Collections.sort(arrayList, new AssetComparator());
        for (SourceAsset sourceAsset : arrayList) {
            sourceAsset.setIcon(imageIcon);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(sourceAsset));
        }
    }

    protected String find(String string, Pattern pattern, int n) {
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(n) : null;
    }

    protected String[] find2(String string, Pattern pattern) {
        String[] stringArray = new String[2];
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            stringArray[0] = matcher.group(1);
            stringArray[1] = matcher.group(2);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public class PackageMap
    extends TreeMap {
        public PackageMap() {
        }

        public PackageMap(PackageComparator packageComparator) {
            super(packageComparator);
        }

        public HashMap addPackage(String string, SourceAsset sourceAsset) {
            if (this.containsKey(string)) {
                return (HashMap)this.get(string);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(SourceParser.this.PKG_KEY, sourceAsset);
            hashMap.put(SourceParser.this.USE_KEY, new ArrayList());
            hashMap.put(SourceParser.this.SUB_KEY, new ArrayList());
            this.put(string, hashMap);
            return hashMap;
        }

        public SourceAsset getPackageAsset(String string) {
            if (!this.containsKey(string)) {
                return null;
            }
            HashMap hashMap = (HashMap)this.get(string);
            return (SourceAsset)hashMap.get(SourceParser.this.PKG_KEY);
        }

        public void completePackageAsset(String string, Position position) {
            SourceAsset sourceAsset = this.getPackageAsset(string);
            if (sourceAsset != null) {
                sourceAsset.setEnd(position);
            }
        }

        public void completePackageAsset(String string, Position position, String string2) {
            SourceAsset sourceAsset = this.getPackageAsset(string);
            if (sourceAsset == null) {
                return;
            }
            sourceAsset.setLongDescription(string2);
            sourceAsset.setEnd(position);
        }

        public void completePackageAsset(String string, Position position, int n) {
            SourceAsset sourceAsset = this.getPackageAsset(string);
            if (sourceAsset == null) {
                return;
            }
            sourceAsset.setLongDescription(sourceAsset.getLongDescription() + "-" + n);
            sourceAsset.setEnd(position);
        }

        public void addToList(String string, String string2, SourceAsset sourceAsset) {
            SourceAsset sourceAsset2 = new SourceAsset(string2, sourceAsset.getLineNo(), sourceAsset.getStart());
            HashMap hashMap = this.addPackage(string2, sourceAsset2);
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            if (arrayList != null) {
                arrayList.add(sourceAsset);
            } else {
                Log.log((int)1, SourceParser.class, (Object)("Entry " + string + " not in PackageMap"));
            }
        }
    }

    public class PackageComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            int n = string.toLowerCase().compareTo(string2.toLowerCase());
            if (n == 0) {
                return n;
            }
            if (string.equals(SourceParser.this.MAIN)) {
                return -1;
            }
            if (string2.equals(SourceParser.this.MAIN)) {
                return 1;
            }
            return n;
        }
    }

    protected class AssetComparator
    implements Comparator {
        protected AssetComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((SourceAsset)object).toString();
            String string2 = ((SourceAsset)object2).toString();
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    }
}

