/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredTreeModel
implements TreeModel {
    private boolean ignoreCase;
    private FilteredTreeModelListener listener;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private TreeModel model;
    private ParentProvider parentProvider;
    private TreeMap<String, List<Object>> searchMap = new TreeMap();
    private Set<Object> visibleNodes;

    public FilteredTreeModel(DefaultTreeModel defaultTreeModel, boolean bl) {
        this(defaultTreeModel, bl, new TreeNodeParentProvider());
    }

    public FilteredTreeModel(TreeModel treeModel, boolean bl, ParentProvider parentProvider) {
        this.ignoreCase = bl;
        this.listener = new FilteredTreeModelListener();
        this.setModel(treeModel, parentProvider);
    }

    public void addSearchKey(Object object, String string) {
        List<Object> list = this.searchMap.get(string = this.normalize(string));
        if (list == null) {
            list = new ArrayList<Object>(1);
            this.searchMap.put(string, list);
        }
        list.add(object);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public void clearFilter() {
        this.filterByText(null);
    }

    protected SortedMap<String, List<Object>> getMatches(String string) {
        TreeMap<String, List<Object>> treeMap = new TreeMap<String, List<Object>>();
        for (String string2 : this.searchMap.keySet()) {
            if (string2.indexOf(string) == -1) continue;
            treeMap.put(string2, this.searchMap.get(string2));
        }
        return treeMap;
    }

    public void filterByText(String string) {
        Object object;
        if ((string = this.normalize(string)) == null || string.length() == 0) {
            this.visibleNodes = null;
        } else {
            this.visibleNodes = new HashSet<Object>();
            object = string.split(" ");
            for (int i = 0; i < ((String[])object).length; ++i) {
                SortedMap<String, List<Object>> object3 = this.getMatches(string);
                if (i == 0) {
                    for (List list : object3.values()) {
                        this.visibleNodes.addAll(list);
                    }
                    continue;
                }
                HashSet hashSet = new HashSet();
                for (List<Object> list : object3.values()) {
                    hashSet.addAll(list);
                }
                this.visibleNodes.retainAll(hashSet);
            }
            this.ensureParentsVisible();
        }
        object = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged((TreeModelEvent)object);
        }
    }

    @Override
    public Object getChild(Object object, int n) {
        if (this.visibleNodes == null) {
            return this.model.getChild(object, n);
        }
        int n2 = 0;
        int n3 = this.model.getChildCount(object);
        for (int i = 0; i < n3; ++i) {
            Object object2 = this.model.getChild(object, i);
            if (!this.visibleNodes.contains(object2) || n != n2++) continue;
            return object2;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount(Object object) {
        if (this.visibleNodes == null) {
            return this.model.getChildCount(object);
        }
        int n = 0;
        int n2 = this.model.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            if (!this.visibleNodes.contains(this.model.getChild(object, i))) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (this.visibleNodes == null) {
            return this.model.getIndexOfChild(object, object2);
        }
        int n = 0;
        int n2 = this.model.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            Object object3 = this.model.getChild(object, i);
            if (!this.visibleNodes.contains(object3)) continue;
            if (object3 == object2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public TreeModel getModel() {
        return this.model;
    }

    @Override
    public Object getRoot() {
        return this.model.getRoot();
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.model.isLeaf(object);
    }

    public boolean isVisible(Object object) {
        return this.visibleNodes == null || this.visibleNodes.contains(object);
    }

    private String normalize(String string) {
        if (string != null && this.ignoreCase) {
            string = string.toLowerCase();
        }
        return string;
    }

    public void reload() {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public void removeSearchKey(Object object, String string) {
        List<Object> list = this.searchMap.get(string = this.normalize(string));
        if (list != null) {
            list.remove(object);
            if (list.isEmpty()) {
                this.searchMap.remove(string);
            }
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    public void setModel(DefaultTreeModel defaultTreeModel) {
        this.setModel(defaultTreeModel, new TreeNodeParentProvider());
    }

    public void setModel(TreeModel treeModel, ParentProvider parentProvider) {
        if (treeModel == null || parentProvider == null) {
            throw new IllegalArgumentException();
        }
        if (this.model != null) {
            this.model.removeTreeModelListener(this.listener);
        }
        this.model = treeModel;
        this.parentProvider = parentProvider;
        this.model.addTreeModelListener(this.listener);
        this.searchMap.clear();
        this.reset();
    }

    public void reset() {
        this.visibleNodes = null;
        this.reload();
    }

    private void ensureParentsVisible() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : this.visibleNodes) {
            Object object2 = this.parentProvider.getParent(object);
            while (object2 != null) {
                hashSet.add(object2);
                object2 = this.parentProvider.getParent(object2);
            }
        }
        this.visibleNodes.addAll(hashSet);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.model.valueForPathChanged(treePath, object);
    }

    public static interface ParentProvider {
        public Object getParent(Object var1);
    }

    public static class TreeNodeParentProvider
    implements ParentProvider {
        public Object getParent(Object object) {
            return ((TreeNode)object).getParent();
        }
    }

    private class FilteredTreeModelListener
    implements TreeModelListener {
        private FilteredTreeModelListener() {
        }

        public TreeModelEvent refactorEvent(TreeModelEvent treeModelEvent) {
            if (FilteredTreeModel.this.visibleNodes != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(treeModelEvent.getChildren().length);
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(treeModelEvent.getChildIndices().length);
                for (Object object : treeModelEvent.getChildren()) {
                    FilteredTreeModel.this.visibleNodes.add(object);
                }
                Object object = treeModelEvent.getTreePath().getLastPathComponent();
                Object[] objectArray = treeModelEvent.getChildren();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = objectArray[i];
                    arrayList.add(object2);
                    arrayList2.add(FilteredTreeModel.this.getIndexOfChild(object, object2));
                }
                int[] nArray = new int[arrayList2.size()];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = (Integer)arrayList2.get(n);
                }
                treeModelEvent = new TreeModelEvent(treeModelEvent.getSource(), treeModelEvent.getTreePath(), nArray, arrayList.toArray(new Object[0]));
            }
            return treeModelEvent;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (!FilteredTreeModel.this.isVisible(treeModelEvent.getTreePath().getLastPathComponent())) {
                return;
            }
            treeModelEvent = this.refactorEvent(treeModelEvent);
            for (TreeModelListener treeModelListener : FilteredTreeModel.this.listeners) {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (!FilteredTreeModel.this.isVisible(treeModelEvent.getTreePath().getLastPathComponent())) {
                return;
            }
            treeModelEvent = this.refactorEvent(treeModelEvent);
            for (TreeModelListener treeModelListener : FilteredTreeModel.this.listeners) {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (!FilteredTreeModel.this.isVisible(treeModelEvent.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener treeModelListener : FilteredTreeModel.this.listeners) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (!FilteredTreeModel.this.isVisible(treeModelEvent.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener treeModelListener : FilteredTreeModel.this.listeners) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }
    }
}

