/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.lobobrowser.util.Strings;

public class Domains {
    private static final Collection gTLDs = new HashSet();

    private Domains() {
    }

    public static boolean isValidCookieDomain(String string, String string2) {
        String string3;
        if (!string.startsWith(".")) {
            string3 = string;
            string = "." + string;
        } else {
            string3 = string.substring(1);
        }
        String string4 = string3.toLowerCase();
        String string5 = string2.toLowerCase();
        if (!string5.endsWith(string4)) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string6 = string.substring(n).toLowerCase();
        if (gTLDs.contains(string6)) {
            return Strings.countChars(string, '.') >= 2;
        }
        return Strings.countChars(string, '.') >= 3;
    }

    public static boolean endsWithGTLD(String string) {
        for (String string2 : gTLDs) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikelyHostName(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("www.")) {
            return true;
        }
        if (Domains.endsWithGTLD(string)) {
            return true;
        }
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        return n == string2.length() - 3;
    }

    public static Collection getPossibleDomains(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        int n = string.indexOf(46, 1);
        if (n == -1) {
            return linkedList;
        }
        String string2 = string.substring(n);
        if (!Domains.isValidCookieDomain(string2, string)) {
            return linkedList;
        }
        linkedList.addAll(Domains.getPossibleDomains(string2.substring(1)));
        return linkedList;
    }

    static {
        gTLDs.add(".com");
        gTLDs.add(".edu");
        gTLDs.add(".gov");
        gTLDs.add(".int");
        gTLDs.add(".mil");
        gTLDs.add(".net");
        gTLDs.add(".org");
        gTLDs.add(".biz");
        gTLDs.add(".info");
        gTLDs.add(".name");
        gTLDs.add(".pro");
        gTLDs.add(".aero");
        gTLDs.add(".coop");
        gTLDs.add(".museum");
    }
}

