/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.net.CookieHandler;
import java.net.Proxy;
import java.net.URL;
import java.security.Policy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.test.SimpleHttpRequest;

public class SimpleUserAgentContext
implements UserAgentContext {
    private static final Logger logger = Logger.getLogger(SimpleUserAgentContext.class.getName());
    private static final Set mediaNames = new HashSet();
    private Proxy proxy = Proxy.NO_PROXY;
    private String appCodeName = "Cobra";
    private String appMinorVersion = "0";
    private String appName = "Cobra";
    private String appVersion = "1";
    private String userAgent = "Mozilla/4.0 (compatible; MSIE 6.0;) Cobra/Simple";
    private boolean scriptingEnabled = true;
    private int scriptingOptimizationLevel = -1;
    private String vendor = "The Lobo Project";
    private String product = "Cobra";
    private boolean externalCSSEnabled = true;

    public boolean isMedia(String string) {
        return mediaNames.contains(string.toLowerCase());
    }

    public HttpRequest createHttpRequest() {
        return new SimpleHttpRequest(this, this.getProxy());
    }

    protected Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getAppCodeName() {
        return this.appCodeName;
    }

    public void setAppCodeName(String string) {
        this.appCodeName = string;
    }

    public String getAppMinorVersion() {
        return this.appMinorVersion;
    }

    public void setAppMinorVersion(String string) {
        this.appMinorVersion = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String string) {
        this.appVersion = string;
    }

    public String getBrowserLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getPlatform() {
        return System.getProperty("os.name");
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public boolean isCookieEnabled() {
        return CookieHandler.getDefault() != null;
    }

    public String getCookie(URL uRL) {
        Map<String, List<String>> map;
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler == null) {
            return "";
        }
        try {
            map = cookieHandler.get(uRL.toURI(), new HashMap<String, List<String>>());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "getCookie()", exception);
            return "";
        }
        if (map == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map.Entry<String, List<String>>> iterator = map.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            String string = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(string) && !"Cookie2".equalsIgnoreCase(string)) continue;
            List<String> list = entry.getValue();
            for (String string2 : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean bl) {
        this.scriptingEnabled = bl;
    }

    public void setCookie(URL uRL, String string) {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler == null) {
            return;
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(2);
        hashMap.put("Set-Cookie", Collections.singletonList(string));
        try {
            cookieHandler.put(uRL.toURI(), hashMap);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "setCookie()", exception);
        }
    }

    public Policy getSecurityPolicy() {
        return null;
    }

    public int getScriptingOptimizationLevel() {
        return this.scriptingOptimizationLevel;
    }

    public void setScriptingOptimizationLevel(int n) {
        this.scriptingOptimizationLevel = n;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public boolean isExternalCSSEnabled() {
        return this.externalCSSEnabled;
    }

    public void setExternalCSSEnabled(boolean bl) {
        this.externalCSSEnabled = bl;
    }

    static {
        Set set = mediaNames;
        set.add("screen");
        set.add("tv");
        set.add("tty");
        set.add("all");
    }
}

