/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Point;
import java.awt.Rectangle;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.Range;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.util.Diagnostics;

class MarkupUtilities {
    private MarkupUtilities() {
    }

    public static BoundableRenderable findRenderable(Renderable[] renderableArray, Point point, boolean bl) {
        return MarkupUtilities.findRenderable(renderableArray, point, 0, renderableArray.length, bl);
    }

    public static BoundableRenderable findRenderable(Renderable[] renderableArray, int n, int n2, boolean bl) {
        return MarkupUtilities.findRenderable(renderableArray, n, n2, 0, renderableArray.length, bl);
    }

    private static BoundableRenderable findRenderable(Renderable[] renderableArray, Point point, int n, int n2, boolean bl) {
        return MarkupUtilities.findRenderable(renderableArray, point.x, point.y, n, n2, bl);
    }

    private static BoundableRenderable findRenderable(Renderable[] renderableArray, int n, int n2, int n3, int n4, boolean bl) {
        if (n4 == 0) {
            return null;
        }
        if (n4 == 1) {
            Renderable renderable = renderableArray[n3];
            if (!(renderable instanceof BoundableRenderable)) {
                return null;
            }
            BoundableRenderable boundableRenderable = (BoundableRenderable)renderable;
            Rectangle rectangle = boundableRenderable.getBounds();
            return rectangle.contains(n, n2) ? boundableRenderable : null;
        }
        int n5 = n3 + n4 / 2;
        Renderable renderable = renderableArray[n5];
        if (!(renderable instanceof BoundableRenderable)) {
            BoundableRenderable boundableRenderable = MarkupUtilities.findRenderable(renderableArray, n, n2, n3, n5 - n3, bl);
            if (boundableRenderable != null) {
                return boundableRenderable;
            }
            return MarkupUtilities.findRenderable(renderableArray, n, n2, n5 + 1, n4 - (n5 - n3 + 1), bl);
        }
        Rectangle rectangle = ((BoundableRenderable)renderable).getBounds();
        if (rectangle.contains(n, n2)) {
            return (BoundableRenderable)renderable;
        }
        if (bl) {
            if (n2 < rectangle.y) {
                return MarkupUtilities.findRenderable(renderableArray, n, n2, n3, n5 - n3, bl);
            }
            return MarkupUtilities.findRenderable(renderableArray, n, n2, n5 + 1, n4 - (n5 - n3 + 1), bl);
        }
        if (n < rectangle.x) {
            return MarkupUtilities.findRenderable(renderableArray, n, n2, n3, n5 - n3, bl);
        }
        return MarkupUtilities.findRenderable(renderableArray, n, n2, n5 + 1, n4 - (n5 - n3 + 1), bl);
    }

    public static Range findRenderables(Renderable[] renderableArray, Rectangle rectangle, boolean bl) {
        return MarkupUtilities.findRenderables(renderableArray, rectangle, 0, renderableArray.length, bl);
    }

    private static Range findRenderables(Renderable[] renderableArray, Rectangle rectangle, int n, int n2, boolean bl) {
        if (n2 == 0) {
            return new Range(0, 0);
        }
        int n3 = MarkupUtilities.findFirstIndex(renderableArray, rectangle, n, n2, bl);
        int n4 = MarkupUtilities.findLastIndex(renderableArray, rectangle, n, n2, bl);
        if (n3 == -1 && n4 == -1) {
            return new Range(0, 0);
        }
        if (n3 == -1) {
            n3 = n;
        }
        if (n4 == -1) {
            n4 = n + n2 - 1;
        }
        return new Range(n3, n4 - n3 + 1);
    }

    private static int findFirstIndex(Renderable[] renderableArray, Rectangle rectangle, int n, int n2, boolean bl) {
        Diagnostics.Assert(n2 > 0, "length=" + n2);
        if (n2 == 1) {
            Renderable renderable = renderableArray[n];
            if (!(renderable instanceof BoundableRenderable)) {
                return -1;
            }
            Rectangle rectangle2 = ((BoundableRenderable)renderable).getBounds();
            if (MarkupUtilities.intersects(rectangle2, rectangle, bl)) {
                return n;
            }
            return -1;
        }
        int n3 = n + n2 / 2;
        Renderable renderable = renderableArray[n3];
        if (!(renderable instanceof BoundableRenderable)) {
            int n4 = MarkupUtilities.findFirstIndex(renderableArray, rectangle, n, n3 - n, bl);
            if (n4 != -1) {
                return n4;
            }
            return MarkupUtilities.findFirstIndex(renderableArray, rectangle, n3 + 1, n2 - (n3 - n + 1), bl);
        }
        Rectangle rectangle3 = ((BoundableRenderable)renderable).getBounds();
        if (bl) {
            int n5;
            if (rectangle3.y + rectangle3.height < rectangle.y) {
                int n6 = n2 - (n3 - n + 1);
                return n6 == 0 ? -1 : MarkupUtilities.findFirstIndex(renderableArray, rectangle, n3 + 1, n6, bl);
            }
            int n7 = n3 - n;
            int n8 = n5 = n7 == 0 ? -1 : MarkupUtilities.findFirstIndex(renderableArray, rectangle, n, n7, bl);
            if (n5 == -1 && MarkupUtilities.intersects(rectangle, rectangle3, bl)) {
                return n3;
            }
            return n5;
        }
        if (rectangle3.x + rectangle3.width < rectangle.x) {
            return MarkupUtilities.findFirstIndex(renderableArray, rectangle, n3 + 1, n2 - (n3 - n), bl);
        }
        int n9 = MarkupUtilities.findFirstIndex(renderableArray, rectangle, n, n3 - n, bl);
        if (n9 == -1 && MarkupUtilities.intersects(rectangle, rectangle3, bl)) {
            return n3;
        }
        return n9;
    }

    private static int findLastIndex(Renderable[] renderableArray, Rectangle rectangle, int n, int n2, boolean bl) {
        Diagnostics.Assert(n2 > 0, "length<=0");
        if (n2 == 1) {
            Renderable renderable = renderableArray[n];
            if (!(renderable instanceof BoundableRenderable)) {
                return -1;
            }
            Rectangle rectangle2 = ((BoundableRenderable)renderable).getBounds();
            if (MarkupUtilities.intersects(rectangle, rectangle2, bl)) {
                return n;
            }
            return -1;
        }
        int n3 = n + n2 / 2;
        Renderable renderable = renderableArray[n3];
        if (!(renderable instanceof BoundableRenderable)) {
            int n4 = MarkupUtilities.findLastIndex(renderableArray, rectangle, n3 + 1, n2 - (n3 - n + 1), bl);
            if (n4 != -1) {
                return n4;
            }
            return MarkupUtilities.findLastIndex(renderableArray, rectangle, n, n3 - n, bl);
        }
        Rectangle rectangle3 = ((BoundableRenderable)renderable).getBounds();
        if (bl) {
            int n5;
            if (rectangle3.y > rectangle.y + rectangle.height) {
                return MarkupUtilities.findLastIndex(renderableArray, rectangle, n, n3 - n, bl);
            }
            int n6 = n2 - (n3 - n + 1);
            int n7 = n5 = n6 == 0 ? -1 : MarkupUtilities.findLastIndex(renderableArray, rectangle, n3 + 1, n6, bl);
            if (n5 == -1 && MarkupUtilities.intersects(rectangle, rectangle3, bl)) {
                return n3;
            }
            return n5;
        }
        if (rectangle3.x > rectangle.x + rectangle.width) {
            return MarkupUtilities.findLastIndex(renderableArray, rectangle, n, n3 - n, bl);
        }
        int n8 = MarkupUtilities.findLastIndex(renderableArray, rectangle, n3 + 1, n2 - (n3 - n + 1), bl);
        if (n8 == -1 && MarkupUtilities.intersects(rectangle, rectangle3, bl)) {
            return n3;
        }
        return n8;
    }

    private static boolean intersects(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (bl) {
            return rectangle.y <= rectangle2.y + rectangle2.height && rectangle2.y <= rectangle.y + rectangle.height;
        }
        return rectangle.x <= rectangle2.x + rectangle2.width && rectangle2.x <= rectangle.x + rectangle.width;
    }
}

