/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.DOMImplementationImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.util.Urls;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private static final Logger logger = Logger.getLogger(DocumentBuilderImpl.class.getName());
    private EntityResolver resolver;
    private ErrorHandler errorHandler;
    private final UserAgentContext bcontext;
    private final HtmlRendererContext rcontext;
    private DOMImplementation domImplementation;

    public DocumentBuilderImpl(UserAgentContext userAgentContext) {
        this.rcontext = null;
        this.bcontext = userAgentContext;
    }

    public DocumentBuilderImpl(UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext) {
        this.rcontext = htmlRendererContext;
        this.bcontext = userAgentContext;
    }

    public DocumentBuilderImpl(HtmlRendererContext htmlRendererContext) {
        this.rcontext = htmlRendererContext;
        this.bcontext = htmlRendererContext.getUserAgentContext();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.createDocument(inputSource);
        hTMLDocumentImpl.load();
        return hTMLDocumentImpl;
    }

    public Document createDocument(InputSource inputSource) throws SAXException, IOException {
        Object object;
        WritableLineReader writableLineReader;
        Reader reader;
        String string;
        String string2 = inputSource.getEncoding();
        String string3 = string2;
        if (string3 == null) {
            string3 = "US-ASCII";
        }
        if ((string = inputSource.getSystemId()) == null) {
            logger.warning("parse(): InputSource has no SystemId (URI); document item URLs will not be resolvable.");
        }
        if ((reader = inputSource.getCharacterStream()) != null) {
            writableLineReader = new WritableLineReader(reader);
        } else {
            object = inputSource.getByteStream();
            if (object != null) {
                writableLineReader = new WritableLineReader(new InputStreamReader((InputStream)object, string3));
            } else if (string != null) {
                URLConnection uRLConnection = new URL(string).openConnection();
                object = uRLConnection.getInputStream();
                if (string2 == null) {
                    string3 = Urls.getCharset(uRLConnection);
                }
                writableLineReader = new WritableLineReader(new InputStreamReader((InputStream)object, string3));
            } else {
                throw new IllegalArgumentException("The InputSource must have either a reader, an input stream or a URI.");
            }
        }
        object = new HTMLDocumentImpl(this.bcontext, this.rcontext, writableLineReader, string);
        return object;
    }

    public boolean isNamespaceAware() {
        return false;
    }

    public boolean isValidating() {
        return false;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Document newDocument() {
        return new HTMLDocumentImpl(this.bcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMImplementation getDOMImplementation() {
        DocumentBuilderImpl documentBuilderImpl = this;
        synchronized (documentBuilderImpl) {
            if (this.domImplementation == null) {
                this.domImplementation = new DOMImplementationImpl(this.bcontext);
            }
            return this.domImplementation;
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }
}

