/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class SecurityControllerImpl
extends SecurityController {
    private final URL url;
    private final Policy policy;
    private final CodeSource codesource;

    public SecurityControllerImpl(URL uRL, Policy policy) {
        this.url = uRL;
        this.policy = policy;
        this.codesource = new CodeSource(this.url, (Certificate[])null);
    }

    public Object callWithDomain(Object object, final Context context, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        if (object == null) {
            return callable.call(context, scriptable, scriptable2, objectArray);
        }
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        };
        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{(ProtectionDomain)object});
        return AccessController.doPrivileged(privilegedAction, accessControlContext);
    }

    public GeneratedClassLoader createClassLoader(ClassLoader classLoader, Object object) {
        return new LocalSecureClassLoader(classLoader);
    }

    public Object getDynamicSecurityDomain(Object object) {
        Policy policy = this.policy;
        if (policy == null) {
            return null;
        }
        PermissionCollection permissionCollection = this.policy.getPermissions(this.codesource);
        return new ProtectionDomain(this.codesource, permissionCollection);
    }

    private class LocalSecureClassLoader
    extends SecureClassLoader
    implements GeneratedClassLoader {
        public LocalSecureClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class defineClass(String string, byte[] byArray) {
            return this.defineClass(string, byArray, 0, byArray.length, SecurityControllerImpl.this.codesource);
        }

        public void linkClass(Class clazz) {
            super.resolveClass(clazz);
        }
    }
}

