/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.File;
import java.util.logging.Level;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.InputContext;
import org.w3c.dom.html2.HTMLInputElement;

public class HTMLInputElementImpl
extends HTMLBaseInputElement
implements HTMLInputElement {
    private boolean defaultChecked;

    public HTMLInputElementImpl(String string) {
        super(string);
    }

    public boolean getDefaultChecked() {
        return this.defaultChecked;
    }

    public void setDefaultChecked(boolean bl) {
        this.defaultChecked = bl;
    }

    public boolean getChecked() {
        InputContext inputContext = this.inputContext;
        if (inputContext == null) {
            return this.getAttributeAsBoolean("checked");
        }
        return inputContext.getChecked();
    }

    public void setChecked(boolean bl) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setChecked(bl);
        }
    }

    public int getMaxLength() {
        InputContext inputContext = this.inputContext;
        return inputContext == null ? 0 : inputContext.getMaxLength();
    }

    public void setMaxLength(int n) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setMaxLength(n);
        }
    }

    public int getSize() {
        InputContext inputContext = this.inputContext;
        return inputContext == null ? 0 : inputContext.getControlSize();
    }

    public void setSize(int n) {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.setControlSize(n);
        }
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String string) {
        this.setAttribute("src", string);
    }

    public String getType() {
        String string = this.getAttribute("type");
        return string == null ? null : string.toLowerCase();
    }

    public void setType(String string) {
        this.setAttribute("type", string);
    }

    public String getUseMap() {
        return this.getAttribute("usemap");
    }

    public void setUseMap(String string) {
        this.setAttribute("usemap", string);
    }

    public void click() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.click();
        }
    }

    public boolean isSubmittableWithEnterKey() {
        String string = this.getType();
        return string == null || "".equals(string) || "text".equals(string) || "password".equals(string);
    }

    public boolean isSubmittableWithPress() {
        String string = this.getType();
        return "submit".equals(string) || "image".equals(string);
    }

    public boolean isSubmitInput() {
        String string = this.getType();
        return "submit".equals(string);
    }

    public boolean isImageInput() {
        String string = this.getType();
        return "image".equals(string);
    }

    public boolean isResetInput() {
        String string = this.getType();
        return "reset".equals(string);
    }

    void resetInput() {
        InputContext inputContext = this.inputContext;
        if (inputContext != null) {
            inputContext.resetInput();
        }
    }

    protected FormInput[] getFormInputs() {
        String string = this.getType();
        String string2 = this.getName();
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return new FormInput[]{new FormInput(string2, this.getValue())};
        }
        if ("text".equals(string) || "password".equals(string) || "hidden".equals(string) || "".equals(string)) {
            return new FormInput[]{new FormInput(string2, this.getValue())};
        }
        if ("submit".equals(string)) {
            return null;
        }
        if ("radio".equals(string) || "checkbox".equals(string)) {
            if (this.getChecked()) {
                String string3 = this.getValue();
                if (string3 == null || string3.length() == 0) {
                    string3 = "on";
                }
                return new FormInput[]{new FormInput(string2, string3)};
            }
            return null;
        }
        if ("image".equals(string)) {
            return null;
        }
        if ("file".equals(string)) {
            File file = this.getFileValue();
            if (file == null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("getFormInputs(): File input named " + string2 + " has null file.");
                }
                return null;
            }
            return new FormInput[]{new FormInput(string2, file)};
        }
        return null;
    }
}

