/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    protected volatile String text;

    public CharacterDataImpl() {
    }

    public CharacterDataImpl(String string) {
        this.text = string;
    }

    public String getClassName() {
        return "HTMLCharacterData";
    }

    public String getTextContent() throws DOMException {
        return this.text;
    }

    public void setTextContent(String string) throws DOMException {
        this.text = string;
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public Node cloneNode(boolean bl) {
        CharacterDataImpl characterDataImpl = (CharacterDataImpl)super.cloneNode(bl);
        characterDataImpl.setData(this.getData());
        return characterDataImpl;
    }

    public void appendData(String string) throws DOMException {
        this.text = this.text + string;
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public void deleteData(int n, int n2) throws DOMException {
        StringBuffer stringBuffer = new StringBuffer(this.text);
        StringBuffer stringBuffer2 = stringBuffer.delete(n, n + n2);
        this.text = stringBuffer2.toString();
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public String getData() throws DOMException {
        return this.text;
    }

    public int getLength() {
        return this.text.length();
    }

    public void insertData(int n, String string) throws DOMException {
        StringBuffer stringBuffer = new StringBuffer(this.text);
        StringBuffer stringBuffer2 = stringBuffer.insert(n, string);
        this.text = stringBuffer2.toString();
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        StringBuffer stringBuffer = new StringBuffer(this.text);
        StringBuffer stringBuffer2 = stringBuffer.replace(n, n + n2, string);
        this.text = stringBuffer2.toString();
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public void setData(String string) throws DOMException {
        this.text = string;
        if (!this.notificationsSuspended) {
            this.informInvalid();
        }
    }

    public String substringData(int n, int n2) throws DOMException {
        return this.text.substring(n, n + n2);
    }

    public String toString() {
        String string = this.text;
        int n = string.length();
        if (string != null && string.length() > 32) {
            string = string.substring(0, 29) + "...";
        }
        return this.getNodeName() + "[length=" + n + ",text=" + string + "]";
    }
}

