/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;

public class TaskManager {
    public static final TaskManager instance = new TaskManager();
    private final List<TaskListener> listeners = new CopyOnWriteArrayList<TaskListener>();
    private final List<Task> tasks = Collections.synchronizedList(new ArrayList());

    private TaskManager() {
    }

    public int countTasks() {
        return this.tasks.size();
    }

    public void addTaskListener(TaskListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeTaskListener(TaskListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    void fireWaiting(Task task) {
        this.tasks.add(task);
        List<TaskListener> listeners = this.listeners;
        for (TaskListener listener : listeners) {
            listener.waiting(task);
        }
    }

    void fireRunning(Task task) {
        List<TaskListener> listeners = this.listeners;
        for (TaskListener listener : listeners) {
            listener.running(task);
        }
    }

    void fireDone(Task task) {
        this.tasks.remove(task);
        List<TaskListener> listeners = this.listeners;
        for (TaskListener listener : listeners) {
            listener.done(task);
        }
    }

    void fireStatusUpdated(Task task) {
        List<TaskListener> listeners = this.listeners;
        for (TaskListener listener : listeners) {
            listener.statusUpdated(task);
        }
    }

    void fireValueUpdated(Task task) {
        List<TaskListener> listeners = this.listeners;
        for (TaskListener listener : listeners) {
            listener.valueUpdated(task);
        }
    }

    void fireMaximumUpdated(Task task) {
        List<TaskListener> listeners = this.listeners;
        for (TaskListener listener : listeners) {
            listener.maximumUpdated(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TaskVisitor visitor) {
        List<Task> list = this.tasks;
        synchronized (list) {
            for (Task task : this.tasks) {
                visitor.visit(task);
            }
        }
    }

    static Task decorate(Runnable runnable) {
        return new MyTask(runnable);
    }

    private static class MyTask
    extends Task {
        private final Runnable runnable;

        private MyTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void _run() {
            this.runnable.run();
        }
    }

    public static interface TaskVisitor {
        public void visit(Task var1);
    }
}

