/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.IOException;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;

public class CopyFileWorker
extends Task {
    private final Component comp;
    private final String source;
    private final String target;

    public CopyFileWorker(Component comp, String source, String target) {
        if (source == null || target == null) {
            throw new NullPointerException("The source and target cannot be null");
        }
        if (source.equals(target)) {
            throw new IllegalArgumentException("The source and target must not be the same");
        }
        this.comp = comp;
        this.source = source;
        this.target = target;
        this.setLabel("Copy " + source + " to " + target);
    }

    @Override
    public void _run() {
        Log.log(1, this, this + ".run()");
        try {
            VFS.copy(this, this.source, this.target, this.comp, true);
        }
        catch (IOException e) {
            Log.log(9, this, e, e);
        }
    }

    @Override
    public String toString() {
        return "CopyFileWorker[" + this.source + ',' + this.target + ']';
    }
}

