/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class GrabKeyDialog
extends JDialog {
    private InputPane shortcut;
    private JLabel assignedTo;
    private JButton ok;
    private JButton remove;
    private JButton cancel;
    private JButton clear;
    private boolean isOK;
    private KeyBinding binding;
    private List<KeyBinding> allBindings;
    private Buffer debugBuffer;

    public GrabKeyDialog(Dialog parent, KeyBinding binding, List<KeyBinding> allBindings, Buffer debugBuffer) {
        super(parent, jEdit.getProperty("grab-key.title"), true);
        this.init(binding, allBindings, debugBuffer);
    }

    public GrabKeyDialog(Frame parent, KeyBinding binding, List<KeyBinding> allBindings, Buffer debugBuffer) {
        super(parent, jEdit.getProperty("grab-key.title"), true);
        this.init(binding, allBindings, debugBuffer);
    }

    public String getShortcut() {
        if (this.isOK) {
            return this.shortcut.getShortcut();
        }
        return null;
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    @Override
    protected void processKeyEvent(KeyEvent evt) {
        this.shortcut.processKeyEvent(evt);
    }

    private void init(KeyBinding binding, List<KeyBinding> allBindings, Buffer debugBuffer) {
        this.binding = binding;
        this.allBindings = allBindings;
        this.debugBuffer = debugBuffer;
        this.enableEvents(8L);
        JPanel content = new JPanel(new GridLayout(0, 1, 0, 6)){

            @Override
            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }
        };
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JLabel label = new JLabel(debugBuffer == null ? jEdit.getProperty("grab-key.caption", new String[]{binding.label}) : jEdit.getProperty("grab-key.keyboard-test"));
        Box input = Box.createHorizontalBox();
        this.shortcut = new InputPane();
        Dimension size = this.shortcut.getPreferredSize();
        size.width = Integer.MAX_VALUE;
        this.shortcut.setMaximumSize(size);
        input.add(this.shortcut);
        input.add(Box.createHorizontalStrut(12));
        this.clear = new JButton(jEdit.getProperty("grab-key.clear"));
        this.clear.addActionListener(new ActionHandler());
        input.add(this.clear);
        this.assignedTo = new JLabel();
        if (debugBuffer == null) {
            this.updateAssignedTo(null);
        }
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createGlue());
        if (debugBuffer == null) {
            this.ok = new JButton(jEdit.getProperty("common.ok"));
            this.ok.addActionListener(new ActionHandler());
            buttons.add(this.ok);
            buttons.add(Box.createHorizontalStrut(12));
            if (binding.isAssigned()) {
                this.remove = new JButton(jEdit.getProperty("grab-key.remove"));
                this.remove.addActionListener(new ActionHandler());
                buttons.add(this.remove);
                buttons.add(Box.createHorizontalStrut(12));
            }
        }
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add(label);
        content.add(input);
        if (debugBuffer == null) {
            content.add(this.assignedTo);
        }
        content.add(buttons);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.setVisible(true);
    }

    public static String getSymbolicName(int keyCode) {
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, GrabKeyDialog.class, "getSymbolicName(" + keyCode + ").");
        }
        if (keyCode == 0) {
            return null;
        }
        if (keyCode >= 65 && keyCode <= 90) {
            return String.valueOf(Character.toLowerCase((char)keyCode));
        }
        try {
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String name = field.getName();
                if (!name.startsWith("VK_") || field.getInt(null) != keyCode) continue;
                return name.substring(3);
            }
        }
        catch (Exception e) {
            Log.log(9, GrabKeyDialog.class, e);
        }
        return null;
    }

    private void updateAssignedTo(String shortcut) {
        String text = jEdit.getProperty("grab-key.assigned-to.none");
        KeyBinding kb = this.getKeyBinding(shortcut);
        if (kb != null) {
            text = kb.isPrefix ? jEdit.getProperty("grab-key.assigned-to.prefix", new String[]{shortcut}) : kb.label;
        }
        if (this.ok != null) {
            this.ok.setEnabled(kb == null || !kb.isPrefix);
        }
        this.assignedTo.setText(jEdit.getProperty("grab-key.assigned-to", new String[]{text}));
    }

    private KeyBinding getKeyBinding(String shortcut) {
        if (shortcut == null || shortcut.length() == 0) {
            return null;
        }
        String spacedShortcut = shortcut + ' ';
        for (KeyBinding kb : this.allBindings) {
            if (!kb.isAssigned()) continue;
            String spacedKbShortcut = kb.shortcut + ' ';
            if (spacedShortcut.startsWith(spacedKbShortcut)) {
                return kb;
            }
            if (!spacedKbShortcut.startsWith(spacedShortcut)) continue;
            return new KeyBinding(kb.name, kb.label, shortcut, true);
        }
        return null;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GrabKeyDialog.this.ok) {
                if (this.canClose()) {
                    GrabKeyDialog.this.dispose();
                }
            } else if (evt.getSource() == GrabKeyDialog.this.remove) {
                GrabKeyDialog.this.shortcut.setText(null);
                GrabKeyDialog.this.isOK = true;
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.cancel) {
                GrabKeyDialog.this.dispose();
            } else if (evt.getSource() == GrabKeyDialog.this.clear) {
                GrabKeyDialog.this.shortcut.setText(null);
                if (GrabKeyDialog.this.debugBuffer == null) {
                    GrabKeyDialog.this.updateAssignedTo(null);
                }
                GrabKeyDialog.this.shortcut.requestFocus();
            }
        }

        private boolean canClose() {
            KeyBinding other;
            String shortcutString = GrabKeyDialog.this.shortcut.getShortcut();
            if (shortcutString.length() == 0 && GrabKeyDialog.this.binding.isAssigned()) {
                int answer = GUIUtilities.confirm(GrabKeyDialog.this, "grab-key.remove-ask", null, 0, 3);
                if (answer == 0) {
                    GrabKeyDialog.this.shortcut.setText(null);
                    GrabKeyDialog.this.isOK = true;
                } else {
                    return false;
                }
            }
            if ((other = GrabKeyDialog.this.getKeyBinding(shortcutString)) == null || other == GrabKeyDialog.this.binding) {
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            if (other.name == ((GrabKeyDialog)GrabKeyDialog.this).binding.name) {
                GUIUtilities.error(GrabKeyDialog.this, "grab-key.duplicate-alt-shortcut", null);
                return false;
            }
            if (other.isPrefix) {
                GUIUtilities.error(GrabKeyDialog.this, "grab-key.prefix-shortcut", null);
                return false;
            }
            int answer = GUIUtilities.confirm(GrabKeyDialog.this, "grab-key.duplicate-shortcut", new Object[]{other.label}, 0, 3);
            if (answer == 0) {
                if (other.shortcut != null && shortcutString.startsWith(other.shortcut)) {
                    other.shortcut = null;
                }
                GrabKeyDialog.this.isOK = true;
                return true;
            }
            return false;
        }
    }

    private class InputPane
    extends JTextField {
        protected String rawShortcut = "";

        private InputPane() {
        }

        @Override
        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        @Override
        public void setText(String s) {
            this.rawShortcut = s == null ? "" : s;
            super.setText(GUIUtilities.getPlatformShortcutLabel(s));
        }

        public String getShortcut() {
            return this.rawShortcut;
        }

        @Override
        protected void processKeyEvent(KeyEvent _evt) {
            String symbolicName;
            KeyEvent evt = KeyEventWorkaround.processKeyEvent(_evt);
            if (!KeyEventWorkaround.isBindable(_evt.getKeyCode())) {
                evt = null;
            }
            if (GrabKeyDialog.this.debugBuffer != null) {
                GrabKeyDialog.this.debugBuffer.insert(GrabKeyDialog.this.debugBuffer.getLength(), "Event " + AbstractInputHandler.toString(_evt) + (evt == null ? " filtered\n" : " passed\n"));
            }
            if (evt == null) {
                return;
            }
            evt.consume();
            KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(evt);
            if (Debug.DUMP_KEY_EVENTS) {
                Log.log(1, GrabKeyDialog.class, "processKeyEvent() key=" + key + ", _evt=" + _evt + '.');
            }
            if (key == null) {
                return;
            }
            if (GrabKeyDialog.this.debugBuffer != null) {
                GrabKeyDialog.this.debugBuffer.insert(GrabKeyDialog.this.debugBuffer.getLength(), "==> Translated to " + key + '\n');
            }
            StringBuilder keyString = new StringBuilder(this.getShortcut());
            if (this.getDocument().getLength() != 0) {
                keyString.append(' ');
            }
            if (key.modifiers != null) {
                keyString.append(key.modifiers).append('+');
            }
            if ((symbolicName = GrabKeyDialog.getSymbolicName(key.key)) != null) {
                keyString.append(symbolicName);
            } else if (key.input != '\u0000') {
                if (key.input == ' ') {
                    keyString.append("SPACE");
                } else {
                    keyString.append(key.input);
                }
            } else {
                return;
            }
            this.setText(keyString.toString());
            if (GrabKeyDialog.this.debugBuffer == null) {
                GrabKeyDialog.this.updateAssignedTo(keyString.toString());
            }
        }
    }

    public static class KeyBinding {
        public String name;
        public String label;
        public String shortcut;
        public boolean isPrefix;

        public KeyBinding(String name, String label, String shortcut, boolean isPrefix) {
            this.name = name;
            this.label = label;
            this.shortcut = shortcut;
            this.isPrefix = isPrefix;
        }

        public boolean isAssigned() {
            return this.shortcut != null && this.shortcut.length() > 0;
        }
    }
}

