/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.HashSet;
import javax.swing.UIManager;
import org.gjt.sp.util.Log;

public class OperatingSystem {
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int VMS = 912082;
    private static final int UNKNOWN = 2989;
    private static int os;
    private static boolean java16;
    private static int hasScreenMenuBar;

    public static Rectangle getScreenBounds() {
        int h;
        int w;
        int y;
        int x;
        int screenX = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int screenY = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (OperatingSystem.isMacOS()) {
            x = 0;
            y = 22;
            w = screenX;
            h = screenY - y - 4;
        } else if (OperatingSystem.isWindows()) {
            x = -4;
            y = -4;
            w = screenX - 2 * x;
            h = screenY - 2 * y;
        } else {
            x = 0;
            y = 0;
            w = screenX;
            h = screenY;
        }
        return new Rectangle(x, y, w, h);
    }

    public static Rectangle getScreenBounds(Rectangle window) {
        int h;
        int w;
        int y;
        int x;
        GraphicsDevice[] gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        HashSet<GraphicsConfiguration> intersects = new HashSet<GraphicsConfiguration>();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration gc = gd[i].getDefaultConfiguration();
            if (!window.intersects(gc.getBounds()) || intersects.contains(gc)) continue;
            intersects.add(gc);
        }
        GraphicsConfiguration choice = null;
        if (!intersects.isEmpty()) {
            for (GraphicsConfiguration gcc : intersects) {
                if (choice == null) {
                    choice = gcc;
                    continue;
                }
                Rectangle int1 = choice.getBounds().intersection(window);
                Rectangle int2 = gcc.getBounds().intersection(window);
                int area2 = int2.width * int2.height;
                int area1 = int1.width * int1.height;
                if (area2 <= area1) continue;
                choice = gcc;
            }
        } else {
            choice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int screenX = choice.getBounds().x;
        int screenY = choice.getBounds().y;
        int screenW = choice.getBounds().width;
        int screenH = choice.getBounds().height;
        if (OperatingSystem.isMacOS()) {
            x = screenX;
            y = screenY + 22;
            w = screenW;
            h = screenH - y - 4;
        } else {
            x = screenX;
            y = screenY;
            w = screenW;
            h = screenH;
        }
        return new Rectangle(x, y, w, h);
    }

    public static boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static boolean isWindows9x() {
        return os == 1600;
    }

    public static boolean isWindowsNT() {
        return os == 1638;
    }

    public static boolean isOS2() {
        return os == 57005;
    }

    public static boolean isUnix() {
        return os == 201527 || os == 2748;
    }

    public static boolean isMacOS() {
        return os == 2748;
    }

    public static boolean isX11() {
        return os == 201527;
    }

    public static boolean isVMS() {
        return os == 912082;
    }

    public static boolean isMacOSLF() {
        return OperatingSystem.isMacOS() && UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static boolean hasScreenMenuBar() {
        if (!OperatingSystem.isMacOS()) {
            return false;
        }
        if (hasScreenMenuBar == -1) {
            String result = System.getProperty("apple.laf.useScreenMenuBar");
            if (result == null) {
                result = System.getProperty("com.apple.macos.useScreenMenuBar");
            }
            hasScreenMenuBar = "true".equals(result) ? 1 : 0;
        }
        return hasScreenMenuBar == 1;
    }

    public static boolean hasJava16() {
        return java16;
    }

    public static boolean isCaseInsensitiveFS() {
        return OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS();
    }

    static {
        hasScreenMenuBar = -1;
        if (System.getProperty("mrj.version") != null) {
            os = 2748;
        } else {
            String osName = System.getProperty("os.name");
            if (osName.contains("Windows 9") || osName.contains("Windows M")) {
                os = 1600;
            } else if (osName.contains("Windows")) {
                os = 1638;
            } else if (osName.contains("OS/2")) {
                os = 57005;
            } else if (osName.contains("Mac OS X")) {
                os = 2748;
            } else if (osName.contains("VMS")) {
                os = 912082;
            } else if (File.separatorChar == '/') {
                os = 201527;
            } else {
                os = 2989;
                Log.log(7, OperatingSystem.class, "Unknown operating system: " + osName);
            }
        }
        String javaVersion = System.getProperty("jedit.force.java.version");
        if (javaVersion == null || javaVersion.length() == 0) {
            javaVersion = System.getProperty("java.version");
        }
        if (javaVersion == null || javaVersion.length() == 0) {
            javaVersion = System.getProperty("java.runtime.version");
        }
        java16 = javaVersion.compareTo("1.6") >= 0;
    }
}

