/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class BufferHistory {
    private static LinkedList<Entry> history = new LinkedList();
    private static final ReentrantReadWriteLock historyLock = new ReentrantReadWriteLock();
    private static SettingsXML recentXML;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getEntry(String path) {
        historyLock.readLock().lock();
        try {
            for (Entry entry : history) {
                if (!MiscUtilities.pathsEqual(entry.path, path)) continue;
                Entry entry2 = entry;
                return entry2;
            }
        }
        finally {
            historyLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEntry(String path, int caret, Selection[] selection, String encoding, String mode) {
        Entry entry = new Entry(path, caret, BufferHistory.selectionToString(selection), encoding, mode);
        historyLock.writeLock().lock();
        try {
            BufferHistory.removeEntry(path);
            BufferHistory.addEntry(entry);
        }
        finally {
            historyLock.writeLock().unlock();
        }
        BufferHistory.notifyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        historyLock.writeLock().lock();
        try {
            history.clear();
        }
        finally {
            historyLock.writeLock().unlock();
        }
        BufferHistory.notifyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Entry> getHistory() {
        historyLock.readLock().lock();
        try {
            List list = (List)history.clone();
            return list;
        }
        finally {
            historyLock.readLock().unlock();
        }
    }

    public static void load() {
        if (recentXML == null) {
            return;
        }
        if (!recentXML.fileExists()) {
            return;
        }
        Log.log(3, BufferHistory.class, "Loading " + recentXML);
        RecentHandler handler = new RecentHandler();
        try {
            recentXML.load(handler);
        }
        catch (IOException e) {
            Log.log(9, BufferHistory.class, e);
        }
        BufferHistory.trimToLimit(handler.result);
        history = handler.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (recentXML == null) {
            return;
        }
        if (recentXML.hasChangedOnDisk()) {
            Log.log(7, BufferHistory.class, recentXML + " changed on disk; will not save recent" + " files");
            return;
        }
        Log.log(3, BufferHistory.class, "Saving " + recentXML);
        String lineSep = System.getProperty("line.separator");
        SettingsXML.Saver out = null;
        try {
            out = recentXML.openSaver();
            out.writeXMLDeclaration();
            out.write("<!DOCTYPE RECENT SYSTEM \"recent.dtd\">");
            out.write(lineSep);
            out.write("<RECENT>");
            out.write(lineSep);
            List<Entry> snapshot = BufferHistory.getHistory();
            for (Entry entry : snapshot) {
                out.write("<ENTRY>");
                out.write(lineSep);
                out.write("<PATH>");
                out.write(XMLUtilities.charsToEntities(entry.path, false));
                out.write("</PATH>");
                out.write(lineSep);
                out.write("<CARET>");
                out.write(String.valueOf(entry.caret));
                out.write("</CARET>");
                out.write(lineSep);
                if (entry.selection != null && entry.selection.length() > 0) {
                    out.write("<SELECTION>");
                    out.write(entry.selection);
                    out.write("</SELECTION>");
                    out.write(lineSep);
                }
                if (entry.encoding != null) {
                    out.write("<ENCODING>");
                    out.write(entry.encoding);
                    out.write("</ENCODING>");
                    out.write(lineSep);
                }
                if (entry.mode != null) {
                    out.write("<MODE>");
                    out.write(entry.mode);
                    out.write("</MODE>");
                    out.write(lineSep);
                }
                out.write("</ENTRY>");
                out.write(lineSep);
            }
            out.write("</RECENT>");
            out.write(lineSep);
            out.finish();
        }
        catch (Exception e) {
            Log.log(9, BufferHistory.class, e);
        }
        finally {
            IOUtilities.closeQuietly(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Entry entry) {
        historyLock.writeLock().lock();
        try {
            history.addFirst(entry);
            BufferHistory.trimToLimit(history);
        }
        finally {
            historyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeEntry(String path) {
        historyLock.writeLock().lock();
        try {
            Iterator iter = history.iterator();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                if (!MiscUtilities.pathsEqual(path, entry.path)) continue;
                iter.remove();
                return;
            }
        }
        finally {
            historyLock.writeLock().unlock();
        }
    }

    private static String selectionToString(Selection[] s) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            Selection sel;
            if (i != 0) {
                buf.append(' ');
            }
            if ((sel = s[i]) instanceof Selection.Range) {
                buf.append("range ");
            } else {
                buf.append("rect ");
            }
            buf.append(sel.getStart());
            buf.append(' ');
            buf.append(sel.getEnd());
        }
        return buf.toString();
    }

    private static Selection[] stringToSelection(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<Selection.Range> selection = new ArrayList<Selection.Range>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String type = st.nextToken();
            int start = Integer.parseInt(st.nextToken());
            int end = Integer.parseInt(st.nextToken());
            if (end < start) continue;
            Selection sel = "range".equals(type) ? new Selection.Range(start, end) : new Selection.Rect(start, end);
            selection.add((Selection.Range)sel);
        }
        Selection[] returnValue = new Selection[selection.size()];
        returnValue = selection.toArray(returnValue);
        return returnValue;
    }

    private static void trimToLimit(Deque<Entry> list) {
        int max = jEdit.getIntegerProperty("recentFiles", 50);
        while (list.size() > max) {
            list.removeLast();
        }
    }

    private static void notifyChange() {
        EditBus.send(new DynamicMenuChanged("recent-files"));
    }

    static {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            recentXML = new SettingsXML(settingsDirectory, "recent");
        }
    }

    private static class RecentHandler
    extends DefaultHandler {
        public LinkedList<Entry> result = new LinkedList();
        private String path;
        private int caret;
        private String selection;
        private String encoding;
        private String mode;
        private final StringBuilder charData = new StringBuilder();

        private RecentHandler() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return XMLUtilities.findEntity(systemId, "recent.dtd", this.getClass());
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if ("ENTRY".equals(name)) {
                this.result.addLast(new Entry(this.path, this.caret, this.selection, this.encoding, this.mode));
                this.path = null;
                this.caret = 0;
                this.selection = null;
                this.encoding = null;
                this.mode = null;
            } else if ("PATH".equals(name)) {
                this.path = this.charData.toString();
            } else if ("CARET".equals(name)) {
                try {
                    String s = this.charData.toString().trim();
                    if (s.length() != this.charData.length()) {
                        Log.log(7, this, "The caret position in recent.xml was wrong: '" + this.charData + "', fixing it");
                    }
                    this.caret = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    Log.log(9, this, "Unable to parse caret position " + this.charData);
                }
            } else if ("SELECTION".equals(name)) {
                this.selection = this.charData.toString();
            } else if ("ENCODING".equals(name)) {
                this.encoding = this.charData.toString();
            } else if ("MODE".equals(name)) {
                this.mode = this.charData.toString();
            }
            this.charData.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charData.append(ch, start, length);
        }
    }

    public static class Entry {
        public String path;
        public int caret;
        public String selection;
        public String encoding;
        public String mode;

        public Selection[] getSelection() {
            return BufferHistory.stringToSelection(this.selection);
        }

        public Entry(String path, int caret, String selection, String encoding, String mode) {
            this.path = path;
            this.caret = caret;
            this.selection = selection;
            this.encoding = encoding;
            this.mode = mode;
        }

        public String toString() {
            return this.path + ": " + this.caret;
        }
    }
}

