/*
 * Decompiled with CFR 0.152.
 */
package gatchan.jedit.hyperlinks;

import gatchan.jedit.hyperlinks.HyperlinkManager;
import gatchan.jedit.hyperlinks.HyperlinkTextAreaPainter;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class HyperlinksPlugin
extends EBPlugin {
    public void start() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                JEditTextArea textArea = panes[i].getTextArea();
                HyperlinksPlugin.initTextArea(textArea);
            }
        }
    }

    public void stop() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                JEditTextArea textArea = panes[i].getTextArea();
                HyperlinksPlugin.uninitTextArea(textArea);
            }
        }
    }

    private static void uninitTextArea(JEditTextArea textArea) {
        HyperlinkManager clientProperty = (HyperlinkManager)textArea.getClientProperty(HyperlinkManager.class);
        clientProperty.dispose();
        textArea.putClientProperty(HyperlinkManager.class, null);
    }

    private static void initTextArea(JEditTextArea textArea) {
        textArea.putClientProperty(HyperlinkManager.class, (Object)new HyperlinkManager(textArea));
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof EditPaneUpdate) {
            HyperlinksPlugin.handleEditPaneMessage((EditPaneUpdate)message);
        } else if (message instanceof PropertiesChanged) {
            HyperlinkTextAreaPainter.color = jEdit.getColorProperty((String)"options.hyperlink.color.value");
        }
    }

    private static void handleEditPaneMessage(EditPaneUpdate message) {
        JEditTextArea textArea = message.getEditPane().getTextArea();
        Object what = message.getWhat();
        if (what == EditPaneUpdate.CREATED) {
            HyperlinksPlugin.initTextArea(textArea);
        } else if (what == EditPaneUpdate.DESTROYED) {
            HyperlinksPlugin.uninitTextArea(textArea);
        }
    }
}

