/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.BufferOutput;
import console.Console;
import console.Output;
import console.Shell;
import console.commando.CommandoHandler;
import java.awt.Component;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;

class CommandoThread
extends Thread {
    private Console console;
    private Vector commands;

    CommandoThread(Console console, Vector commands) {
        this.console = console;
        this.commands = commands;
    }

    public void run() {
        final View view = this.console.getView();
        final CommandoHandler.Command[] lastCommand = new CommandoHandler.Command[1];
        final boolean[] returnValue = new boolean[]{true};
        for (int i = 0; i < this.commands.size(); ++i) {
            final CommandoHandler.Command command = (CommandoHandler.Command)this.commands.elementAt(i);
            final Shell shell = this.console.setShell(command.shell);
            if (shell == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GUIUtilities.error((Component)view, (String)"commando.bad-shell", (Object[])new String[]{command.shell});
                    }
                });
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (!returnValue[0] && GUIUtilities.confirm((Component)view, (String)"commando.exit-status", (Object[])new String[]{lastCommand[0].command}, (int)0, (int)0) != 0) {
                            return;
                        }
                        if (command.confirm && GUIUtilities.confirm((Component)view, (String)"commando.confirm", (Object[])new String[]{command.command}, (int)0, (int)3) != 0) {
                            return;
                        }
                        Output out = CommandoThread.this.console.getOutput();
                        if (command.toBuffer) {
                            out = new BufferOutput(CommandoThread.this.console, command.mode);
                        }
                        CommandoThread.this.console.run(shell, null, out, null, command.command);
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
            returnValue[0] = shell.waitFor(this.console);
            lastCommand[0] = command;
        }
    }
}

