/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Color;
import java.awt.Font;
import java.util.Locale;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class SyntaxUtilities {
    public static IPropertyManager propertyManager;
    private static volatile StyleExtender _styleExtender;

    public static String getColorHexString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static Color parseColor(String name, Color defaultColor) {
        if (name == null || name.length() == 0) {
            return defaultColor;
        }
        if (name.charAt(0) == '#') {
            try {
                return Color.decode(name);
            }
            catch (NumberFormatException nf) {
                return defaultColor;
            }
        }
        if ("red".equals(name)) {
            return Color.red;
        }
        if ("green".equals(name)) {
            return Color.green;
        }
        if ("blue".equals(name)) {
            return Color.blue;
        }
        if ("yellow".equals(name)) {
            return Color.yellow;
        }
        if ("orange".equals(name)) {
            return Color.orange;
        }
        if ("white".equals(name)) {
            return Color.white;
        }
        if ("lightGray".equals(name)) {
            return Color.lightGray;
        }
        if ("gray".equals(name)) {
            return Color.gray;
        }
        if ("darkGray".equals(name)) {
            return Color.darkGray;
        }
        if ("black".equals(name)) {
            return Color.black;
        }
        if ("cyan".equals(name)) {
            return Color.cyan;
        }
        if ("magenta".equals(name)) {
            return Color.magenta;
        }
        if ("pink".equals(name)) {
            return Color.pink;
        }
        return defaultColor;
    }

    public static SyntaxStyle parseStyle(String str, String family, int size, boolean color, Color defaultFgColor) throws IllegalArgumentException {
        Color fgColor = defaultFgColor;
        Color bgColor = null;
        boolean italic = false;
        boolean bold = false;
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("color:")) {
                if (!color) continue;
                fgColor = SyntaxUtilities.parseColor(s.substring(6), Color.black);
                continue;
            }
            if (s.startsWith("bgColor:")) {
                if (!color) continue;
                bgColor = SyntaxUtilities.parseColor(s.substring(8), null);
                continue;
            }
            if (s.startsWith("style:")) {
                for (int i = 6; i < s.length(); ++i) {
                    if (s.charAt(i) == 'i') {
                        italic = true;
                        continue;
                    }
                    if (s.charAt(i) == 'b') {
                        bold = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + s);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + s);
        }
        return new SyntaxStyle(fgColor, bgColor, new Font(family, (italic ? 2 : 0) | (bold ? 1 : 0), size));
    }

    public static SyntaxStyle parseStyle(String str, String family, int size, boolean color) throws IllegalArgumentException {
        return SyntaxUtilities.parseStyle(str, family, size, color, Color.black);
    }

    public static SyntaxStyle[] loadStyles(String family, int size) {
        return SyntaxUtilities.loadStyles(family, size, true);
    }

    public static void setStyleExtender(StyleExtender ext) {
        _styleExtender = ext;
    }

    public static SyntaxStyle[] loadStyles(String family, int size, boolean color) {
        SyntaxStyle[] styles = new SyntaxStyle[19];
        for (int i = 1; i < styles.length; ++i) {
            try {
                String styleName = "view.style." + Token.tokenToString((byte)i).toLowerCase(Locale.ENGLISH);
                styles[i] = SyntaxUtilities.parseStyle(propertyManager.getProperty(styleName), family, size, color);
                continue;
            }
            catch (Exception e) {
                Log.log(9, StandardUtilities.class, e);
            }
        }
        styles[0] = new SyntaxStyle(Color.black, null, new Font(family, 0, size));
        return _styleExtender.extendStyles(styles);
    }

    private SyntaxUtilities() {
    }

    static {
        _styleExtender = new StyleExtender();
    }

    public static class StyleExtender {
        public SyntaxStyle[] extendStyles(SyntaxStyle[] styles) {
            return styles;
        }
    }
}

