/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

class InputMethodSupport
extends TextAreaExtension
implements InputMethodRequests,
InputMethodListener {
    private TextArea owner;
    private TextLayout composedTextLayout = null;
    private int composedCaretX = 0;
    private int lastCommittedAt = 0;
    private String lastCommittedText = null;

    public InputMethodSupport(TextArea owner) {
        this.owner = owner;
        owner.addInputMethodListener(this);
        owner.getPainter().addExtension(Integer.MAX_VALUE, this);
    }

    private Rectangle getCaretRectangle(int x, int y) {
        TextAreaPainter painter = this.owner.getPainter();
        Point origin = painter.getLocationOnScreen();
        int height = painter.getFontMetrics().getHeight();
        return new Rectangle(origin.x + x, origin.y + y, 0, height);
    }

    @Override
    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        int caret;
        if (this.composedTextLayout != null && start <= (caret = this.owner.getCaretPosition()) && caret < end) {
            TextAreaPainter painter = this.owner.getPainter();
            FontMetrics fm = painter.getFontMetrics();
            int x = this.owner.offsetToXY((int)caret).x;
            int width = Math.round(this.composedTextLayout.getAdvance());
            int height = fm.getHeight();
            int offset_to_baseline = height - (fm.getLeading() + 1) - fm.getDescent();
            int caret_x = x + this.composedCaretX;
            gfx.setColor(painter.getBackground());
            gfx.fillRect(x, y, width, height);
            gfx.setColor(painter.getForeground());
            this.composedTextLayout.draw(gfx, x, y + offset_to_baseline);
            gfx.setColor(painter.getCaretColor());
            gfx.drawLine(caret_x, y, caret_x, y + height - 1);
        }
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        if (this.composedTextLayout != null) {
            Point caret = this.owner.offsetToXY(this.owner.getCaretPosition());
            return this.getCaretRectangle(caret.x + this.composedCaretX, caret.y);
        }
        Selection selection_on_caret = this.owner.getSelectionAtOffset(this.owner.getCaretPosition());
        if (selection_on_caret != null) {
            Point selection_start = this.owner.offsetToXY(selection_on_caret.getStart());
            return this.getCaretRectangle(selection_start.x, selection_start.y);
        }
        return null;
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        if (this.composedTextLayout != null) {
            Point origin = this.owner.getPainter().getLocationOnScreen();
            Point caret = this.owner.offsetToXY(this.owner.getCaretPosition());
            float local_x = x - origin.x - caret.x;
            float local_y = (float)(y - origin.y - caret.y) - (this.composedTextLayout.getLeading() + 1.0f) - this.composedTextLayout.getAscent();
            return this.composedTextLayout.hitTestChar(local_x, local_y);
        }
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return this.owner.getCaretPosition();
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return new AttributedString(this.owner.getText(beginIndex, endIndex - beginIndex)).getIterator();
    }

    @Override
    public int getCommittedTextLength() {
        return this.owner.getBufferLength();
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        if (this.lastCommittedText != null) {
            int offset = this.lastCommittedAt;
            int length = this.lastCommittedText.length();
            String sample = this.owner.getText(offset, length);
            if (sample != null && sample.equals(this.lastCommittedText)) {
                AttributedCharacterIterator canceled = new AttributedString(sample).getIterator();
                this.owner.getBuffer().remove(offset, length);
                this.owner.setCaretPosition(offset);
                this.lastCommittedText = null;
                return canceled;
            }
            this.lastCommittedText = null;
        }
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        Selection selection_on_caret = this.owner.getSelectionAtOffset(this.owner.getCaretPosition());
        if (selection_on_caret != null) {
            return new AttributedString(this.owner.getSelectedText(selection_on_caret)).getIterator();
        }
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.composedTextLayout = null;
        AttributedCharacterIterator text = event.getText();
        if (text != null) {
            int end_index;
            int committed_count = event.getCommittedCharacterCount();
            if (committed_count > 0) {
                this.lastCommittedText = null;
                this.lastCommittedAt = this.owner.getCaretPosition();
                StringBuilder committed = new StringBuilder(committed_count);
                char c = text.first();
                for (int count = committed_count; c != '\uffff' && count > 0; --count) {
                    this.owner.userInput(c);
                    committed.append(c);
                    c = text.next();
                }
                this.lastCommittedText = committed.toString();
            }
            if (committed_count < (end_index = text.getEndIndex())) {
                AttributedString composed = new AttributedString(text, committed_count, end_index);
                TextAreaPainter painter = this.owner.getPainter();
                composed.addAttribute(TextAttribute.FONT, painter.getFont());
                this.composedTextLayout = new TextLayout(composed.getIterator(), painter.getFontRenderContext());
            }
        }
        this.caretPositionChanged(event);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.composedCaretX = 0;
        if (this.composedTextLayout != null) {
            TextHitInfo caret = event.getCaret();
            if (caret != null) {
                this.composedCaretX = Math.round(this.composedTextLayout.getCaretInfo(caret)[0]);
            }
            int insertion_x = this.owner.offsetToXY((int)this.owner.getCaretPosition()).x;
            TextHitInfo visible = event.getVisiblePosition();
            int composed_visible_x = visible != null ? Math.round(this.composedTextLayout.getCaretInfo(visible)[0]) : this.composedCaretX;
            int visible_x = insertion_x + composed_visible_x;
            int painter_width = this.owner.getPainter().getWidth();
            int adjustment = 0;
            if (visible_x < 0) {
                adjustment = visible_x;
            }
            if (visible_x >= painter_width) {
                adjustment = visible_x - (painter_width - 1);
            }
            if (adjustment != 0) {
                this.owner.setHorizontalOffset(this.owner.getHorizontalOffset() - adjustment);
            }
        } else {
            this.owner.scrollToCaret(false);
        }
        int caret_line = this.owner.getCaretLine();
        this.owner.invalidateLineRange(caret_line, caret_line + 1);
        event.consume();
    }
}

