/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.FoldPainter;
import org.gjt.sp.jedit.textarea.GutterPopupHandler;
import org.gjt.sp.jedit.textarea.MouseActionsProvider;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TriangleFoldPainter;
import org.gjt.sp.util.Log;

public class Gutter
extends JComponent
implements SwingConstants {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    public static final String FOLD_PAINTER_PROPERTY = "foldPainter";
    public static final String FOLD_PAINTER_SERVICE = "org.gjt.sp.jedit.textarea.FoldPainter";
    public static final String DEFAULT_FOLD_PAINTER_SERVICE = "Triangle";
    private static final int FOLD_MARKER_SIZE = 12;
    private static final int SELECTION_GUTTER_WIDTH = 12;
    private boolean enabled;
    private final TextArea textArea;
    private MouseHandler mouseHandler;
    private ExtensionManager extensionMgr;
    private Dimension gutterSize = new Dimension(0, 0);
    private Dimension collapsedSize = new Dimension(0, 0);
    private int lineNumberWidth;
    private Dimension disabledSize = new Dimension(0, 0);
    private Color intervalHighlight;
    private Color currentLineHighlight;
    private Color foldColor;
    private Color selectionAreaBgColor;
    private FontMetrics fm;
    private int alignment;
    private int interval;
    private boolean currentLineHighlightEnabled;
    private boolean expanded;
    private boolean selectionAreaEnabled;
    private boolean structureHighlight;
    private Color structureHighlightColor;
    private int borderWidth;
    private Border focusBorder;
    private Border noFocusBorder;
    private FoldPainter foldPainter;
    private JEditBuffer buffer;
    private BufferListener bufferListener;
    private int minLineNumberDigits;
    private int selectionAreaWidth;

    public void setFoldPainter(FoldPainter painter) {
        this.foldPainter = painter == null ? new TriangleFoldPainter() : painter;
    }

    public Gutter(TextArea textArea) {
        this.textArea = textArea;
        this.enabled = true;
        this.selectionAreaEnabled = true;
        this.selectionAreaWidth = 12;
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.extensionMgr = new ExtensionManager();
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.bufferListener = new BufferAdapter(){

            @Override
            public void bufferLoaded(JEditBuffer buffer) {
                Gutter.this.updateLineNumberWidth();
            }

            @Override
            public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
                Gutter.this.updateLineNumberWidth();
            }

            @Override
            public void contentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
                Gutter.this.updateLineNumberWidth();
            }
        };
        this.updateBorder();
        this.setFoldPainter(textArea.getFoldPainter());
    }

    @Override
    public void paintComponent(Graphics _gfx) {
        Graphics2D gfx = (Graphics2D)_gfx;
        gfx.setRenderingHints(this.textArea.getPainter().renderingHints);
        Rectangle clip = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        int bgColorWidth = this.isSelectionAreaEnabled() ? 12 : clip.width;
        gfx.fillRect(clip.x, clip.y, bgColorWidth, clip.height);
        if (this.isSelectionAreaEnabled()) {
            if (this.selectionAreaBgColor == null) {
                this.selectionAreaBgColor = this.getBackground();
            }
            gfx.setColor(this.selectionAreaBgColor);
            gfx.fillRect(clip.x + 12, clip.y, clip.width - 12, clip.height);
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        int lineHeight = this.textArea.getPainter().getFontMetrics().getHeight();
        if (lineHeight == 0) {
            return;
        }
        int lastLine = (clip.y + clip.height - 1) / lineHeight;
        int firstLine = clip.y / lineHeight;
        if (lastLine - firstLine > this.textArea.getVisibleLines()) {
            Log.log(9, this, "BUG: firstLine=" + firstLine);
            Log.log(9, this, "     lastLine=" + lastLine);
            Log.log(9, this, "     visibleLines=" + this.textArea.getVisibleLines());
            Log.log(9, this, "     height=" + this.getHeight());
            Log.log(9, this, "     painter.height=" + this.textArea.getPainter().getHeight());
            Log.log(9, this, "     clip.y=" + clip.y);
            Log.log(9, this, "     clip.height=" + clip.height);
            Log.log(9, this, "     lineHeight=" + lineHeight);
        }
        int y = clip.y - clip.y % lineHeight;
        this.extensionMgr.paintScreenLineRange(this.textArea, gfx, firstLine, lastLine, y, lineHeight);
        int line = firstLine;
        while (line <= lastLine) {
            this.paintLine(gfx, line, y);
            ++line;
            y += lineHeight;
        }
    }

    public void addExtension(TextAreaExtension extension) {
        this.extensionMgr.addExtension(0, extension);
        this.repaint();
    }

    public void addExtension(int layer, TextAreaExtension extension) {
        this.extensionMgr.addExtension(layer, extension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension extension) {
        this.extensionMgr.removeExtension(extension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.textArea.getBuffer().isLoading()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(evt.getX(), evt.getY());
    }

    public void setBorder(int width, Color color1, Color color2, Color color3) {
        this.borderWidth = width;
        this.focusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, width, color3), new MatteBorder(0, 0, 0, width, color1));
        this.noFocusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, width, color3), new MatteBorder(0, 0, 0, width, color2));
        this.updateBorder();
    }

    public void updateBorder() {
        if (this.textArea.hasFocus()) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (border == null) {
            this.collapsedSize.width = 0;
            this.collapsedSize.height = 0;
        } else {
            Insets insets = border.getBorderInsets(this);
            this.collapsedSize.width = 12 + insets.right;
            if (this.isSelectionAreaEnabled()) {
                this.collapsedSize.width += this.selectionAreaWidth;
            }
            this.collapsedSize.height = this.gutterSize.height = insets.top + insets.bottom;
            this.lineNumberWidth = this.fm.charWidth('5') * this.getLineNumberDigitCount();
            this.gutterSize.width = 12 + insets.right + this.lineNumberWidth;
        }
        this.revalidate();
    }

    public void setMinLineNumberDigitCount(int min) {
        if (min == this.minLineNumberDigits) {
            return;
        }
        this.minLineNumberDigits = min;
        if (this.textArea.getBuffer() != null) {
            this.updateLineNumberWidth();
        }
    }

    private int getMinLineNumberDigitCount() {
        return this.minLineNumberDigits;
    }

    private int getLineNumberDigitCount() {
        JEditBuffer buf = this.textArea.getBuffer();
        int minDigits = this.getMinLineNumberDigitCount();
        if (buf == null) {
            return minDigits;
        }
        int count = buf.getLineCount();
        int digits = 0;
        while (count > 0) {
            count /= 10;
            ++digits;
        }
        return digits < minDigits ? minDigits : digits;
    }

    void setBuffer(JEditBuffer newBuffer) {
        if (this.buffer != null) {
            this.buffer.removeBufferListener(this.bufferListener);
        }
        this.buffer = newBuffer;
        if (this.buffer != null) {
            this.buffer.addBufferListener(this.bufferListener);
        }
        this.updateLineNumberWidth();
    }

    private void updateLineNumberWidth() {
        Font f = this.getFont();
        if (f != null) {
            this.setFont(this.getFont());
        }
    }

    void dispose() {
        if (this.buffer != null) {
            this.buffer.removeBufferListener(this.bufferListener);
            this.buffer = null;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        Border border = this.getBorder();
        if (border != null) {
            this.lineNumberWidth = this.fm.charWidth('5') * this.getLineNumberDigitCount();
            this.gutterSize.width = 12 + border.getBorderInsets((Component)this).right + this.lineNumberWidth;
            this.revalidate();
        }
    }

    public void setGutterEnabled(boolean enabled) {
        this.enabled = enabled;
        this.revalidate();
    }

    public boolean isSelectionAreaEnabled() {
        return this.selectionAreaEnabled;
    }

    public void setSelectionAreaEnabled(boolean enabled) {
        if (this.isSelectionAreaEnabled() == enabled) {
            return;
        }
        this.selectionAreaEnabled = enabled;
        this.collapsedSize.width = enabled ? (this.collapsedSize.width += this.selectionAreaWidth) : (this.collapsedSize.width -= this.selectionAreaWidth);
        this.revalidate();
    }

    public void setSelectionAreaBackground(Color bgColor) {
        this.selectionAreaBgColor = bgColor;
        this.repaint();
    }

    public void setSelectionAreaWidth(int width) {
        this.selectionAreaWidth = width;
        this.revalidate();
    }

    public Color getHighlightedForeground() {
        return this.intervalHighlight;
    }

    public void setHighlightedForeground(Color highlight) {
        this.intervalHighlight = highlight;
    }

    public Color getCurrentLineForeground() {
        return this.currentLineHighlight;
    }

    public void setCurrentLineForeground(Color highlight) {
        this.currentLineHighlight = highlight;
    }

    public Color getFoldColor() {
        return this.foldColor;
    }

    public void setFoldColor(Color foldColor) {
        this.foldColor = foldColor;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.enabled) {
            return this.disabledSize;
        }
        if (this.expanded) {
            return this.gutterSize;
        }
        return this.collapsedSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getLineNumberAlignment() {
        return this.alignment;
    }

    public void setLineNumberAlignment(int alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.repaint();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        this.textArea.revalidate();
    }

    public void toggleExpanded() {
        this.setExpanded(!this.expanded);
    }

    public int getHighlightInterval() {
        return this.interval;
    }

    public void setHighlightInterval(int interval) {
        if (interval <= 1) {
            interval = 0;
        }
        this.interval = interval;
        this.repaint();
    }

    public boolean isCurrentLineHighlightEnabled() {
        return this.currentLineHighlightEnabled;
    }

    public void setCurrentLineHighlightEnabled(boolean enabled) {
        if (this.currentLineHighlightEnabled == enabled) {
            return;
        }
        this.currentLineHighlightEnabled = enabled;
        this.repaint();
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color structureHighlightColor) {
        this.structureHighlightColor = structureHighlightColor;
        this.repaint();
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean structureHighlight) {
        this.structureHighlight = structureHighlight;
        this.repaint();
    }

    public void setSelectionPopupHandler(GutterPopupHandler handler) {
        this.mouseHandler.selectionPopupHandler = handler;
    }

    public GutterPopupHandler getSelectionPopupHandler() {
        return this.mouseHandler.selectionPopupHandler;
    }

    public void setMouseActionsProvider(MouseActionsProvider mouseActionsProvider) {
        this.mouseHandler.mouseActions = mouseActionsProvider;
    }

    private void paintLine(Graphics2D gfx, int line, int y) {
        JEditBuffer buffer = this.textArea.getBuffer();
        if (buffer.isLoading()) {
            return;
        }
        FontMetrics textAreaFm = this.textArea.getPainter().getFontMetrics();
        int lineHeight = textAreaFm.getHeight();
        int baseline = textAreaFm.getAscent();
        ChunkCache.LineInfo info = this.textArea.chunkCache.getLineInfo(line);
        int physicalLine = info.physicalLine;
        if (physicalLine == -1) {
            return;
        }
        boolean drawFoldMiddle = true;
        if (info.firstSubregion && buffer.isFoldStart(physicalLine)) {
            drawFoldMiddle = false;
            this.foldPainter.paintFoldStart(this, gfx, line, physicalLine, this.textArea.displayManager.isLineVisible(physicalLine + 1), y, lineHeight, buffer);
        } else if (info.lastSubregion && buffer.isFoldEnd(physicalLine)) {
            drawFoldMiddle = false;
            this.foldPainter.paintFoldEnd(this, gfx, line, physicalLine, y, lineHeight, buffer);
        } else if (this.structureHighlight) {
            StructureMatcher.Match match = this.textArea.getStructureMatch();
            int caretLine = this.textArea.getCaretLine();
            if (this.textArea.isStructureHighlightVisible() && physicalLine >= Math.min(caretLine, match.startLine) && physicalLine <= Math.max(caretLine, match.startLine)) {
                int structScreenLine;
                int caretScreenLine = caretLine > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(this.textArea.getCaretLine()) ? this.textArea.getScreenLineOfOffset(this.textArea.getCaretPosition()) : -1);
                if (caretScreenLine > (structScreenLine = match.startLine > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(match.startLine) ? this.textArea.getScreenLineOfOffset(match.start) : -1))) {
                    int tmp = caretScreenLine;
                    caretScreenLine = structScreenLine;
                    structScreenLine = tmp;
                }
                gfx.setColor(this.structureHighlightColor);
                drawFoldMiddle = false;
                if (structScreenLine == caretScreenLine) {
                    drawFoldMiddle = true;
                } else if (line == caretScreenLine) {
                    gfx.fillRect(5, y + lineHeight / 2, 5, 2);
                    gfx.fillRect(5, y + lineHeight / 2, 2, lineHeight - lineHeight / 2);
                } else if (line == structScreenLine) {
                    gfx.fillRect(5, y, 2, lineHeight / 2);
                    gfx.fillRect(5, y + lineHeight / 2, 5, 2);
                } else if (line > caretScreenLine && line < structScreenLine) {
                    gfx.fillRect(5, y, 2, lineHeight);
                }
            }
        }
        if (drawFoldMiddle && buffer.getFoldLevel(physicalLine) > 0) {
            this.foldPainter.paintFoldMiddle(this, gfx, line, physicalLine, y, lineHeight, buffer);
        }
        if (info.firstSubregion && this.expanded) {
            int offset;
            String number = Integer.toString(physicalLine + 1);
            switch (this.alignment) {
                case 4: {
                    offset = this.lineNumberWidth - (this.fm.stringWidth(number) + 1);
                    break;
                }
                case 0: {
                    offset = (this.lineNumberWidth - this.fm.stringWidth(number)) / 2;
                    break;
                }
                default: {
                    offset = 0;
                }
            }
            if (physicalLine == this.textArea.getCaretLine() && this.currentLineHighlightEnabled) {
                gfx.setColor(this.currentLineHighlight);
            } else if (this.interval > 1 && (physicalLine + 1) % this.interval == 0) {
                gfx.setColor(this.intervalHighlight);
            } else {
                gfx.setColor(this.getForeground());
            }
            gfx.drawString(number, 12 + offset, baseline + y);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseActionsProvider mouseActions;
        boolean drag;
        int toolTipInitialDelay;
        int toolTipReshowDelay;
        boolean selectLines;
        int selAnchorLine;
        GutterPopupHandler selectionPopupHandler;

        MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.toolTipInitialDelay = ttm.getInitialDelay();
            this.toolTipReshowDelay = ttm.getReshowDelay();
            ttm.setInitialDelay(0);
            ttm.setReshowDelay(0);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.toolTipInitialDelay);
            ttm.setReshowDelay(this.toolTipReshowDelay);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean outsideGutter;
            Gutter.this.textArea.requestFocus();
            boolean bl = outsideGutter = e.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2;
            if (TextAreaMouseHandler.isPopupTrigger(e) || outsideGutter) {
                if (this.selectionPopupHandler != null && !outsideGutter && e.getX() > 12) {
                    int screenLine = e.getY() / Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                    int line = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)screenLine).physicalLine;
                    if (line >= 0) {
                        this.selectionPopupHandler.handlePopup(e.getX(), e.getY(), line);
                        return;
                    }
                }
                e.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mousePressed(e);
                this.drag = true;
            } else {
                String variant;
                String defaultAction;
                JEditBuffer buffer = Gutter.this.textArea.getBuffer();
                int screenLine = e.getY() / Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                int line = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)screenLine).physicalLine;
                if (line == -1) {
                    return;
                }
                if (e.getX() >= 12) {
                    Selection.Range s = new Selection.Range(Gutter.this.textArea.getLineStartOffset(line), this.getFoldEndOffset(line));
                    if (Gutter.this.textArea.isMultipleSelectionEnabled()) {
                        Gutter.this.textArea.addToSelection(s);
                    } else {
                        Gutter.this.textArea.setSelection(s);
                    }
                    this.selectLines = true;
                    this.selAnchorLine = line;
                    return;
                }
                if (buffer.isFoldStart(line)) {
                    defaultAction = "toggle-fold";
                    variant = "fold";
                } else if (Gutter.this.structureHighlight && Gutter.this.textArea.isStructureHighlightVisible() && Gutter.this.textArea.lineInStructureScope(line)) {
                    defaultAction = "match-struct";
                    variant = "struct";
                } else {
                    return;
                }
                String action = null;
                if (this.mouseActions != null) {
                    action = this.mouseActions.getActionForEvent(e, variant);
                }
                if (action == null) {
                    action = defaultAction;
                }
                StructureMatcher.Match match = Gutter.this.textArea.getStructureMatch();
                if (action.equals("select-fold")) {
                    ((Gutter)Gutter.this).textArea.displayManager.expandFold(line, true);
                    Gutter.this.textArea.selectFold(line);
                } else if (action.equals("narrow-fold")) {
                    int[] lines = buffer.getFoldAtLine(line);
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(lines[0], lines[1]);
                } else if (action.startsWith("toggle-fold")) {
                    if (((Gutter)Gutter.this).textArea.displayManager.isLineVisible(line + 1)) {
                        Gutter.this.textArea.collapseFold(line);
                    } else if (action.endsWith("-fully")) {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(line, true);
                    } else {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(line, false);
                    }
                } else if (action.equals("match-struct")) {
                    if (match != null) {
                        Gutter.this.textArea.setCaretPosition(match.end);
                    }
                } else if (action.equals("select-struct")) {
                    if (match != null) {
                        match.matcher.selectMatch(Gutter.this.textArea);
                    }
                } else if (action.equals("narrow-struct") && match != null) {
                    int start = Math.min(match.startLine, Gutter.this.textArea.getCaretLine());
                    int end = Math.max(match.endLine, Gutter.this.textArea.getCaretLine());
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(start, end);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.drag) {
                e.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseDragged(e);
            } else if (this.selectLines) {
                int selEnd;
                int selStart;
                int line;
                int screenLine = e.getY() / Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                if (e.getY() < 0) {
                    Gutter.this.textArea.scrollUpLine();
                    line = Gutter.this.textArea.getFirstPhysicalLine();
                } else if (e.getY() >= Gutter.this.getHeight()) {
                    Gutter.this.textArea.scrollDownLine();
                    line = Gutter.this.textArea.getLastPhysicalLine();
                } else {
                    line = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)screenLine).physicalLine;
                }
                if (line < this.selAnchorLine) {
                    selStart = Gutter.this.textArea.getLineStartOffset(line);
                    selEnd = this.getFoldEndOffset(this.selAnchorLine);
                } else {
                    selStart = Gutter.this.textArea.getLineStartOffset(this.selAnchorLine);
                    selEnd = this.getFoldEndOffset(line);
                }
                Gutter.this.textArea.resizeSelection(selStart, selEnd, 0, false);
            }
        }

        private int getFoldEndOffset(int line) {
            int endLine;
            JEditBuffer buffer = Gutter.this.textArea.getBuffer();
            if (line == buffer.getLineCount() - 1 || ((Gutter)Gutter.this).textArea.displayManager.isLineVisible(line + 1)) {
                endLine = line;
            } else {
                int[] lines = buffer.getFoldAtLine(line);
                endLine = lines[1];
            }
            if (endLine == buffer.getLineCount() - 1) {
                return buffer.getLineEndOffset(endLine) - 1;
            }
            return buffer.getLineEndOffset(endLine);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.drag && e.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2) {
                e.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseReleased(e);
            }
            this.drag = false;
            this.selectLines = false;
        }
    }
}

