/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

class Roster {
    private static File downloadDir;
    private List<Operation> operations = new ArrayList<Operation>();
    private List<String> toLoad = new ArrayList<String>();

    Roster() {
    }

    void addRemove(String jar) {
        this.addOperation(new Remove(jar));
    }

    void addInstall(String installed, String url, String installDirectory, int size) {
        this.addOperation(new Install(installed, url, installDirectory, size));
    }

    public Operation getOperation(int i) {
        return this.operations.get(i);
    }

    int getOperationCount() {
        return this.operations.size();
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void performOperationsInWorkThread(PluginManagerProgress progress) {
        for (int i = 0; i < this.operations.size(); ++i) {
            Operation op = this.operations.get(i);
            op.runInWorkThread(progress);
            progress.done();
            if (!Thread.interrupted()) continue;
            return;
        }
    }

    void performOperationsInAWTThread(Component comp) {
        PluginJAR plugin;
        String pluginName;
        int i;
        for (i = 0; i < this.operations.size(); ++i) {
            Operation op = this.operations.get(i);
            op.runInAWTThread(comp);
        }
        for (i = 0; i < this.toLoad.size(); ++i) {
            pluginName = this.toLoad.get(i);
            if (jEdit.getPluginJAR(pluginName) != null) {
                Log.log(7, this, "Already loaded: " + pluginName);
                continue;
            }
            jEdit.addPluginJAR(pluginName);
        }
        for (i = 0; i < this.toLoad.size(); ++i) {
            pluginName = this.toLoad.get(i);
            plugin = jEdit.getPluginJAR(pluginName);
            if (plugin == null) continue;
            plugin.checkDependencies();
        }
        for (i = 0; i < this.toLoad.size(); ++i) {
            pluginName = this.toLoad.get(i);
            plugin = jEdit.getPluginJAR(pluginName);
            if (plugin == null) continue;
            plugin.activatePluginIfNecessary();
        }
    }

    private void addOperation(Operation op) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!this.operations.get(i).equals(op)) continue;
            return;
        }
        this.operations.add(op);
    }

    private static String getDownloadDir() {
        if (downloadDir == null) {
            String settings = jEdit.getSettingsDirectory();
            if (settings == null) {
                settings = System.getProperty("user.home");
            }
            downloadDir = new File(MiscUtilities.constructPath(settings, "PluginManager.download"));
            downloadDir.mkdirs();
        }
        return downloadDir.getPath();
    }

    class Install
    extends Operation {
        int size;
        private String installed;
        private final String url;
        private String installDirectory;
        private String path;

        Install(String installed, String url, String installDirectory, int size) {
            if (url == null) {
                throw new NullPointerException();
            }
            this.installed = installed;
            this.url = url;
            this.installDirectory = installDirectory;
            this.size = size;
        }

        @Override
        public int getMaximum() {
            return this.size;
        }

        @Override
        public void runInWorkThread(PluginManagerProgress progress) {
            String fileName = MiscUtilities.getFileName(this.url);
            this.path = this.download(progress, fileName, this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInAWTThread(Component comp) {
            if (this.path == null) {
                return;
            }
            if (this.installed != null) {
                new Remove(this.installed).runInAWTThread(comp);
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.path);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName().replace('/', File.separatorChar);
                    File file = new File(this.installDirectory, name);
                    if (entry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    new File(file.getParent()).mkdirs();
                    InputStream in = null;
                    FileOutputStream out = null;
                    try {
                        in = zipFile.getInputStream(entry);
                        out = new FileOutputStream(file);
                        IOUtilities.copyStream(4096, null, in, out, false);
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly(in);
                        IOUtilities.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtilities.closeQuietly(in);
                    IOUtilities.closeQuietly(out);
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    Roster.this.toLoad.add(file.getPath());
                }
            }
            catch (InterruptedIOException iio) {
            }
            catch (ZipException e) {
                Log.log(9, this, e);
                GUIUtilities.error(null, "plugin-error-download", new Object[]{""});
            }
            catch (IOException io) {
                Log.log(9, this, io);
                Object[] args = new String[]{io.getMessage()};
                GUIUtilities.error(null, "ioerror", args);
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, this, io);
                }
                if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                    new File(this.path).delete();
                }
            }
        }

        public boolean equals(Object o) {
            return o instanceof Install && ((Install)o).url.equals(this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String download(PluginManagerProgress progress, String fileName, String url) {
            try {
                FileOutputStream out;
                InputStream in;
                String path;
                block8: {
                    String string;
                    String host = jEdit.getProperty("plugin-manager.mirror.id");
                    if (host == null || host.equals("NONE")) {
                        host = "default";
                    }
                    path = MiscUtilities.constructPath(Roster.getDownloadDir(), fileName);
                    URLConnection conn = new URL(url).openConnection();
                    progress.setStatus(jEdit.getProperty("plugin-manager.progress", new String[]{fileName, host}));
                    in = null;
                    out = null;
                    try {
                        in = conn.getInputStream();
                        out = new FileOutputStream(path);
                        if (IOUtilities.copyStream(progress, in, out, true)) break block8;
                        string = null;
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly(in);
                        IOUtilities.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtilities.closeQuietly(in);
                    IOUtilities.closeQuietly(out);
                    return string;
                }
                IOUtilities.closeQuietly(in);
                IOUtilities.closeQuietly(out);
                return path;
            }
            catch (InterruptedIOException iio) {
                return null;
            }
            catch (FileNotFoundException e) {
                Log.log(9, this, e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIUtilities.error(null, "plugin-error-download", new Object[]{""});
                    }
                });
                return null;
            }
            catch (IOException io) {
                Log.log(9, this, io);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object[] args = new String[]{io.getMessage()};
                        GUIUtilities.error(null, "plugin-error-download", args);
                    }
                });
                return null;
            }
            catch (Exception e) {
                Log.log(9, this, e);
                return null;
            }
        }
    }

    class Remove
    extends Operation {
        private final String jar;

        Remove(String jar) {
            this.jar = jar;
        }

        @Override
        public void runInAWTThread(Component comp) {
            PluginJAR jar = jEdit.getPluginJAR(this.jar);
            if (jar != null) {
                this.unloadPluginJAR(jar);
            }
            Roster.this.toLoad.remove(this.jar);
            File jarFile = new File(this.jar);
            File srcFile = new File(this.jar.substring(0, this.jar.length() - 4));
            Log.log(5, this, "Deleting " + jarFile);
            boolean ok = jarFile.delete();
            if (srcFile.exists()) {
                ok &= FileVFS.recursiveDelete(srcFile);
            }
            if (!ok) {
                Object[] args = new String[]{this.jar};
                GUIUtilities.error(comp, "plugin-manager.remove-failed", args);
            }
        }

        private void unloadPluginJAR(PluginJAR jar) {
            String[] dependents;
            for (String path : dependents = jar.getDependentPlugins()) {
                PluginJAR _jar = jEdit.getPluginJAR(path);
                if (_jar == null) continue;
                Roster.this.toLoad.add(path);
                this.unloadPluginJAR(_jar);
                String cachePath = jar.getCachePath();
                if (cachePath == null) continue;
                new File(cachePath).delete();
            }
            jEdit.removePluginJAR(jar, false);
        }

        public boolean equals(Object o) {
            return o instanceof Remove && ((Remove)o).jar.equals(this.jar);
        }
    }

    static abstract class Operation {
        Operation() {
        }

        public void runInWorkThread(PluginManagerProgress progress) {
        }

        public void runInAWTThread(Component comp) {
        }

        public int getMaximum() {
            return 0;
        }
    }
}

