/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferInsertRequest;
import org.gjt.sp.jedit.bufferio.BufferLoadRequest;
import org.gjt.sp.jedit.bufferio.BufferSaveRequest;
import org.gjt.sp.jedit.io.GlobVFSFileFilter;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkThread;

public abstract class VFS {
    public static final int READ_CAP = 1;
    public static final int WRITE_CAP = 2;
    public static final int BROWSE_CAP = 4;
    public static final int DELETE_CAP = 8;
    public static final int RENAME_CAP = 16;
    public static final int MKDIR_CAP = 32;
    public static final int LOW_LATENCY_CAP = 64;
    public static final int CASE_INSENSITIVE_CAP = 128;
    public static final String EA_TYPE = "type";
    public static final String EA_STATUS = "status";
    public static final String EA_SIZE = "size";
    public static final String EA_MODIFIED = "modified";
    public static int IOBUFSIZE = 32678;
    private String name;
    private int caps;
    private String[] extAttrs;
    private static List<ColorEntry> colors;
    private static final Object lock;

    @Deprecated
    protected VFS(String name) {
        this(name, 0);
    }

    protected VFS(String name, int caps) {
        this.name = name;
        this.caps = caps;
        this.extAttrs = new String[]{EA_SIZE, EA_TYPE};
    }

    protected VFS(String name, int caps, String[] extAttrs) {
        this.name = name;
        this.caps = caps;
        this.extAttrs = extAttrs;
    }

    public String getName() {
        return this.name;
    }

    public int getCapabilities() {
        return this.caps;
    }

    public boolean isMarkersFileSupported() {
        return true;
    }

    public String[] getExtendedAttributes() {
        return this.extAttrs;
    }

    @Deprecated
    public String showBrowseDialog(Object[] session, Component comp) {
        return null;
    }

    public String getFileName(String path) {
        if (path.equals("/")) {
            return path;
        }
        while (path.endsWith("/") || path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        int index = Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar));
        if (index == -1) {
            index = path.indexOf(58);
        }
        if (index == -1 || index == path.length() - 1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public String getParentOfPath(String path) {
        int lastIndex;
        for (lastIndex = path.length() - 1; lastIndex > 0 && (path.charAt(lastIndex) == File.separatorChar || path.charAt(lastIndex) == '/'); --lastIndex) {
        }
        int count = Math.max(0, lastIndex);
        int index = path.lastIndexOf(File.separatorChar, count);
        if (index == -1) {
            index = path.lastIndexOf(47, count);
        }
        if (index == -1) {
            index = path.lastIndexOf(58);
        }
        return path.substring(0, index + 1);
    }

    public String constructPath(String parent, String path) {
        return parent + path;
    }

    public char getFileSeparator() {
        return '/';
    }

    public String getTwoStageSaveName(String path) {
        return MiscUtilities.constructPath(this.getParentOfPath(path), '#' + this.getFileName(path) + "#save#");
    }

    public void reloadDirectory(String path) {
    }

    public Object createVFSSession(String path, Component comp) {
        return new Object();
    }

    public boolean load(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        if ((this.getCapabilities() & 2) == 0) {
            buffer.setReadOnly(true);
        }
        BufferLoadRequest request = new BufferLoadRequest(view, buffer, session, this, path);
        if (buffer.isTemporary()) {
            request.run();
        } else {
            VFSManager.runInWorkThread(request);
        }
        return true;
    }

    public boolean save(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 2) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.save", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        if (!path.equals(buffer.getPath())) {
            buffer.unsetProperty("Buffer__backedUp");
        }
        VFSManager.runInWorkThread(new BufferSaveRequest(view, buffer, session, this, path));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean copy(ProgressObserver progress, VFS sourceVFS, Object sourceSession, String sourcePath, VFS targetVFS, Object targetSession, String targetPath, Component comp, boolean canStop) throws IOException {
        block7: {
            if (progress != null) {
                progress.setStatus("Initializing");
            }
            in = null;
            out = null;
            try {
                block8: {
                    block9: {
                        sourceVFSFile = sourceVFS._getFile(sourceSession, sourcePath, comp);
                        if (sourceVFSFile == null) {
                            throw new FileNotFoundException("source path " + sourcePath + " doesn't exists");
                        }
                        if (progress != null) {
                            progress.setMaximum(sourceVFSFile.getLength());
                        }
                        if ((targetVFSFile = targetVFS._getFile(targetSession, targetPath, comp)) != null) break block8;
                        parentTargetPath = MiscUtilities.getParentOfPath(targetPath);
                        parentTargetVFSFile = targetVFS._getFile(targetSession, parentTargetPath, comp);
                        if (parentTargetVFSFile == null) {
                            throw new FileNotFoundException("target path " + parentTargetPath + " doesn't exists");
                        }
                        if (parentTargetVFSFile.getType() != 1) break block9;
                        targetFilename = MiscUtilities.getFileName(targetPath);
                        targetPath = MiscUtilities.constructPath(parentTargetPath, targetFilename);
                        ** GOTO lbl36
                    }
                    throw new IOException("The parent of target path is a file");
                }
                if (targetVFSFile.getType() != 1) ** GOTO lbl36
                if (!targetVFSFile.getPath().equals(sourceVFSFile.getPath())) break block7;
                parentTargetPath = false;
            }
            catch (Throwable var16_19) {
                IOUtilities.closeQuietly(in);
                IOUtilities.closeQuietly(out);
                throw var16_19;
            }
            IOUtilities.closeQuietly(in);
            IOUtilities.closeQuietly(out);
            return parentTargetPath;
        }
        targetPath = MiscUtilities.constructPath(targetPath, sourceVFSFile.getName());
lbl36:
        // 3 sources

        in = new BufferedInputStream(sourceVFS._createInputStream(sourceSession, sourcePath, false, comp));
        out = new BufferedOutputStream(targetVFS._createOutputStream(targetSession, targetPath, comp));
        copyResult = IOUtilities.copyStream(VFS.IOBUFSIZE, progress, in, out, canStop);
        VFSManager.sendVFSUpdate(targetVFS, targetPath, true);
        var14_17 = copyResult;
        IOUtilities.closeQuietly(in);
        IOUtilities.closeQuietly(out);
        return var14_17;
    }

    public static boolean copy(ProgressObserver progress, String sourcePath, String targetPath, Component comp, boolean canStop) throws IOException {
        VFS sourceVFS = VFSManager.getVFSForPath(sourcePath);
        Object sourceSession = sourceVFS.createVFSSession(sourcePath, comp);
        if (sourceSession == null) {
            Log.log(7, VFS.class, "Unable to get a valid session from " + sourceVFS + " for path " + sourcePath);
            return false;
        }
        VFS targetVFS = VFSManager.getVFSForPath(targetPath);
        Object targetSession = targetVFS.createVFSSession(targetPath, comp);
        if (targetSession == null) {
            Log.log(7, VFS.class, "Unable to get a valid session from " + targetVFS + " for path " + targetPath);
            return false;
        }
        return VFS.copy(progress, sourceVFS, sourceSession, sourcePath, targetVFS, targetSession, targetPath, comp, canStop);
    }

    public boolean insert(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        VFSManager.runInWorkThread(new BufferInsertRequest(view, buffer, session, this, path));
        return true;
    }

    public String _canonPath(Object session, String path, Component comp) throws IOException {
        return path;
    }

    public String[] _listDirectory(Object session, String directory, String glob, boolean recursive, Component comp) throws IOException {
        String[] retval = this._listDirectory(session, directory, glob, recursive, comp, true, false);
        return retval;
    }

    public String[] _listDirectory(Object session, String directory, String glob, boolean recursive, Component comp, boolean skipBinary, boolean skipHidden) throws IOException {
        GlobVFSFileFilter filter = new GlobVFSFileFilter(glob);
        return this._listDirectory(session, directory, filter, recursive, comp, skipBinary, skipHidden);
    }

    public String[] _listDirectory(Object session, String directory, VFSFileFilter filter, boolean recursive, Component comp, boolean skipBinary, boolean skipHidden) throws IOException {
        ArrayList<String> files = new ArrayList<String>(100);
        this.listFiles(session, new HashSet<String>(), files, directory, filter, recursive, comp, skipBinary, skipHidden);
        String[] retVal = files.toArray(new String[files.size()]);
        Arrays.sort(retVal, new StandardUtilities.StringCompare(true));
        return retVal;
    }

    public VFSFile[] _listFiles(Object session, String directory, Component comp) throws IOException {
        return this._listDirectory(session, directory, comp);
    }

    @Deprecated
    public DirectoryEntry[] _listDirectory(Object session, String directory, Component comp) throws IOException {
        VFSManager.error(comp, directory, "vfs.not-supported.list", new String[]{this.name});
        return null;
    }

    public VFSFile _getFile(Object session, String path, Component comp) throws IOException {
        return this._getDirectoryEntry(session, path, comp);
    }

    @Deprecated
    public DirectoryEntry _getDirectoryEntry(Object session, String path, Component comp) throws IOException {
        return null;
    }

    public boolean _delete(Object session, String path, Component comp) throws IOException {
        return false;
    }

    public boolean _rename(Object session, String from, String to, Component comp) throws IOException {
        return false;
    }

    public boolean _mkdir(Object session, String directory, Component comp) throws IOException {
        return false;
    }

    public void _backup(Object session, String path, Component comp) throws IOException {
    }

    public InputStream _createInputStream(Object session, String path, boolean ignoreErrors, Component comp) throws IOException {
        VFSManager.error(comp, path, "vfs.not-supported.load", new String[]{this.name});
        return null;
    }

    public OutputStream _createOutputStream(Object session, String path, Component comp) throws IOException {
        VFSManager.error(comp, path, "vfs.not-supported.save", new String[]{this.name});
        return null;
    }

    public void _saveComplete(Object session, Buffer buffer, String path, Component comp) throws IOException {
    }

    public void _finishTwoStageSave(Object session, Buffer buffer, String path, Component comp) throws IOException {
    }

    public void _endVFSSession(Object session, Component comp) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getDefaultColorFor(String name) {
        Object object = lock;
        synchronized (object) {
            if (colors == null) {
                VFS.loadColors();
            }
            for (int i = 0; i < colors.size(); ++i) {
                ColorEntry entry = colors.get(i);
                if (!entry.re.matcher(name).matches()) continue;
                return entry.color;
            }
            return null;
        }
    }

    private void listFiles(Object session, Collection<String> stack, List<String> files, String directory, VFSFileFilter filter, boolean recursive, Component comp, boolean skipBinary, boolean skipHidden) throws IOException {
        VFSFile[] _files;
        String resolvedPath = directory;
        if (recursive && !MiscUtilities.isURL(directory) && !directory.equals(resolvedPath = MiscUtilities.resolveSymlinks(directory))) {
            if (stack.contains(resolvedPath)) {
                Log.log(9, this, "Recursion in listFiles(): " + directory);
                return;
            }
            stack.add(resolvedPath);
        }
        Thread ct = Thread.currentThread();
        WorkThread wt = null;
        if (ct instanceof WorkThread) {
            wt = (WorkThread)ct;
        }
        if ((_files = this._listFiles(session, directory, comp)) == null || _files.length == 0) {
            return;
        }
        for (int i = 0; !(i >= _files.length || wt != null && wt.isAborted() || ct.isInterrupted()); ++i) {
            VFSFile file = _files[i];
            if (skipHidden && (file.isHidden() || MiscUtilities.isBackup(file.getName())) || !filter.accept(file)) continue;
            if (file.getType() == 1 || file.getType() == 2) {
                if (!recursive) continue;
                String canonPath = this._canonPath(session, file.getPath(), comp);
                this.listFiles(session, stack, files, canonPath, filter, recursive, comp, skipBinary, skipHidden);
                continue;
            }
            if (skipBinary) {
                try {
                    if (file.isBinary(session)) {
                        Log.log(5, this, file.getPath() + ": skipped as a binary file");
                        continue;
                    }
                }
                catch (IOException e) {
                    Log.log(9, this, e);
                }
            }
            files.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadColors() {
        Object object = lock;
        synchronized (object) {
            String glob;
            colors = new ArrayList<ColorEntry>();
            if (!jEdit.getBooleanProperty("vfs.browser.colorize")) {
                return;
            }
            int i = 0;
            while ((glob = jEdit.getProperty("vfs.browser.colors." + i + ".glob")) != null) {
                try {
                    colors.add(new ColorEntry(Pattern.compile(StandardUtilities.globToRE(glob)), jEdit.getColorProperty("vfs.browser.colors." + i + ".color", Color.black)));
                }
                catch (PatternSyntaxException e) {
                    Log.log(9, VFS.class, "Invalid regular expression: " + glob);
                    Log.log(9, VFS.class, e);
                }
                ++i;
            }
        }
    }

    static {
        lock = new Object();
        EditBus.addToBus(new EBComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(EBMessage msg) {
                if (msg instanceof PropertiesChanged) {
                    Object object = lock;
                    synchronized (object) {
                        colors = null;
                    }
                }
            }
        });
    }

    private static class ColorEntry {
        Pattern re;
        Color color;

        ColorEntry(Pattern re, Color color) {
            this.re = re;
            this.color = color;
        }
    }

    public static class DirectoryEntryCompare
    implements Comparator<VFSFile> {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs;

        public DirectoryEntryCompare(boolean sortMixFilesAndDirs, boolean sortIgnoreCase) {
            this.sortMixFilesAndDirs = sortMixFilesAndDirs;
            this.sortIgnoreCase = sortIgnoreCase;
        }

        @Override
        public int compare(VFSFile file1, VFSFile file2) {
            if (!this.sortMixFilesAndDirs && file1.getType() != file2.getType()) {
                return file2.getType() - file1.getType();
            }
            return StandardUtilities.compareStrings(file1.getName(), file2.getName(), this.sortIgnoreCase);
        }
    }

    @Deprecated
    public static class DirectoryEntry
    extends VFSFile {
        public DirectoryEntry() {
        }

        public DirectoryEntry(String name, String path, String deletePath, int type, long length, boolean hidden) {
            this.name = name;
            this.path = path;
            this.deletePath = deletePath;
            this.symlinkPath = path;
            this.type = type;
            this.length = length;
            this.hidden = hidden;
            if (path != null) {
                VFS vfs = VFSManager.getVFSForPath(path);
                this.canRead = (vfs.getCapabilities() & 1) != 0;
                this.canWrite = (vfs.getCapabilities() & 2) != 0;
            }
        }
    }
}

