/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.util.Log;

public class UrlVFS
extends VFS {
    public UrlVFS() {
        super("url", 1);
    }

    @Override
    public String constructPath(String parent, String path) {
        if (parent.endsWith("/")) {
            return parent + path;
        }
        return parent + '/' + path;
    }

    @Override
    public InputStream _createInputStream(Object session, String path, boolean ignoreErrors, Component comp) throws IOException {
        try {
            return new URL(path).openStream();
        }
        catch (MalformedURLException mu) {
            Log.log(9, this, mu);
            Object[] args = new String[]{mu.getMessage()};
            VFSManager.error(comp, path, "ioerror.badurl", args);
            return null;
        }
    }

    @Override
    public OutputStream _createOutputStream(Object session, String path, Component comp) throws IOException {
        try {
            return new URL(path).openConnection().getOutputStream();
        }
        catch (MalformedURLException mu) {
            Log.log(9, this, mu);
            Object[] args = new String[]{mu.getMessage()};
            VFSManager.error(comp, path, "ioerror.badurl", args);
            return null;
        }
    }
}

