/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public abstract class OptionsDialog
extends EnhancedDialog
implements ActionListener,
TreeSelectionListener {
    private String name;
    private JSplitPane splitter;
    protected JTree paneTree;
    private JScrollPane stage;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    protected OptionPane currentPane;
    private Map<Object, OptionPane> deferredOptionPanes;

    protected OptionsDialog(Frame frame, String name, String pane) {
        super(frame, jEdit.getProperty(name + ".title"), true);
        this.init(name, pane);
    }

    protected OptionsDialog(Dialog dialog, String name, String pane) {
        super(dialog, jEdit.getProperty(name + ".title"), true);
        this.init(name, pane);
    }

    public void addOptionGroup(OptionGroup group) {
        this.getDefaultGroup().addOptionGroup(group);
    }

    public void addOptionPane(OptionPane pane) {
        this.getDefaultGroup().addOptionPane(pane);
    }

    @Override
    public void ok() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.name + ".last", this.currentPane.getName());
        }
        this.ok(true);
    }

    @Override
    public void cancel() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.name + ".last", this.currentPane.getName());
        }
        this.dispose();
    }

    public void ok(boolean dispose) {
        OptionTreeModel m = (OptionTreeModel)this.paneTree.getModel();
        this.save(m.getRoot());
        jEdit.propertiesChanged();
        jEdit.saveSettings();
        if (dispose) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        GUIUtilities.saveGeometry(this, this.name);
        jEdit.setIntegerProperty(this.name + ".splitter", this.splitter.getDividerLocation());
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.apply) {
            this.ok(false);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        int i;
        TreePath path = evt.getPath();
        if (path == null) {
            return;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof String) && !(lastPathComponent instanceof OptionPane)) {
            return;
        }
        Object[] nodes = path.getPath();
        StringBuilder buf = new StringBuilder();
        OptionPane optionPane = null;
        int lastIdx = nodes.length - 1;
        int n = i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            block11: {
                String label;
                block9: {
                    String propName;
                    block12: {
                        Object node;
                        block10: {
                            block8: {
                                node = nodes[i];
                                if (!(node instanceof OptionPane)) break block8;
                                optionPane = (OptionPane)node;
                                label = jEdit.getProperty("options." + optionPane.getName() + ".label");
                                break block9;
                            }
                            if (!(node instanceof OptionGroup)) break block10;
                            label = ((OptionGroup)node).getLabel();
                            break block9;
                        }
                        if (!(node instanceof String)) break block11;
                        label = jEdit.getProperty("options." + node + ".label");
                        optionPane = this.deferredOptionPanes.get(node);
                        if (optionPane != null) break block9;
                        propName = "options." + node + ".code";
                        String code = jEdit.getProperty(propName);
                        if (code == null) break block12;
                        optionPane = (OptionPane)BeanShell.eval(jEdit.getActiveView(), BeanShell.getNameSpace(), code);
                        if (optionPane == null) break block11;
                        this.deferredOptionPanes.put(node, optionPane);
                        break block9;
                    }
                    Log.log(9, this, propName + " not defined");
                    break block11;
                }
                buf.append(label);
                if (i != lastIdx) {
                    buf.append(": ");
                }
            }
            ++i;
        }
        if (optionPane == null) {
            return;
        }
        this.setTitle(jEdit.getProperty("options.title-template", new Object[]{jEdit.getProperty(this.name + ".title"), buf.toString()}));
        try {
            optionPane.init();
        }
        catch (Throwable t) {
            Log.log(9, this, "Error initializing options:");
            Log.log(9, this, t);
        }
        this.currentPane = optionPane;
        this.stage.setViewportView(this.currentPane.getComponent());
        this.stage.revalidate();
        this.stage.repaint();
        if (!this.isShowing()) {
            this.addNotify();
        }
        this.updateSize();
        this.currentPane = optionPane;
    }

    protected abstract OptionTreeModel createOptionTreeModel();

    protected abstract OptionGroup getDefaultGroup();

    protected void init(String name, String pane) {
        this.name = name;
        this.deferredOptionPanes = new HashMap<Object, OptionPane>();
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.stage = new JScrollPane();
        this.paneTree = new JTree(this.createOptionTreeModel());
        this.paneTree.setVisibleRowCount(1);
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        if (!OperatingSystem.isMacOSLF()) {
            this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        JScrollPane scroller = new JScrollPane(this.paneTree, 22, 30);
        scroller.setMinimumSize(new Dimension(100, 0));
        this.splitter = new JSplitPane(1, jEdit.getBooleanProperty("appearance.continuousLayout"), scroller, this.stage);
        content.add((Component)this.splitter, "Center");
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalStrut(6));
        this.apply = new JButton(jEdit.getProperty("common.apply"));
        this.apply.addActionListener(this);
        buttons.add(this.apply);
        buttons.add(Box.createGlue());
        content.add((Component)buttons, "South");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        OptionGroup rootNode = (OptionGroup)this.paneTree.getModel().getRoot();
        for (int i = 0; i < rootNode.getMemberCount(); ++i) {
            this.paneTree.expandPath(new TreePath(new Object[]{rootNode, rootNode.getMember(i)}));
        }
        if (!this.selectPane(rootNode, pane)) {
            this.selectPane(rootNode, null);
        }
        this.splitter.setDividerLocation(this.paneTree.getPreferredSize().width + scroller.getVerticalScrollBar().getPreferredSize().width);
        GUIUtilities.loadGeometry(this, name);
        int dividerLocation = jEdit.getIntegerProperty(name + ".splitter", -1);
        if (dividerLocation != -1) {
            this.splitter.setDividerLocation(dividerLocation);
        }
        this.updateSize();
        this.setVisible(true);
    }

    private boolean selectPane(OptionGroup node, String name) {
        return this.selectPane(node, name, new ArrayList<Object>());
    }

    private boolean selectPane(OptionGroup node, String name, List<Object> path) {
        path.add(node);
        Enumeration<Object> e = node.getMembers();
        while (e.hasMoreElements()) {
            Object pane;
            Object obj = e.nextElement();
            if (obj instanceof OptionGroup) {
                OptionGroup grp = (OptionGroup)obj;
                if (grp.getName().equals(name)) {
                    path.add(grp);
                    path.add(grp.getMember(0));
                    TreePath treePath = new TreePath(path.toArray());
                    this.paneTree.scrollPathToVisible(treePath);
                    this.paneTree.setSelectionPath(treePath);
                    return true;
                }
                if (!this.selectPane((OptionGroup)obj, name, path)) continue;
                return true;
            }
            if (obj instanceof OptionPane) {
                pane = (OptionPane)obj;
                if (!pane.getName().equals(name) && name != null) continue;
                path.add(pane);
                TreePath treePath = new TreePath(path.toArray());
                this.paneTree.scrollPathToVisible(treePath);
                this.paneTree.setSelectionPath(treePath);
                return true;
            }
            if (!(obj instanceof String) || !((String)(pane = (String)obj)).equals(name) && name != null) continue;
            path.add(pane);
            TreePath treePath = new TreePath(path.toArray());
            this.paneTree.scrollPathToVisible(treePath);
            this.paneTree.setSelectionPath(treePath);
            return true;
        }
        path.remove(node);
        return false;
    }

    private void save(Object obj) {
        if (obj instanceof OptionGroup) {
            OptionGroup grp = (OptionGroup)obj;
            Enumeration<Object> members = grp.getMembers();
            while (members.hasMoreElements()) {
                this.save(members.nextElement());
            }
        } else if (obj instanceof OptionPane) {
            try {
                ((OptionPane)obj).save();
            }
            catch (Throwable t) {
                Log.log(9, this, "Error saving options:");
                Log.log(9, this, t);
            }
        } else if (obj instanceof String) {
            this.save(this.deferredOptionPanes.get(obj));
        }
    }

    private void updateSize() {
        Dimension currentSize = this.getSize();
        Dimension requestedSize = this.getPreferredSize();
        Dimension newSize = new Dimension(Math.max(currentSize.width, requestedSize.width), Math.max(currentSize.height, requestedSize.height));
        if (newSize.width < 300) {
            newSize.width = 300;
        }
        if (newSize.height < 200) {
            newSize.height = 200;
        }
        this.setSize(newSize);
        this.validate();
    }

    public class OptionTreeModel
    implements TreeModel {
        private final OptionGroup root;
        private final EventListenerList listenerList = new EventListenerList();

        public OptionTreeModel() {
            this(new OptionGroup(null));
        }

        public OptionTreeModel(OptionGroup root) {
            this.root = root;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMember(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberIndex(child);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            return !(node instanceof OptionGroup);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        protected void fireNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(modelEvent);
            }
        }

        protected void fireNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(modelEvent);
            }
        }

        protected void fireNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(modelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(modelEvent);
            }
        }
    }

    public static class PaneNameRenderer
    extends DefaultTreeCellRenderer {
        private Font paneFont = UIManager.getFont("Tree.font");
        private final Font groupFont;

        public PaneNameRenderer() {
            if (this.paneFont == null) {
                this.paneFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.groupFont = this.paneFont.deriveFont(1);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            String name = null;
            if (value instanceof OptionGroup) {
                this.setText(((OptionGroup)value).getLabel());
                this.setFont(this.groupFont);
            } else if (value instanceof OptionPane) {
                name = ((OptionPane)value).getName();
                this.setFont(this.paneFont);
            } else if (value instanceof String) {
                name = (String)value;
                this.setFont(this.paneFont);
            }
            if (name != null) {
                String label = jEdit.getProperty("options." + name + ".label");
                if (label == null) {
                    this.setText("NO LABEL PROPERTY: " + name);
                } else {
                    this.setText(label);
                }
            }
            this.setIcon(null);
            return this;
        }
    }
}

