/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.gui.MutableListModel;

public class HistoryModel
extends DefaultListModel
implements MutableListModel {
    private int max;
    private static int defaultMax;
    private final String name;
    private static Map<String, HistoryModel> models;
    private static boolean modified;
    private static HistoryModelSaver saver;

    public HistoryModel(String name) {
        this.name = name;
        this.max = -1;
    }

    public void addItem(String text) {
        int myMax;
        if (text == null || text.length() == 0) {
            return;
        }
        int index = this.indexOf(text);
        if (index != -1) {
            this.removeElementAt(index);
        }
        this.insertElementAt(text, 0);
        int n = myMax = this.max >= 0 ? this.max : defaultMax;
        while (this.getSize() > myMax) {
            this.removeElementAt(this.getSize() - 1);
        }
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        modified = true;
        super.insertElementAt(obj, index);
    }

    public String getItem(int index) {
        return (String)this.elementAt(index);
    }

    @Override
    public boolean removeElement(Object obj) {
        modified = true;
        return super.removeElement(obj);
    }

    @Override
    @Deprecated
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public void removeAllElements() {
        modified = true;
        super.removeAllElements();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String name) {
        HistoryModel model;
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        if ((model = models.get(name)) == null) {
            model = new HistoryModel(name);
            models.put(name, model);
        }
        return model;
    }

    public static void loadHistory() {
        if (saver != null) {
            models = saver.load(models);
        }
    }

    public static void saveHistory() {
        if (saver != null && modified && saver.save(models)) {
            modified = false;
        }
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public static void setDefaultMax(int max) {
        defaultMax = max;
    }

    public static int getDefaultMax() {
        return defaultMax;
    }

    public static void setSaver(HistoryModelSaver saver) {
        HistoryModel.saver = saver;
    }
}

