/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.List;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.buffer.UndoManager;
import org.gjt.sp.jedit.gui.MutableListModel;

public class KillRing
implements MutableListModel {
    private UndoManager.RemovedContent[] ring;
    private int count;
    private boolean wrap;
    private static KillRing killRing = new KillRing();

    public static KillRing getInstance() {
        return killRing;
    }

    public static void setInstance(KillRing killRing) {
        KillRing.killRing = killRing;
    }

    public void propertiesChanged(int historySize) {
        int newSize = Math.max(1, historySize);
        if (this.ring == null) {
            this.ring = new UndoManager.RemovedContent[newSize];
        } else if (newSize != this.ring.length) {
            UndoManager.RemovedContent[] newRing = new UndoManager.RemovedContent[newSize];
            int newCount = Math.min(this.getSize(), newSize);
            for (int i = 0; i < newCount; ++i) {
                newRing[i] = (UndoManager.RemovedContent)this.getElementAt(i);
            }
            this.ring = newRing;
            this.count = newCount;
            this.wrap = false;
        }
        if (this.count == this.ring.length) {
            this.count = 0;
            this.wrap = true;
        }
    }

    public void load() {
    }

    public void save() {
    }

    protected void reset(List source) {
        UndoManager.RemovedContent[] newRing = new UndoManager.RemovedContent[source.size()];
        int i = 0;
        for (Object x : source) {
            UndoManager.RemovedContent element = x instanceof String ? new UndoManager.RemovedContent((String)x) : (UndoManager.RemovedContent)x;
            newRing[i++] = element;
        }
        this.ring = newRing;
        this.count = 0;
        this.wrap = true;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
    }

    public Object getElementAt(int index) {
        return this.ring[this.virtualToPhysicalIndex(index)];
    }

    @Override
    public int getSize() {
        if (this.wrap) {
            return this.ring.length;
        }
        return this.count;
    }

    @Override
    public boolean removeElement(Object value) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.ring[i].equals(value)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void insertElementAt(Object value, int index) {
        this.remove(index);
        this.add((UndoManager.RemovedContent)value);
    }

    void changed(UndoManager.RemovedContent rem) {
        if (rem.inKillRing) {
            int length = this.wrap ? this.ring.length : this.count;
            int kill = -1;
            for (int i = 0; i < length; ++i) {
                if (this.ring[i] == rem || this.ring[i].hashcode != rem.hashcode || !this.ring[i].str.equals(rem.str)) continue;
                kill = i;
                break;
            }
            if (kill != -1) {
                this.remove(kill);
            }
        } else {
            this.add(rem);
        }
    }

    void add(UndoManager.RemovedContent rem) {
        int length = this.wrap ? this.ring.length : this.count;
        for (int i = 0; i < length; ++i) {
            if (this.ring[i].hashcode != rem.hashcode || !this.ring[i].str.equals(rem.str)) continue;
            return;
        }
        boolean allWhitespace = true;
        for (int i = 0; i < rem.str.length(); ++i) {
            if (Character.isWhitespace(rem.str.charAt(i))) continue;
            allWhitespace = false;
            break;
        }
        if (allWhitespace) {
            return;
        }
        rem.inKillRing = true;
        if (this.ring[this.count] != null) {
            this.ring[this.count].inKillRing = false;
        }
        this.ring[this.count] = rem;
        if (++this.count >= this.ring.length) {
            this.wrap = true;
            this.count = 0;
        }
    }

    void remove(int i) {
        if (this.wrap) {
            UndoManager.RemovedContent[] newRing = new UndoManager.RemovedContent[this.ring.length];
            int newCount = 0;
            for (int j = 0; j < this.ring.length; ++j) {
                int index = this.virtualToPhysicalIndex(j);
                if (i == index) {
                    this.ring[index].inKillRing = false;
                    continue;
                }
                newRing[newCount++] = this.ring[index];
            }
            this.ring = newRing;
            this.count = newCount;
            this.wrap = false;
        } else {
            System.arraycopy(this.ring, i + 1, this.ring, i, this.count - i - 1);
            --this.count;
        }
    }

    private int virtualToPhysicalIndex(int index) {
        if (this.wrap) {
            if (index < this.count) {
                return this.count - index - 1;
            }
            return this.count + this.ring.length - index - 1;
        }
        return this.count - index - 1;
    }
}

