/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.io.IOException;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

class BrowserIORequest
extends WorkRequest {
    public static final int LIST_DIRECTORY = 0;
    public static final int DELETE = 1;
    public static final int RENAME = 2;
    public static final int MKDIR = 3;
    private int type;
    private VFSBrowser browser;
    private Object session;
    private VFS vfs;
    private String path1;
    private String path2;
    private Object[] loadInfo;

    BrowserIORequest(int type, VFSBrowser browser, Object session, VFS vfs, String path1, String path2, Object[] loadInfo) {
        this.type = type;
        this.browser = browser;
        this.session = session;
        this.vfs = vfs;
        this.path1 = path1;
        this.path2 = path2;
        this.loadInfo = loadInfo;
    }

    @Override
    public void run() {
        switch (this.type) {
            case 0: {
                this.listDirectory();
                break;
            }
            case 1: {
                this.delete();
                break;
            }
            case 2: {
                this.rename();
                break;
            }
            case 3: {
                this.mkdir();
            }
        }
    }

    public String toString() {
        String typeString;
        switch (this.type) {
            case 0: {
                typeString = "LIST_DIRECTORY";
                break;
            }
            case 1: {
                typeString = "DELETE";
                break;
            }
            case 2: {
                typeString = "RENAME";
                break;
            }
            case 3: {
                typeString = "MKDIR";
                break;
            }
            default: {
                typeString = "UNKNOWN!!!";
            }
        }
        return this.getClass().getName() + "[type=" + typeString + ",vfs=" + this.vfs + ",path1=" + this.path1 + ",path2=" + this.path2 + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listDirectory() {
        String canonPath;
        VFSFile[] directory;
        block14: {
            directory = null;
            Object[] args = new String[]{this.path1};
            this.setStatus(jEdit.getProperty("vfs.status.listing-directory", args));
            canonPath = this.path1;
            this.setAbortable(true);
            canonPath = this.vfs._canonPath(this.session, this.path1, this.browser);
            directory = this.vfs._listFiles(this.session, canonPath, this.browser);
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                Object[] pp = new String[]{io.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
            }
            break block14;
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                Object[] pp = new String[]{io.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException io2) {
                    this.setAbortable(false);
                    Log.log(9, this, io2);
                    pp = new String[]{io2.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
                }
            }
            catch (WorkThread.Abort a) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException io3) {
                    this.setAbortable(false);
                    Log.log(9, this, io3);
                    Object[] pp = new String[]{io3.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
                }
                {
                    catch (Throwable throwable) {
                        try {
                            this.vfs._endVFSSession(this.session, this.browser);
                        }
                        catch (IOException io2) {
                            this.setAbortable(false);
                            Log.log(9, this, io2);
                            Object[] pp2 = new String[]{io2.toString()};
                            VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp2);
                        }
                        throw throwable;
                    }
                }
            }
        }
        this.setAbortable(false);
        this.loadInfo[0] = canonPath;
        this.loadInfo[1] = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void delete() {
        block13: {
            this.setAbortable(true);
            Object[] args = new String[]{this.path1};
            this.setStatus(jEdit.getProperty("vfs.status.deleting", args));
            try {
                this.path1 = this.vfs._canonPath(this.session, this.path1, this.browser);
                if (!this.vfs._delete(this.session, this.path1, this.browser)) {
                    VFSManager.error(this.browser, this.path1, "ioerror.delete-error", null);
                }
            }
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                Object[] pp = new String[]{io.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
            }
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                Object[] pp = new String[]{io.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
            }
            break block13;
            catch (WorkThread.Abort a) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException io) {
                    this.setAbortable(false);
                    Log.log(9, this, io);
                    Object[] pp = new String[]{io.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
                }
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, this.browser);
                    }
                    catch (IOException io) {
                        this.setAbortable(false);
                        Log.log(9, this, io);
                        Object[] pp = new String[]{io.toString()};
                        VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void rename() {
        block18: {
            Object[] pp;
            block17: {
                this.setAbortable(true);
                Object[] args = new String[]{this.path1, this.path2};
                this.setStatus(jEdit.getProperty("vfs.status.renaming", args));
                this.path1 = this.vfs._canonPath(this.session, this.path1, this.browser);
                this.path2 = this.vfs._canonPath(this.session, this.path2, this.browser);
                VFSFile file = this.vfs._getFile(this.session, this.path2, this.browser);
                if (file == null || OperatingSystem.isCaseInsensitiveFS() && this.path1.equalsIgnoreCase(this.path2)) break block17;
                VFSManager.error(this.browser, this.path1, "ioerror.rename-exists", new String[]{this.path2});
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException io) {
                    this.setAbortable(false);
                    Log.log(9, this, io);
                    Object[] pp2 = new String[]{io.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp2);
                }
                return;
            }
            if (!this.vfs._rename(this.session, this.path1, this.path2, this.browser)) {
                VFSManager.error(this.browser, this.path1, "ioerror.rename-error", new String[]{this.path2});
            }
            {
                catch (IOException io) {
                    this.setAbortable(false);
                    Log.log(9, this, io);
                    Object[] pp3 = new String[]{io.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp3);
                }
            }
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                pp = new String[]{io.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
            }
            break block18;
            catch (WorkThread.Abort a) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException io) {
                    this.setAbortable(false);
                    Log.log(9, this, io);
                    pp = new String[]{io.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp);
                }
                break block18;
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, this.browser);
                    }
                    catch (IOException io) {
                        this.setAbortable(false);
                        Log.log(9, this, io);
                        Object[] pp4 = new String[]{io.toString()};
                        VFSManager.error(this.browser, this.path1, "ioerror.directory-error", pp4);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mkdir() {
        block13: {
            this.setAbortable(true);
            Object[] args = new String[]{this.path1};
            this.setStatus(jEdit.getProperty("vfs.status.mkdir", args));
            try {
                this.path1 = this.vfs._canonPath(this.session, this.path1, this.browser);
                if (!this.vfs._mkdir(this.session, this.path1, this.browser)) {
                    VFSManager.error(this.browser, this.path1, "ioerror.mkdir-error", null);
                }
            }
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                args[0] = io.toString();
                VFSManager.error(this.browser, this.path1, "ioerror", args);
            }
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException io) {
                this.setAbortable(false);
                Log.log(9, this, io);
                Object[] args2 = new String[]{io.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror", args2);
            }
            break block13;
            catch (WorkThread.Abort a) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException io) {
                    this.setAbortable(false);
                    Log.log(9, this, io);
                    Object[] args3 = new String[]{io.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror", args3);
                }
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, this.browser);
                    }
                    catch (IOException io) {
                        this.setAbortable(false);
                        Log.log(9, this, io);
                        Object[] args4 = new String[]{io.toString()};
                        VFSManager.error(this.browser, this.path1, "ioerror", args4);
                    }
                    throw throwable;
                }
            }
        }
    }
}

