/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class Macros {
    private static String systemMacroPath;
    private static String userMacroPath;
    private static List<Handler> macroHandlers;
    private static ActionSet macroActionSet;
    private static Vector macroHierarchy;
    private static Map<String, Macro> macroHash;
    private static Macro lastMacro;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showRunScriptDialog(View view) {
        String[] paths = GUIUtilities.showVFSFileDialog(view, null, 0, true);
        if (paths != null) {
            Buffer buffer = view.getBuffer();
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < paths.length; ++i) {
                    Macros.runScript(view, paths[i], false);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }

    public static void runScript(View view, String path, boolean ignoreUnknown) {
        Handler handler = Macros.getHandlerForPathName(path);
        if (handler != null) {
            try {
                Macro newMacro = handler.createMacro(MiscUtilities.getFileName(path), path);
                newMacro.invoke(view);
            }
            catch (Exception e) {
                Log.log(9, Macros.class, e);
                return;
            }
            return;
        }
        if (ignoreUnknown) {
            Log.log(5, Macros.class, path + ": Cannot find a suitable macro handler");
        } else {
            Log.log(9, Macros.class, path + ": Cannot find a suitable macro handler, " + "assuming BeanShell");
            Macros.getHandler("beanshell").createMacro(path, path).invoke(view);
        }
    }

    public static void message(Component comp, String message) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(comp, message, jEdit.getProperty("macro-message.title"), 1);
    }

    public static void error(Component comp, String message) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(comp, message, jEdit.getProperty("macro-message.title"), 0);
    }

    public static String input(Component comp, String prompt) {
        GUIUtilities.hideSplashScreen();
        return Macros.input(comp, prompt, null);
    }

    public static String input(Component comp, String prompt, String defaultValue) {
        GUIUtilities.hideSplashScreen();
        return (String)JOptionPane.showInputDialog(comp, prompt, jEdit.getProperty("macro-input.title"), 3, null, null, defaultValue);
    }

    public static int confirm(Component comp, String prompt, int buttons) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(comp, prompt, jEdit.getProperty("macro-confirm.title"), buttons, 3);
    }

    public static int confirm(Component comp, String prompt, int buttons, int type) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(comp, prompt, jEdit.getProperty("macro-confirm.title"), buttons, type);
    }

    public static void loadMacros() {
        macroActionSet.removeAllActions();
        macroHierarchy.removeAllElements();
        macroHash.clear();
        String settings = jEdit.getSettingsDirectory();
        if (settings != null) {
            userMacroPath = MiscUtilities.constructPath(settings, "macros");
            Macros.loadMacros(macroHierarchy, "", new File(userMacroPath));
        }
        if (jEdit.getJEditHome() != null) {
            systemMacroPath = MiscUtilities.constructPath(jEdit.getJEditHome(), "macros");
            Macros.loadMacros(macroHierarchy, "", new File(systemMacroPath));
        }
        EditBus.send(new DynamicMenuChanged("macros"));
    }

    public static void registerHandler(Handler handler) {
        if (Macros.getHandler(handler.getName()) != null) {
            Log.log(9, Macros.class, "Cannot register more than one macro handler with the same name");
            return;
        }
        Log.log(1, Macros.class, "Registered " + handler.getName() + " macro handler");
        macroHandlers.add(handler);
    }

    public static void unregisterHandler(Handler handler) {
        if (macroHandlers.remove(handler)) {
            Log.log(1, Macros.class, "Unregistered " + handler.getName() + " macro handler");
        } else {
            Log.log(9, Macros.class, "Cannot unregister " + handler.getName() + " macro handler - it is not registered.");
        }
    }

    public static Handler[] getHandlers() {
        Handler[] handlers = new Handler[macroHandlers.size()];
        return macroHandlers.toArray(handlers);
    }

    public static Handler getHandlerForPathName(String pathName) {
        for (int i = 0; i < macroHandlers.size(); ++i) {
            Handler handler = macroHandlers.get(i);
            if (!handler.accept(pathName)) continue;
            return handler;
        }
        return null;
    }

    public static Handler getHandler(String name) {
        for (int i = 0; i < macroHandlers.size(); ++i) {
            Handler handler = macroHandlers.get(i);
            if (!handler.getName().equals(name)) continue;
            return handler;
        }
        return null;
    }

    public static Vector getMacroHierarchy() {
        return macroHierarchy;
    }

    public static ActionSet getMacroActionSet() {
        return macroActionSet;
    }

    public static Macro getMacro(String macro) {
        return macroHash.get(macro);
    }

    public static Macro getLastMacro() {
        return lastMacro;
    }

    public static void setLastMacro(Macro macro) {
        lastMacro = macro;
    }

    public static void recordTemporaryMacro(View view) {
        String settings = jEdit.getSettingsDirectory();
        if (settings == null) {
            GUIUtilities.error(view, "no-settings", new String[0]);
            return;
        }
        if (view.getMacroRecorder() != null) {
            GUIUtilities.error(view, "already-recording", new String[0]);
            return;
        }
        Buffer buffer = jEdit.openFile((View)null, settings + File.separator + "macros", "Temporary_Macro.bsh", true, null);
        if (buffer == null) {
            return;
        }
        buffer.remove(0, buffer.getLength());
        buffer.insert(0, jEdit.getProperty("macro.temp.header"));
        Macros.recordMacro(view, buffer, true);
    }

    public static void recordMacro(View view) {
        String settings = jEdit.getSettingsDirectory();
        if (settings == null) {
            GUIUtilities.error(view, "no-settings", new String[0]);
            return;
        }
        if (view.getMacroRecorder() != null) {
            GUIUtilities.error(view, "already-recording", new String[0]);
            return;
        }
        String name = GUIUtilities.input(view, "record", null);
        if (name == null) {
            return;
        }
        Buffer buffer = jEdit.openFile((View)null, null, MiscUtilities.constructPath(settings, "macros", (name = name.replace(' ', '_')) + ".bsh"), true, null);
        if (buffer == null) {
            return;
        }
        buffer.remove(0, buffer.getLength());
        buffer.insert(0, jEdit.getProperty("macro.header"));
        Macros.recordMacro(view, buffer, false);
    }

    public static void stopRecording(View view) {
        Recorder recorder = view.getMacroRecorder();
        if (recorder == null) {
            GUIUtilities.error(view, "macro-not-recording", null);
        } else {
            view.setMacroRecorder(null);
            if (!recorder.temporary) {
                view.setBuffer(recorder.buffer);
            }
            recorder.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTemporaryMacro(View view) {
        String settings = jEdit.getSettingsDirectory();
        if (settings == null) {
            GUIUtilities.error(view, "no-settings", null);
            return;
        }
        String path = MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "macros", "Temporary_Macro.bsh");
        if (jEdit.getBuffer(path) == null) {
            GUIUtilities.error(view, "no-temp-macro", null);
            return;
        }
        Handler handler = Macros.getHandler("beanshell");
        Macro temp = handler.createMacro(path, path);
        Buffer buffer = view.getBuffer();
        try {
            buffer.beginCompoundEdit();
            temp.invoke(view);
        }
        finally {
            if (buffer.insideCompoundEdit()) {
                buffer.endCompoundEdit();
            }
        }
    }

    private static void loadMacros(List vector, String path, File directory) {
        lastMacro = null;
        File[] macroFiles = directory.listFiles();
        if (macroFiles == null || macroFiles.length == 0) {
            return;
        }
        for (int i = 0; i < macroFiles.length; ++i) {
            File file = macroFiles[i];
            String fileName = file.getName();
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                String submenuName = fileName.replace('_', ' ');
                List<String> submenu = null;
                for (int j = 0; j < vector.size(); ++j) {
                    List vec;
                    Object obj = vector.get(j);
                    if (!(obj instanceof List) || !submenuName.equals((vec = (List)obj).get(0))) continue;
                    submenu = vec;
                    break;
                }
                if (submenu == null) {
                    submenu = new Vector<String>();
                    submenu.add(submenuName);
                    vector.add(submenu);
                }
                Macros.loadMacros(submenu, path + fileName + '/', file);
                continue;
            }
            Macros.addMacro(file, path, vector);
        }
    }

    private static void addMacro(File file, String path, List vector) {
        String fileName = file.getName();
        Handler handler = Macros.getHandlerForPathName(file.getPath());
        if (handler == null) {
            return;
        }
        try {
            String macroName = (path + fileName).replace(' ', '_');
            Macro newMacro = handler.createMacro(macroName, file.getPath());
            if (macroHash.get(newMacro.getName()) != null) {
                return;
            }
            vector.add(newMacro.getName());
            jEdit.setTemporaryProperty(newMacro.getName() + ".label", newMacro.label);
            jEdit.setTemporaryProperty(newMacro.getName() + ".mouse-over", handler.getLabel() + " - " + file.getPath());
            macroActionSet.addAction(newMacro);
            macroHash.put(newMacro.getName(), newMacro);
        }
        catch (Exception e) {
            Log.log(9, Macros.class, e);
            macroHandlers.remove(handler);
        }
    }

    private static void recordMacro(View view, Buffer buffer, boolean temporary) {
        view.setMacroRecorder(new Recorder(view, buffer, temporary));
        view.getStatus().setMessage(null);
    }

    static {
        macroHandlers = new ArrayList<Handler>();
        Macros.registerHandler(new BeanShellHandler());
        macroActionSet = new ActionSet(jEdit.getProperty("action-set.macros"));
        jEdit.addActionSet(macroActionSet);
        macroHierarchy = new Vector();
        macroHash = new Hashtable<String, Macro>();
    }

    private static class BeanShellHandler
    extends Handler {
        BeanShellHandler() {
            super("beanshell");
        }

        @Override
        public Macro createMacro(String macroName, String path) {
            macroName = macroName.substring(0, macroName.length() - 4);
            return new Macro(this, macroName, Macro.macroNameToLabel(macroName), path);
        }

        @Override
        public void runMacro(View view, Macro macro) {
            BeanShell.runScript(view, macro.getPath(), null, true);
        }

        @Override
        public void runMacro(View view, Macro macro, boolean ownNamespace) {
            BeanShell.runScript(view, macro.getPath(), null, ownNamespace);
        }
    }

    public static abstract class Handler {
        private String name;
        private String label;
        private Pattern filter;

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean accept(String path) {
            return this.filter.matcher(MiscUtilities.getFileName(path)).matches();
        }

        public abstract Macro createMacro(String var1, String var2);

        public abstract void runMacro(View var1, Macro var2);

        public void runMacro(View view, Macro macro, boolean ownNamespace) {
            this.runMacro(view, macro);
        }

        protected Handler(String name) {
            this.name = name;
            this.label = jEdit.getProperty("macro-handler." + name + ".label", name);
            try {
                this.filter = Pattern.compile(StandardUtilities.globToRE(jEdit.getProperty("macro-handler." + name + ".glob")));
            }
            catch (Exception e) {
                throw new InternalError("Missing or invalid glob for handler " + name);
            }
        }
    }

    public static class Recorder {
        View view;
        Buffer buffer;
        boolean temporary;
        boolean lastWasInput;
        boolean lastWasOverwrite;
        int overwriteCount;

        public Recorder(View view, Buffer buffer, boolean temporary) {
            this.view = view;
            this.buffer = buffer;
            this.temporary = temporary;
            EditBus.addToBus(this);
        }

        public void record(String code) {
            if (BeanShell.isScriptRunning()) {
                return;
            }
            this.flushInput();
            this.append("\n");
            this.append(code);
        }

        public void record(int repeat, String code) {
            if (repeat == 1) {
                this.record(code);
            } else {
                this.record("for(int i = 1; i <= " + repeat + "; i++)\n" + "{\n" + code + '\n' + '}');
            }
        }

        public void recordInput(int repeat, char ch, boolean overwrite) {
            if (ch == '\n') {
                this.record(repeat, "textArea.userInput('\\n');");
            } else if (ch == '\t') {
                this.record(repeat, "textArea.userInput('\\t');");
            } else {
                StringBuilder buf = new StringBuilder(repeat);
                for (int i = 0; i < repeat; ++i) {
                    buf.append(ch);
                }
                this.recordInput(buf.toString(), overwrite);
            }
        }

        public void recordInput(String str, boolean overwrite) {
            String charStr = StandardUtilities.charsToEscapes(str);
            if (overwrite) {
                if (this.lastWasOverwrite) {
                    ++this.overwriteCount;
                    this.append(charStr);
                } else {
                    this.flushInput();
                    this.overwriteCount = 1;
                    this.lastWasOverwrite = true;
                    this.append("\ntextArea.setSelectedText(\"" + charStr);
                }
            } else if (this.lastWasInput) {
                this.append(charStr);
            } else {
                this.flushInput();
                this.lastWasInput = true;
                this.append("\ntextArea.setSelectedText(\"" + charStr);
            }
        }

        @EditBus.EBHandler
        public void handleBufferUpdate(BufferUpdate bmsg) {
            if (bmsg.getWhat() == BufferUpdate.CLOSED && bmsg.getBuffer() == this.buffer) {
                Macros.stopRecording(this.view);
            }
        }

        private void append(String str) {
            this.buffer.insert(this.buffer.getLength(), str);
        }

        private void dispose() {
            this.flushInput();
            for (int i = 0; i < this.buffer.getLineCount(); ++i) {
                this.buffer.indentLine(i, true);
            }
            EditBus.removeFromBus(this);
            this.view.getStatus().setMessage(null);
        }

        private void flushInput() {
            if (this.lastWasInput) {
                this.lastWasInput = false;
                this.append("\");");
            }
            if (this.lastWasOverwrite) {
                this.lastWasOverwrite = false;
                this.append("\");\n");
                this.append("offset = buffer.getLineEndOffset(textArea.getCaretLine()) - 1;\n");
                this.append("buffer.remove(textArea.getCaretPosition(),Math.min(" + this.overwriteCount + ",offset - " + "textArea.getCaretPosition()));");
            }
        }
    }

    public static class Macro
    extends EditAction {
        private Handler handler;
        private String path;
        String label;

        public Macro(Handler handler, String name, String label, String path) {
            super(name);
            this.handler = handler;
            this.label = label;
            this.path = path;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public String getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(View view) {
            Macros.setLastMacro(this);
            if (view == null) {
                this.handler.runMacro(null, this);
            } else {
                try {
                    view.getBuffer().beginCompoundEdit();
                    this.handler.runMacro(view, this);
                }
                finally {
                    view.getBuffer().endCompoundEdit();
                }
            }
        }

        @Override
        public String getCode() {
            return "Macros.getMacro(\"" + this.getName() + "\").invoke(view);";
        }

        public static String macroNameToLabel(String macroName) {
            int index = macroName.lastIndexOf(47);
            return macroName.substring(index + 1).replace('_', ' ');
        }
    }
}

