/*
 * Decompiled with CFR 0.152.
 */
package sidekick.enhanced;

import errorlist.DefaultErrorSource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.enhanced.PartialParser;
import sidekick.enhanced.SourceAsset;

public class SourceParser
extends SideKickParser
implements PartialParser {
    public ImageIcon PACKAGE_ICON;
    public ImageIcon USE_ICON;
    public ImageIcon SUB_ICON;
    public ImageIcon PACKAGE_INVALID_ICON;
    public ImageIcon USE_INVALID_ICON;
    public ImageIcon SUB_INVALID_ICON;
    public ImageIcon COMMENT_ICON;
    public String LINE_COMMENT;
    public String COMMENT;
    public String MAIN;
    public String USE;
    public String USE_KEY = "---use---";
    public String SUB_KEY = "---sub---";
    public String PKG_KEY = "---pkg---";
    protected SideKickParsedData data;
    protected PackageMap packages;
    protected ArrayList commentList;
    protected SourceAsset _asset;
    protected SourceAsset _pkgAsset;
    protected Position _start;
    protected Position _end;
    protected int _lastLineNumber = 0;
    protected int startLine = 0;

    public SourceParser(String name) {
        super(name);
        this.loadIcons(name, this.getClass());
    }

    public SourceParser(String name, Class cls) {
        super(name);
        this.loadIcons(name, cls);
    }

    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        this.data = new SideKickParsedData(buffer.getName());
        this.packages = new PackageMap(new PackageComparator());
        this.commentList = new ArrayList();
        this.parseBuffer(buffer, errorSource);
        this.completePackageAsset(this._end, this._lastLineNumber);
        Log.log((int)1, (Object)this, (Object)"parsing completed");
        this.buildTrees();
        Log.log((int)1, (Object)this, (Object)"tree built");
        return this.data;
    }

    public SideKickParsedData parse(Buffer buffer, String text, DefaultErrorSource errorSource) {
        return this.parse(buffer, errorSource);
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    protected void parseBuffer(Buffer buffer, DefaultErrorSource errorSource) {
    }

    protected void loadIcons(String name, Class cls) {
        this.PACKAGE_ICON = this.loadIcon(name, cls, "package-icon");
        this.USE_ICON = this.loadIcon(name, cls, "use-icon");
        this.SUB_ICON = this.loadIcon(name, cls, "sub-icon");
        this.PACKAGE_INVALID_ICON = this.loadIcon(name, cls, "package_invalid-icon");
        this.USE_INVALID_ICON = this.loadIcon(name, cls, "use-invalid-icon");
        this.SUB_INVALID_ICON = this.loadIcon(name, cls, "sub-invalid-icon");
        this.COMMENT_ICON = this.loadIcon(name, cls, "comment-icon");
    }

    protected ImageIcon loadIcon(String name, Class cls, String icon) {
        String iconfile = jEdit.getProperty((String)("sidekick.parser." + name + "." + icon));
        URL res = cls.getResource("/icons/" + iconfile);
        if (res == null) {
            return null;
        }
        return new ImageIcon(res);
    }

    protected void completeAsset(Position end) {
        if (this._asset != null) {
            this._asset.setEnd(end);
        }
        this._asset = null;
    }

    protected void completeAsset(Position end, String desc) {
        if (this._asset != null) {
            this._asset.setLongDescription(desc);
        }
        this.completeAsset(end);
    }

    protected void completeAsset(Position end, int lineNo) {
        if (this._asset != null) {
            this._asset.setLongDescription(this._asset.getLongDescription() + "-" + lineNo);
        }
        this._lastLineNumber = lineNo;
        this.completeAsset(end);
    }

    protected void completePackageAsset(Position end, int lineNo) {
        this.completeAsset(end, lineNo);
        this._asset = this._pkgAsset;
        this.completeAsset(end, lineNo);
    }

    protected void addAsset(String typ, String p, String name, int lineNo, Position start) {
        this.completeAsset(start, lineNo);
        this._asset = new SourceAsset(name, lineNo, start);
        this.packages.addToList(typ, p, this._asset);
    }

    protected void addLineAsset(String typ, String p, String name, int lineNo, Position start, Position end) {
        SourceAsset a = new SourceAsset(name, lineNo, start);
        a.setEnd(end);
        this.packages.addToList(typ, p, a);
    }

    protected void addCommentAsset(String name, int lineNo, Position start) {
        this.completeAsset(start, lineNo);
        this._asset = new SourceAsset(name, lineNo, start);
        this.commentList.add(this._asset);
    }

    protected void addPackageAsset(String name, int lineNo, Position start) {
        SourceAsset a;
        this.completePackageAsset(start, lineNo);
        this._pkgAsset = a = new SourceAsset(name, lineNo, start);
        this.packages.addPackage(name, a);
    }

    protected void buildTrees() {
        Set list = this.packages.keySet();
        for (String name : list) {
            HashMap h = (HashMap)this.packages.get(name);
            SourceAsset a = (SourceAsset)h.get(this.PKG_KEY);
            a.setIcon(this.PACKAGE_ICON);
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(a);
            this.newTree(t, this.USE, (ArrayList)h.get(this.USE_KEY), this.USE_ICON);
            this.addList(t, (ArrayList)h.get(this.SUB_KEY), this.SUB_ICON);
            this.data.root.add(t);
        }
        this.newTree(this.data.root, this.COMMENT, this.commentList, this.COMMENT_ICON);
    }

    protected void newTree(DefaultMutableTreeNode n, String name, ArrayList list, ImageIcon icon) {
        if (list.size() == 0) {
            return;
        }
        SourceAsset first = (SourceAsset)list.get(0);
        SourceAsset branch = new SourceAsset(name, first.getLineNo(), first.getStart());
        branch.setIcon(icon);
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(branch);
        this.addList(t, list, null);
        n.add(t);
    }

    protected void addList(DefaultMutableTreeNode t, ArrayList list, ImageIcon icon) {
        Collections.sort(list, new AssetComparator());
        for (SourceAsset a : list) {
            a.setIcon(icon);
            t.add(new DefaultMutableTreeNode(a));
        }
    }

    protected String find(String line, Pattern p, int g) {
        Matcher m = p.matcher(line);
        return m.find() ? m.group(g) : null;
    }

    protected String[] find2(String line, Pattern p) {
        String[] res = new String[2];
        Matcher m = p.matcher(line);
        if (m.find()) {
            res[0] = m.group(1);
            res[1] = m.group(2);
        } else {
            res = null;
        }
        return res;
    }

    public class PackageMap
    extends TreeMap {
        public PackageMap() {
        }

        public PackageMap(PackageComparator pc) {
            super(pc);
        }

        public HashMap addPackage(String p, SourceAsset a) {
            if (this.containsKey(p)) {
                return (HashMap)this.get(p);
            }
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put(SourceParser.this.PKG_KEY, a);
            h.put(SourceParser.this.USE_KEY, new ArrayList());
            h.put(SourceParser.this.SUB_KEY, new ArrayList());
            this.put(p, h);
            return h;
        }

        public SourceAsset getPackageAsset(String p) {
            if (!this.containsKey(p)) {
                return null;
            }
            HashMap h = (HashMap)this.get(p);
            return (SourceAsset)h.get(SourceParser.this.PKG_KEY);
        }

        public void completePackageAsset(String p, Position end) {
            SourceAsset a = this.getPackageAsset(p);
            if (a != null) {
                a.setEnd(end);
            }
        }

        public void completePackageAsset(String p, Position end, String desc) {
            SourceAsset a = this.getPackageAsset(p);
            if (a == null) {
                return;
            }
            a.setLongDescription(desc);
            a.setEnd(end);
        }

        public void completePackageAsset(String p, Position end, int lineNo) {
            SourceAsset a = this.getPackageAsset(p);
            if (a == null) {
                return;
            }
            a.setLongDescription(a.getLongDescription() + "-" + lineNo);
            a.setEnd(end);
        }

        public void addToList(String typ, String p, SourceAsset a) {
            SourceAsset pkg = new SourceAsset(p, a.getLineNo(), a.getStart());
            HashMap h = this.addPackage(p, pkg);
            ArrayList list = (ArrayList)h.get(typ);
            if (list != null) {
                list.add(a);
            } else {
                Log.log((int)1, SourceParser.class, (Object)("Entry " + typ + " not in PackageMap"));
            }
        }
    }

    public class PackageComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int comp = s1.toLowerCase().compareTo(s2.toLowerCase());
            if (comp == 0) {
                return comp;
            }
            if (s1.equals(SourceParser.this.MAIN)) {
                return -1;
            }
            if (s2.equals(SourceParser.this.MAIN)) {
                return 1;
            }
            return comp;
        }
    }

    protected class AssetComparator
    implements Comparator {
        protected AssetComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((SourceAsset)o1).toString();
            String s2 = ((SourceAsset)o2).toString();
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    }
}

