/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.gjt.sp.jedit.jEdit;
import sidekick.AbstractModeOptionPane;
import sidekick.ModeOptionPaneController;
import sidekick.SideKickTree;

public class SideKickModeOptionsPane
extends AbstractModeOptionPane
implements ModeOptionPaneController.ModeOptionPaneDelegate {
    ModeOptionPaneController controller = new ModeOptionPaneController(this);
    JCheckBox showStatusWindow = new JCheckBox(jEdit.getProperty((String)"options.sidekick.showStatusWindow.label"));
    JCheckBox treeFollowsCaret;
    JComboBox autoExpandTreeDepth;
    JComboBox defaultParser;

    public SideKickModeOptionsPane() {
        super("sidekick.mode");
        this.addComponent(this.showStatusWindow);
        this.treeFollowsCaret = new JCheckBox(jEdit.getProperty((String)"options.sidekick.tree-follows-caret"));
        this.addComponent(this.treeFollowsCaret);
        this.autoExpandTreeDepth = new JComboBox();
        this.addComponent(jEdit.getProperty((String)"options.sidekick.auto-expand-tree-depth"), this.autoExpandTreeDepth);
        this.autoExpandTreeDepth.addItem("ALL");
        for (int i = 0; i <= 10; ++i) {
            this.autoExpandTreeDepth.addItem(String.valueOf(i));
        }
        this.addComponent(this.autoExpandTreeDepth);
        this.defaultParser = new JComboBox();
        this.defaultParser.setModel(new DefaultComboBoxModel<String>(SideKickTree.parserList().toArray()));
        this.addComponent(jEdit.getProperty((String)"options.sidekick.parser.parser"), this.defaultParser);
    }

    protected void _init() {
    }

    public Object createModeProps(String mode) {
        Props p = new Props();
        p.treeFollowsCaret = SideKickModeOptionsPane.getBooleanProperty(mode, "sidekick-tree.follows-caret");
        p.showStatusWindow = SideKickModeOptionsPane.getBooleanProperty(mode, "sidekick.showStatusWindow.label");
        p.autoExpandTreeDepth = SideKickModeOptionsPane.getIntegerProperty(mode, "sidekick-tree.auto-expand-tree-depth", 1);
        p.parser = SideKickModeOptionsPane.getProperty(mode, "sidekick.parser");
        return p;
    }

    public void resetModeProps(String mode) {
        SideKickModeOptionsPane.clearModeProperty(mode, "sidekick-tree.follows-caret");
        SideKickModeOptionsPane.clearModeProperty(mode, "sidekick-tree.auto-expand-tree-depth");
        SideKickModeOptionsPane.clearModeProperty(mode, "sidekick.showStatusWindow.label");
        SideKickModeOptionsPane.clearModeProperty(mode, "sidekick.parser");
    }

    public void saveModeProps(String mode, Object props) {
        Props p = (Props)props;
        SideKickModeOptionsPane.setBooleanProperty(mode, "sidekick-tree.follows-caret", p.treeFollowsCaret);
        SideKickModeOptionsPane.setBooleanProperty(mode, "sidekick.showStatusWindow.label", p.showStatusWindow);
        SideKickModeOptionsPane.setIntegerProperty(mode, "sidekick-tree.auto-expand-tree-depth", p.autoExpandTreeDepth);
        if (p.parser == "default parser") {
            SideKickModeOptionsPane.clearModeProperty(mode, "sidekick.parser");
        } else {
            SideKickModeOptionsPane.setProperty(mode, "sidekick.parser", p.parser);
        }
    }

    public void updatePropsFromUI(Object props) {
        Props p = (Props)props;
        p.treeFollowsCaret = this.treeFollowsCaret.isSelected();
        p.showStatusWindow = this.showStatusWindow.isSelected();
        String value = (String)this.autoExpandTreeDepth.getSelectedItem();
        String depth = value.equals("ALL") ? "-1" : value;
        p.autoExpandTreeDepth = Integer.valueOf(depth);
        Object parser = this.defaultParser.getSelectedItem();
        p.parser = parser == null ? null : parser.toString();
    }

    public void updateUIFromProps(Object props) {
        Props p = (Props)props;
        this.treeFollowsCaret.setSelected(p.treeFollowsCaret);
        this.showStatusWindow.setSelected(p.showStatusWindow);
        this.autoExpandTreeDepth.setSelectedIndex(p.autoExpandTreeDepth + 1);
        this.defaultParser.setSelectedItem(p.parser);
    }

    public void modeSelected(String mode) {
        this.controller.modeSelected(mode);
    }

    public void cancel() {
        this.controller.cancel();
    }

    public void setUseDefaults(boolean b) {
        this.controller.setUseDefaults(b);
    }

    public boolean getUseDefaults(String mode) {
        return this.controller.getUseDefaults(mode);
    }

    public JComponent getUIComponent() {
        return this;
    }

    public boolean hasModeProps(String mode) {
        return SideKickModeOptionsPane.modePropertyExists(mode, "sidekick-tree.follows-caret") || SideKickModeOptionsPane.modePropertyExists(mode, "sidekick-tree.auto-expand-tree-depth") || SideKickModeOptionsPane.modePropertyExists(mode, "sidekick.showStatusWindow.label") || SideKickModeOptionsPane.modePropertyExists(mode, "sidekick.parser");
    }

    public void _save() {
        this.controller.save();
    }

    class Props {
        boolean treeFollowsCaret;
        boolean showStatusWindow;
        int autoExpandTreeDepth;
        String parser;

        Props() {
        }
    }
}

