/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.Collections;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;

class MyTableModel
extends AbstractTableModel {
    private Vector modes;

    MyTableModel() {
        Mode[] modes = jEdit.getModes();
        this.modes = new Vector(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            this.modes.addElement(new Entry(modes[i].getName()));
        }
        Collections.sort(this.modes);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.modes.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    public Object getValueAt(int row, int col) {
        Entry modeParser = (Entry)this.modes.elementAt(row);
        switch (col) {
            case 0: {
                return modeParser.mode;
            }
            case 1: {
                return modeParser.parser;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        Entry modeParser = (Entry)this.modes.elementAt(row);
        switch (col) {
            case 1: {
                modeParser.parser = (String)value;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty((String)"options.sidekick.parser.mode");
            }
            case 1: {
                return jEdit.getProperty((String)"options.sidekick.parser.parser");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.modes.size(); ++i) {
            ((Entry)this.modes.elementAt(i)).save();
        }
    }

    class Entry
    implements Comparable {
        String mode;
        String parser = null;

        Entry(String mode) {
            this.mode = mode;
            this.parser = jEdit.getProperty((String)("mode." + this.mode + ".sidekick.parser"));
        }

        void save() {
            if (this.parser == "default parser") {
                jEdit.resetProperty((String)("mode." + this.mode + ".sidekick.parser"));
            } else {
                jEdit.setProperty((String)("mode." + this.mode + ".sidekick.parser"), (String)this.parser);
            }
        }

        public int compareTo(Object a) {
            return this.mode.compareToIgnoreCase(((Entry)a).mode);
        }
    }
}

