/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class FavoritesProvider
implements DynamicMenuProvider {
    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu menu) {
        final View view = GUIUtilities.getView(menu);
        ActionListener fileListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                jEdit.openFile(view, evt.getActionCommand());
            }
        };
        ActionListener dirListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VFSBrowser.browseDirectory(view, evt.getActionCommand());
            }
        };
        VFSFile[] favorites = FavoritesVFS.getFavorites();
        if (favorites.length == 0) {
            JMenuItem mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
            mi.setEnabled(false);
            menu.add(mi);
        } else {
            Arrays.sort(favorites, new VFS.DirectoryEntryCompare(jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs"), jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase")));
            for (int i = 0; i < favorites.length; ++i) {
                VFSFile favorite = favorites[i];
                JMenuItem mi = new JMenuItem(favorite.getPath());
                mi.setIcon(FileCellRenderer.getIconForFile(favorite, false));
                if (favorite.getType() == 0) {
                    mi.addActionListener(fileListener);
                } else {
                    mi.addActionListener(dirListener);
                }
                menu.add(mi);
            }
        }
    }
}

