/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class FileVFS
extends VFS {
    public static final String PERMISSIONS_PROPERTY = "FileVFS__perms";
    private static final FileSystemView fsView = FileSystemView.getFileSystemView();

    public FileVFS() {
        super("file", 0x7F | (OperatingSystem.isCaseInsensitiveFS() ? 128 : 0), new String[]{"type", "size", "status", "modified"});
    }

    @Override
    public String getParentOfPath(String path) {
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return "roots:";
            }
            if (path.length() == 3 && path.endsWith(":\\")) {
                return "roots:";
            }
            if (path.startsWith("\\\\") && path.indexOf(92, 2) == -1) {
                return path;
            }
        }
        return super.getParentOfPath(path);
    }

    @Override
    public String constructPath(String parent, String path) {
        if (parent.endsWith(File.separator) || parent.endsWith("/")) {
            return parent + path;
        }
        return parent + File.separator + path;
    }

    @Override
    public char getFileSeparator() {
        return File.separatorChar;
    }

    @Override
    public String getTwoStageSaveName(String path) {
        File parent = new File(this.getParentOfPath(path));
        return parent.canWrite() || OperatingSystem.isWindows() ? super.getTwoStageSaveName(path) : null;
    }

    @Override
    public boolean save(View view, Buffer buffer, String path) {
        if (OperatingSystem.isUnix()) {
            int permissions = FileVFS.getPermissions(buffer.getPath());
            Log.log(1, this, buffer.getPath() + " has permissions 0" + Integer.toString(permissions, 8));
            buffer.setIntegerProperty(PERMISSIONS_PROPERTY, permissions);
        }
        return super.save(view, buffer, path);
    }

    @Override
    public boolean insert(View view, Buffer buffer, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            VFSManager.error(view, file.getPath(), "ioerror.open-directory", null);
            return false;
        }
        if (!file.canRead()) {
            VFSManager.error(view, file.getPath(), "ioerror.no-read", null);
            return false;
        }
        return super.insert(view, buffer, path);
    }

    public static boolean recursiveDelete(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileVFS.recursiveDelete(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    @Override
    public String _canonPath(Object session, String path, Component comp) throws IOException {
        return MiscUtilities.canonPath(path);
    }

    @Override
    public VFSFile[] _listFiles(Object session, String path, Component comp) {
        if (OperatingSystem.isWindows() && path.length() == 2 && path.charAt(1) == ':') {
            path = path.concat(File.separator);
        }
        File directory = new File(path);
        File[] list = null;
        if (directory.exists()) {
            list = fsView.getFiles(directory, false);
        }
        if (list == null) {
            VFSManager.error(comp, path, "ioerror.directory-error-nomsg", null);
            return null;
        }
        VFSFile[] list2 = new VFSFile[list.length];
        for (int i = 0; i < list.length; ++i) {
            list2[i] = new LocalFile(list[i]);
        }
        return list2;
    }

    @Override
    public VFSFile _getFile(Object session, String path, Component comp) {
        if (path.equals("/") && OperatingSystem.isUnix()) {
            return new VFS.DirectoryEntry(path, path, path, 1, 0L, false);
        }
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        return new LocalFile(file);
    }

    @Override
    public boolean _delete(Object session, String path, Component comp) {
        String canonPath;
        File file = new File(path);
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException io) {
            canonPath = path;
        }
        boolean retVal = !file.isDirectory() ? file.delete() : FileVFS.recursiveDelete(file);
        if (retVal) {
            VFSManager.sendVFSUpdate(this, canonPath, true);
        }
        return retVal;
    }

    @Override
    public boolean _rename(Object session, String from, String to, Component comp) {
        String fromCanonPath;
        String toCanonPath;
        File _to = new File(to);
        try {
            toCanonPath = _to.getCanonicalPath();
        }
        catch (IOException io) {
            toCanonPath = to;
        }
        File parent = new File(_to.getParent());
        if (parent.exists()) {
            if (!parent.isDirectory()) {
                return false;
            }
        } else {
            parent.mkdirs();
            if (!parent.exists()) {
                return false;
            }
        }
        File _from = new File(from);
        try {
            fromCanonPath = _from.getCanonicalPath();
        }
        catch (IOException io) {
            fromCanonPath = from;
        }
        if (!fromCanonPath.equalsIgnoreCase(toCanonPath)) {
            _to.delete();
        }
        boolean retVal = _from.renameTo(_to);
        VFSManager.sendVFSUpdate(this, fromCanonPath, true);
        VFSManager.sendVFSUpdate(this, toCanonPath, true);
        return retVal;
    }

    @Override
    public boolean _mkdir(Object session, String directory, Component comp) {
        String canonPath;
        String parent = this.getParentOfPath(directory);
        if (!new File(parent).exists() && !this._mkdir(session, parent, comp)) {
            return false;
        }
        File file = new File(directory);
        boolean retVal = file.mkdir();
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException io) {
            canonPath = directory;
        }
        VFSManager.sendVFSUpdate(this, canonPath, true);
        return retVal;
    }

    @Override
    public void _backup(Object session, String path, Component comp) throws IOException {
        String backupPrefix = jEdit.getProperty("backup.prefix");
        String backupSuffix = jEdit.getProperty("backup.suffix");
        String backupDirectory = jEdit.getProperty("backup.directory");
        int backupTimeDistance = jEdit.getIntegerProperty("backup.minTime", 0);
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (backupDirectory == null || backupDirectory.length() == 0) {
            backupDirectory = file.getParent();
        } else {
            backupDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), backupDirectory);
            File dir2 = new File(backupDirectory = MiscUtilities.concatPath(backupDirectory, file.getParent()));
            if (!dir2.exists()) {
                dir2.mkdirs();
            }
        }
        MiscUtilities.saveBackup(file, jEdit.getIntegerProperty("backups", 1), backupPrefix, backupSuffix, backupDirectory, backupTimeDistance);
    }

    @Override
    public InputStream _createInputStream(Object session, String path, boolean ignoreErrors, Component comp) throws IOException {
        try {
            return new FileInputStream(path);
        }
        catch (IOException io) {
            if (ignoreErrors) {
                return null;
            }
            throw io;
        }
    }

    @Override
    public OutputStream _createOutputStream(Object session, String path, Component comp) throws IOException {
        return new FileOutputStream(path);
    }

    @Override
    public void _saveComplete(Object session, Buffer buffer, String path, Component comp) {
        int permissions = buffer.getIntegerProperty(PERMISSIONS_PROPERTY, 0);
        FileVFS.setPermissions(path, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getPermissions(String path) {
        int permissions = 0;
        if (jEdit.getBooleanProperty("chmodDisabled")) {
            return permissions;
        }
        if (OperatingSystem.isUnix()) {
            BufferedReader reader;
            block6: {
                String[] cmdarray = new String[]{"ls", "-ld", path};
                InputStreamReader isr = null;
                reader = null;
                try {
                    Process process = Runtime.getRuntime().exec(cmdarray);
                    isr = new InputStreamReader(process.getInputStream());
                    reader = new BufferedReader(isr);
                    String output = reader.readLine();
                    if (output == null) break block6;
                    String s = output.substring(1, 10);
                    permissions = MiscUtilities.parsePermissions(s);
                }
                catch (Throwable t) {
                    IOUtilities.closeQuietly(reader);
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly(reader);
                        throw throwable;
                    }
                }
            }
            IOUtilities.closeQuietly(reader);
        }
        return permissions;
    }

    public static void setPermissions(String path, int permissions) {
        if (jEdit.getBooleanProperty("chmodDisabled")) {
            return;
        }
        if (permissions != 0 && OperatingSystem.isUnix()) {
            String[] cmdarray = new String[]{"chmod", Integer.toString(permissions, 8), path};
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class LocalFile
    extends VFSFile {
        private File file;
        public static DateFormat DATE_FORMAT = DateFormat.getInstance();
        @Deprecated
        public long modified;
        private transient FileSystemView fsView;
        private transient Icon icon;

        public LocalFile(File file) {
            this.file = file;
            this.setName(file.getName());
            String path = file.getPath();
            this.setPath(path);
            this.setDeletePath(path);
            this.setHidden(file.isHidden());
            this.setType(file.isDirectory() ? 1 : 0);
        }

        @Override
        public String getExtendedAttribute(String name) {
            this.fetchAttrs();
            if (name.equals("modified")) {
                return DATE_FORMAT.format(new Date(this.modified));
            }
            return super.getExtendedAttribute(name);
        }

        @Override
        protected void fetchAttrs() {
            if (this.fetchedAttrs()) {
                return;
            }
            super.fetchAttrs();
            this.setSymlinkPath(MiscUtilities.resolveSymlinks(this.file.getPath()));
            this.setReadable(this.file.canRead());
            this.setWriteable(this.file.canWrite());
            this.setLength(this.file.length());
            this.setModified(this.file.lastModified());
        }

        @Override
        public Icon getIcon(boolean expanded, boolean openBuffer) {
            if (this.icon == null) {
                if (this.fsView == null) {
                    this.fsView = FileSystemView.getFileSystemView();
                }
                this.icon = this.fsView.getSystemIcon(this.file);
            }
            return this.icon;
        }

        @Override
        public String getSymlinkPath() {
            this.fetchAttrs();
            return super.getSymlinkPath();
        }

        @Override
        public long getLength() {
            this.fetchAttrs();
            return super.getLength();
        }

        @Override
        public boolean isReadable() {
            this.fetchAttrs();
            return super.isReadable();
        }

        @Override
        public boolean isWriteable() {
            this.fetchAttrs();
            return super.isWriteable();
        }

        public long getModified() {
            this.fetchAttrs();
            return this.modified;
        }

        public void setModified(long modified) {
            this.modified = modified;
        }
    }
}

