/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ModeCatalogHandler
extends DefaultHandler {
    private String directory;
    private boolean resource;

    ModeCatalogHandler(String directory, boolean resource) {
        this.directory = directory;
        this.resource = resource;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "catalog.dtd", this.getClass());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        if (qName.equals("MODE")) {
            String modeName = attrs.getValue("NAME");
            String file = attrs.getValue("FILE");
            if (file == null) {
                Log.log(9, this, this.directory + "catalog:" + " mode " + modeName + " doesn't have" + " a FILE attribute");
            }
            String filenameGlob = attrs.getValue("FILE_NAME_GLOB");
            String firstlineGlob = attrs.getValue("FIRST_LINE_GLOB");
            Mode mode = ModeProvider.instance.getMode(modeName);
            if (mode == null) {
                mode = this.instantiateMode(modeName);
            }
            ModeProvider.instance.addMode(mode);
            Object path = this.resource ? jEdit.class.getResource(this.directory + file) : MiscUtilities.constructPath(this.directory, file);
            mode.setProperty("file", path);
            mode.unsetProperty("filenameGlob");
            if (filenameGlob != null) {
                mode.setProperty("filenameGlob", filenameGlob);
            }
            mode.unsetProperty("firstlineGlob");
            if (firstlineGlob != null) {
                mode.setProperty("firstlineGlob", firstlineGlob);
            }
            mode.init();
        }
    }

    protected Mode instantiateMode(String modeName) {
        return new Mode(modeName);
    }
}

