/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.indent.DeepIndentRule;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.indent.IndentRuleFactory;
import org.gjt.sp.jedit.indent.WhitespaceRule;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class Mode {
    protected String name;
    protected Map<String, Object> props;
    private Pattern firstlineRE;
    private Pattern filenameRE;
    protected TokenMarker marker;
    private List<IndentRule> indentRules;
    private String electricKeys;
    private boolean ignoreWhitespace;

    public Mode(String name) {
        this.name = name;
        this.ignoreWhitespace = true;
        this.props = new Hashtable<String, Object>();
    }

    public void init() {
        try {
            this.filenameRE = null;
            String filenameGlob = (String)this.getProperty("filenameGlob");
            if (filenameGlob != null && filenameGlob.length() != 0) {
                this.filenameRE = Pattern.compile(StandardUtilities.globToRE(filenameGlob), 2);
            }
            this.firstlineRE = null;
            String firstlineGlob = (String)this.getProperty("firstlineGlob");
            if (firstlineGlob != null && firstlineGlob.length() != 0) {
                this.firstlineRE = Pattern.compile(StandardUtilities.globToRE(firstlineGlob), 2);
            }
        }
        catch (PatternSyntaxException re) {
            Log.log(9, this, "Invalid filename/firstline globs in mode " + this.name);
            Log.log(9, this, re);
        }
        this.marker = null;
    }

    public TokenMarker getTokenMarker() {
        this.loadIfNecessary();
        return this.marker;
    }

    public void setTokenMarker(TokenMarker marker) {
        this.marker = marker;
    }

    public void loadIfNecessary() {
        if (this.marker == null) {
            ModeProvider.instance.loadMode(this);
            if (this.marker == null) {
                Log.log(9, this, "Mode not correctly loaded, token marker is still null");
            }
        }
    }

    public Object getProperty(String key) {
        Object value = this.props.get(key);
        if (value != null) {
            return value;
        }
        return null;
    }

    public boolean getBooleanProperty(String key) {
        Object value = this.getProperty(key);
        return StandardUtilities.getBoolean(value, false);
    }

    public void setProperty(String key, Object value) {
        this.props.put(key, value);
    }

    public void unsetProperty(String key) {
        this.props.remove(key);
    }

    public void setProperties(Map props) {
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        this.ignoreWhitespace = !"false".equalsIgnoreCase((String)props.get("ignoreWhitespace"));
        String filenameGlob = (String)this.props.get("filenameGlob");
        String firstlineGlob = (String)this.props.get("firstlineGlob");
        String filename = (String)this.props.get("file");
        this.props = props;
        if (filenameGlob != null) {
            props.put("filenameGlob", filenameGlob);
        }
        if (firstlineGlob != null) {
            props.put("firstlineGlob", firstlineGlob);
        }
        if (filename != null) {
            props.put("file", filename);
        }
    }

    public boolean accept(String fileName, String firstLine) {
        return this.acceptFilename(fileName) || this.acceptFirstLine(firstLine);
    }

    public boolean acceptFilename(String fileName) {
        return this.filenameRE != null && this.filenameRE.matcher(fileName).matches();
    }

    public boolean acceptFilenameIdentical(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.equals((String)this.getProperty("filenameGlob")) && (this.filenameRE == null || this.filenameRE.matcher(fileName).matches());
    }

    public boolean acceptFirstLine(String firstLine) {
        return this.firstlineRE != null && this.firstlineRE.matcher(firstLine).matches();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean getIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public synchronized List<IndentRule> getIndentRules() {
        if (this.indentRules == null) {
            this.initIndentRules();
        }
        return this.indentRules;
    }

    public synchronized boolean isElectricKey(char ch) {
        if (this.electricKeys == null) {
            String[] props = new String[]{"indentOpenBrackets", "indentCloseBrackets", "electricKeys"};
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < props.length; ++i) {
                String prop = (String)this.getProperty(props[i]);
                if (prop == null) continue;
                buf.append(prop);
            }
            this.electricKeys = buf.toString();
        }
        return this.electricKeys.indexOf(ch) >= 0;
    }

    private void initIndentRules() {
        String unalignedOpenBrackets;
        LinkedList<IndentRule> rules = new LinkedList<IndentRule>();
        String[] regexpProps = new String[]{"indentNextLine", "indentNextLines"};
        for (int i = 0; i < regexpProps.length; ++i) {
            IndentRule rule = this.createRegexpIndentRule(regexpProps[i]);
            if (rule == null) continue;
            rules.add(rule);
        }
        String[] bracketProps = new String[]{"indentOpenBracket", "indentCloseBracket", "unalignedOpenBracket", "unalignedCloseBracket"};
        for (int i = 0; i < bracketProps.length; ++i) {
            this.createBracketIndentRules(bracketProps[i], rules);
        }
        String[] finalProps = new String[]{"unindentThisLine", "unindentNextLines"};
        for (int i = 0; i < finalProps.length; ++i) {
            IndentRule rule = this.createRegexpIndentRule(finalProps[i]);
            if (rule == null) continue;
            rules.add(rule);
        }
        if (this.getBooleanProperty("deepIndent") && (unalignedOpenBrackets = (String)this.getProperty("unalignedOpenBrackets")) != null) {
            for (int i = 0; i < unalignedOpenBrackets.length(); ++i) {
                char openChar = unalignedOpenBrackets.charAt(i);
                char closeChar = TextUtilities.getComplementaryBracket(openChar, null);
                if (closeChar == '\u0000') continue;
                rules.add(new DeepIndentRule(openChar, closeChar));
            }
        }
        if (!this.getIgnoreWhitespace()) {
            rules.add(new WhitespaceRule());
        }
        this.indentRules = Collections.unmodifiableList(rules);
    }

    private IndentRule createRegexpIndentRule(String prop) {
        String value = (String)this.getProperty(prop);
        try {
            if (value != null) {
                Method m = IndentRuleFactory.class.getMethod(prop, String.class);
                return (IndentRule)m.invoke(null, value);
            }
        }
        catch (Exception e) {
            Log.log(9, this, "Bad indent rule " + prop + '=' + value + ':');
            Log.log(9, this, e);
        }
        return null;
    }

    private void createBracketIndentRules(String prop, List<IndentRule> rules) {
        String value = (String)this.getProperty(prop + 's');
        try {
            if (value != null) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    Method m = IndentRuleFactory.class.getMethod(prop, Character.TYPE);
                    rules.add((IndentRule)m.invoke(null, Character.valueOf(ch)));
                }
            }
        }
        catch (Exception e) {
            Log.log(9, this, "Bad indent rule " + prop + '=' + value + ':');
            Log.log(9, this, e);
        }
    }
}

