/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.util.Log;
import sidekick.Asset;
import sidekick.IAsset;
import sidekick.enhanced.SourceAsset;

public class SideKickParsedData {
    public DefaultTreeModel tree;
    public DefaultMutableTreeNode root;
    public List<Integer> expansionModel = null;

    public static SideKickParsedData getParsedData(View view) {
        return (SideKickParsedData)view.getRootPane().getClientProperty("sidekick.parsed-data");
    }

    public static void setParsedData(View view, SideKickParsedData data) {
        Log.log((int)1, SideKickParsedData.class, (Object)("Setting parsed data of " + view + " to " + data));
        view.getRootPane().putClientProperty("sidekick.parsed-data", data);
    }

    public SideKickParsedData(String fileName) {
        SourceAsset asset = new SourceAsset(fileName, 0, new Position(){

            public int getOffset() {
                return 0;
            }
        });
        asset.setEnd(new Position(){

            public int getOffset() {
                return Integer.MAX_VALUE;
            }
        });
        this.root = new DefaultMutableTreeNode(asset);
        this.tree = new DefaultTreeModel(this.root);
    }

    public TreePath getTreePathForPosition(int dot) {
        if (this.root.getChildCount() == 0) {
            return null;
        }
        IAsset asset = this.getAsset(this.root);
        if (asset != null && !SideKickParsedData.assetContains(asset, dot)) {
            return null;
        }
        TreeNode node = this.getNodeAt(this.root, dot);
        if (node == null) {
            node = this.root;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        while (node != null) {
            nodeList.add(node);
            node = node.getParent();
        }
        Collections.reverse(nodeList);
        return new TreePath(nodeList.toArray());
    }

    protected TreeNode getNodeAt(TreeNode parent, int offset) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode node = parent.getChildAt(i);
            TreeNode child = this.getNodeAt(node, offset);
            if (child != null) {
                return child;
            }
            if (!SideKickParsedData.assetContains(this.getAsset(node), offset)) continue;
            return node;
        }
        return null;
    }

    protected FoldHandler getFoldHandler() {
        return null;
    }

    private static boolean assetContains(IAsset asset, int offset) {
        if (asset == null) {
            return false;
        }
        return offset >= asset.getStart().getOffset() && offset < asset.getEnd().getOffset();
    }

    protected boolean canAddToPath(TreeNode node) {
        return true;
    }

    public Asset getAssetAtPosition(int pos) {
        return (Asset)this.getAssetAtOffset(pos);
    }

    public IAsset getAssetAtOffset(int pos) {
        TreePath path = this.getTreePathForPosition(pos);
        if (path == null) {
            return null;
        }
        return (IAsset)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
    }

    public IAsset getAsset(TreeNode node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof IAsset)) {
            return null;
        }
        IAsset asset = (IAsset)userObject;
        return asset;
    }
}

