/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.CompletionPopup;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import sidekick.SideKickCompletion;
import sidekick.SideKickParser;

public class SideKickCompletionPopup
extends CompletionPopup {
    private View view;
    private SideKickParser parser;
    private SideKickCompletion complete;

    public SideKickCompletionPopup(View view, SideKickParser parser, int caret, SideKickCompletion complete, boolean active) {
        super(view, SideKickCompletionPopup.getLocation(view.getTextArea(), caret, complete));
        this.view = view;
        this.parser = parser;
        this.complete = complete;
        this.reset(new Candidates(), active);
    }

    public SideKickCompletionPopup(View view, SideKickParser parser, int caret, SideKickCompletion complete) {
        this(view, parser, caret, complete, false);
    }

    protected void keyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                this.keyTyped('\n');
                evt.consume();
                break;
            }
            case 9: {
                this.keyTyped('\t');
                evt.consume();
                break;
            }
            case 32: {
                evt.consume();
                break;
            }
            case 8: {
                if (this.parser.canHandleBackspace()) break;
                this.dispose();
                break;
            }
            case 127: {
                this.dispose();
                break;
            }
        }
    }

    public void keyTyped(KeyEvent evt) {
        char ch = evt.getKeyChar();
        if (ch == '\b' && !this.parser.canHandleBackspace()) {
            evt.consume();
            return;
        }
        this.keyTyped(ch);
        evt.consume();
    }

    private static Point getLocation(JEditTextArea textArea, int caret, SideKickCompletion complete) {
        Point location = textArea.offsetToXY(caret - complete.getTokenLength());
        location.y += textArea.getPainter().getFontMetrics().getHeight();
        SwingUtilities.convertPointToScreen(location, (Component)textArea.getPainter());
        return location;
    }

    private void keyTyped(char ch) {
        int selected = this.getSelectedIndex();
        if (selected == -1) {
            this.view.getTextArea().userInput(ch);
            this.updateCompletion(false);
        } else if (this.complete.handleKeystroke(selected, ch)) {
            this.updateCompletion(true);
        } else {
            this.dispose();
        }
    }

    private void updateCompletion(boolean active) {
        JEditTextArea textArea;
        int caret;
        SideKickCompletion newComplete = this.complete;
        EditPane editPane = this.view.getEditPane();
        if (!newComplete.updateInPlace(editPane, caret = (textArea = editPane.getTextArea()).getCaretPosition())) {
            newComplete = this.parser.complete(editPane, caret);
        }
        if (newComplete == null || newComplete.size() == 0) {
            this.dispose();
        } else {
            this.complete = newComplete;
            this.setLocation(SideKickCompletionPopup.getLocation(textArea, caret, this.complete));
            this.reset(new Candidates(), active);
        }
    }

    private class Candidates
    implements CompletionPopup.Candidates {
        private final ListCellRenderer renderer;

        public Candidates() {
            this.renderer = SideKickCompletionPopup.this.complete.getRenderer();
        }

        public int getSize() {
            return SideKickCompletionPopup.this.complete.size();
        }

        public boolean isValid() {
            return SideKickCompletionPopup.this.complete != null && SideKickCompletionPopup.this.complete.size() > 0;
        }

        public void complete(int index) {
            SideKickCompletionPopup.this.complete.insert(index);
        }

        public Component getCellRenderer(JList list, int index, boolean isSelected, boolean cellHasFocus) {
            return this.renderer.getListCellRendererComponent(list, SideKickCompletionPopup.this.complete.get(index), index, isSelected, cellHasFocus);
        }

        public String getDescription(int index) {
            return SideKickCompletionPopup.this.complete.getCompletionDescription(index);
        }
    }
}

