/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StringList;
import sidekick.AbstractModeOptionPane;
import sidekick.ModeOptionPane;

public class ModeOptionsDialog
extends OptionsDialog {
    public static final String SERVICECLASS = "org.gjt.sp.jedit.options.ModeOptionPane";
    public static final String DEFAULT = jEdit.getProperty((String)"options.editing.global");
    public static final String ALL = "ALL";
    Vector<ModeOptionPane> panes;
    OptionsDialog.OptionTreeModel paneTreeModel;
    StringList modes;
    JComboBox modeCombo;
    JCheckBox useDefaultsCheck;

    public ModeOptionsDialog(View v) {
        super((Frame)v, "options.mode.settings", "sidekick.mode");
    }

    public String getMode() {
        return this.modeCombo.getSelectedItem().toString();
    }

    protected OptionsDialog.OptionTreeModel createOptionTreeModel() {
        this.modes = new StringList((Object[])jEdit.getModes());
        Collections.sort(this.modes, new MiscUtilities.StringICaseCompare());
        this.modes.add(0, (Object)DEFAULT);
        this.modeCombo = new JComboBox<String>(this.modes.toArray());
        this.useDefaultsCheck = new JCheckBox(jEdit.getProperty((String)"options.editing.useDefaults"));
        JLabel editModeLabel = new JLabel(jEdit.getProperty((String)"buffer-options.mode"));
        GridLayout gl = new GridLayout(1, 3);
        JPanel editModePanel = new JPanel(gl);
        editModePanel.add(this.useDefaultsCheck);
        editModePanel.add(editModeLabel);
        editModePanel.add(this.modeCombo);
        JPanel content = (JPanel)this.getContentPane();
        content.add((Component)editModePanel, "North");
        this.paneTreeModel = new OptionsDialog.OptionTreeModel((OptionsDialog)this);
        OptionGroup root = (OptionGroup)this.paneTreeModel.getRoot();
        this.panes = new Vector();
        for (String service : ServiceManager.getServiceNames((String)SERVICECLASS)) {
            AbstractModeOptionPane mop = (AbstractModeOptionPane)ServiceManager.getService((String)SERVICECLASS, (String)service);
            root.addOptionPane((OptionPane)mop);
            this.panes.add(mop);
        }
        this.modeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ModeOptionsDialog.this.modeSelected();
            }
        });
        this.useDefaultsCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModeOptionsDialog.this.useDefaultsChanged();
            }
        });
        String currentMode = jEdit.getActiveView().getBuffer().getMode().getName();
        this.modeCombo.setSelectedItem(currentMode);
        return this.paneTreeModel;
    }

    private void useDefaultsChanged() {
        if (this.currentPane instanceof AbstractModeOptionPane) {
            ((AbstractModeOptionPane)this.currentPane).setUseDefaults(this.useDefaultsCheck.isSelected());
        }
    }

    private void modeSelected() {
        String mode;
        int index = this.modeCombo.getSelectedIndex();
        if (index == 0) {
            mode = null;
            this.useDefaultsCheck.setEnabled(false);
        } else {
            mode = (String)this.modeCombo.getItemAt(index);
            this.useDefaultsCheck.setEnabled(true);
        }
        if (this.currentPane instanceof AbstractModeOptionPane) {
            AbstractModeOptionPane current = (AbstractModeOptionPane)this.currentPane;
            current.modeSelected(mode);
            this.useDefaultsCheck.setSelected(current.getUseDefaults(mode));
        } else {
            this.useDefaultsCheck.setSelected(false);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        super.valueChanged(evt);
        this.modeSelected();
    }

    private void load(Object obj) {
        if (obj instanceof OptionGroup) {
            OptionGroup grp = (OptionGroup)obj;
            Enumeration members = grp.getMembers();
            while (members.hasMoreElements()) {
                this.load(members.nextElement());
            }
        }
    }

    protected void load() {
        this.load(this.getDefaultGroup());
    }

    protected OptionGroup getDefaultGroup() {
        return (OptionGroup)this.paneTreeModel.getRoot();
    }

    public void cancel() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).cancel();
        }
        super.cancel();
    }
}

