/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import sidekick.ModeOptionPane;

public class ModeOptionPaneController
implements ModeOptionPane {
    private HashMap<String, Object> modeProps = new HashMap();
    private Set<String> useDefaults = new HashSet<String>();
    private Object props;
    private String mode;
    ModeOptionPaneDelegate delegate;

    public ModeOptionPaneController(ModeOptionPaneDelegate mop) {
        this.delegate = mop;
    }

    public void modeSelected(String mode) {
        if (this.mode != null) {
            this.delegate.updatePropsFromUI(this.props);
        }
        this.mode = mode;
        this.props = this.modeProps.get(mode);
        if (this.props == null) {
            this.props = this.delegate.createModeProps(mode);
            if (mode != null && !this.delegate.hasModeProps(mode)) {
                this.useDefaults.add(mode);
            }
            this.modeProps.put(mode, this.props);
        }
        this.delegate.updateUIFromProps(this.props);
        this.setEnabled(this.delegate.getUIComponent(), !this.useDefaults.contains(mode));
    }

    public void setUseDefaults(boolean b) {
        if (b) {
            this.useDefaults.add(this.mode);
        } else {
            this.useDefaults.remove(this.mode);
        }
        this.setEnabled(this.delegate.getUIComponent(), !b);
    }

    public void setEnabled(JComponent c, boolean enabled) {
        c.setEnabled(enabled);
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof JComponent)) continue;
            this.setEnabled((JComponent)children[i], enabled);
        }
    }

    public void save() {
        this.delegate.updatePropsFromUI(this.props);
        for (String m : this.modeProps.keySet()) {
            if (this.useDefaults.contains(m)) {
                this.delegate.resetModeProps(m);
                continue;
            }
            this.delegate.saveModeProps(m, this.modeProps.get(m));
        }
    }

    public void cancel() {
        this.modeProps.clear();
    }

    public boolean getUseDefaults(String mode) {
        if (this.modeProps.get(mode) != null) {
            return this.useDefaults.contains(mode);
        }
        return !this.delegate.hasModeProps(mode);
    }

    public static interface ModeOptionPaneDelegate {
        public JComponent getUIComponent();

        public void updatePropsFromUI(Object var1);

        public void updateUIFromProps(Object var1);

        public Object createModeProps(String var1);

        public void saveModeProps(String var1, Object var2);

        public void resetModeProps(String var1);

        public boolean hasModeProps(String var1);
    }
}

