/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;

class ModeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5314012645070764005L;
    private ArrayList<Entry> modes;

    ModeTableModel() {
        Mode[] _modes = jEdit.getModes();
        this.modes = new ArrayList(_modes.length);
        for (int i = 0; i < _modes.length; ++i) {
            this.modes.add(new Entry(_modes[i].getName()));
        }
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.modes.size();
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public Object getValueAt(int row, int col) {
        Entry mode = this.modes.get(row);
        switch (col) {
            case 0: {
                return mode.name;
            }
            case 1: {
                return mode.compiler == null ? "none" : mode.compiler;
            }
            case 2: {
                return mode.interpreter == null ? "none" : mode.interpreter;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        Entry mode = this.modes.get(row);
        switch (col) {
            case 1: {
                mode.compiler = (String)value;
                if (!mode.compiler.equals("none")) break;
                mode.compiler = null;
                break;
            }
            case 2: {
                mode.interpreter = (String)value;
                if (!mode.interpreter.equals("none")) break;
                mode.interpreter = null;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty((String)"options.console.compile-run.mode");
            }
            case 1: {
                return jEdit.getProperty((String)"options.console.compile-run.compiler");
            }
            case 2: {
                return jEdit.getProperty((String)"options.console.compile-run.interpreter");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.modes.size(); ++i) {
            this.modes.get(i).save();
        }
    }

    static class Entry {
        String name;
        String compiler;
        String interpreter;

        Entry(String name) {
            this.name = name;
            this.compiler = jEdit.getProperty((String)("mode." + name + ".commando.compile"));
            this.interpreter = jEdit.getProperty((String)("mode." + name + ".commando.run"));
        }

        void save() {
            if (this.compiler != null) {
                jEdit.setProperty((String)("mode." + this.name + ".commando.compile"), (String)this.compiler.replace(' ', '_'));
            } else {
                jEdit.unsetProperty((String)("mode." + this.name + ".commando.compile"));
            }
            if (this.interpreter != null) {
                jEdit.setProperty((String)("mode." + this.name + ".commando.run"), (String)this.interpreter.replace(' ', '_'));
            } else {
                jEdit.unsetProperty((String)("mode." + this.name + ".commando.run"));
            }
        }
    }
}

