/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePlugin;
import console.ConsoleProcess;
import console.Output;
import console.SystemShell;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SystemShellBuiltIn {
    protected String name = this.name.substring(this.name.lastIndexOf(36) + 1);
    protected String help = jEdit.getProperty((String)("console.shell." + this.name + ".usage"));

    public SystemShellBuiltIn() {
        if (this.help == null) {
            Log.log((int)7, (Object)this, (Object)(this.name + " is missing usage info"));
        }
    }

    public Option[] getOptions() {
        return new Option[0];
    }

    private static SystemShell.ConsoleState getConsoleState(Console console) {
        return ConsolePlugin.getSystemShell().getConsoleState(console);
    }

    public int getMinArguments() {
        return 0;
    }

    public int getMaxArguments() {
        return -1;
    }

    public void execute(Console console, Output output, Output error, Vector<String> args) {
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        Option[] options = this.getOptions();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.elementAt(i);
            if (arg.equals("--")) {
                args.removeElementAt(i);
                break;
            }
            if (arg.equals("--help")) {
                error.print(null, this.help);
                return;
            }
            if (arg.startsWith("--")) {
                boolean no;
                if (arg.length() == 2) continue;
                args.removeElementAt(i);
                --i;
                String longName = arg.substring(2);
                if (longName.startsWith("no-")) {
                    no = true;
                    longName = longName.substring(3);
                } else {
                    no = false;
                }
                Option option = null;
                for (int j = 0; j < options.length; ++j) {
                    if (!options[j].longName.equals(longName)) continue;
                    option = options[j];
                    break;
                }
                if (option == null) {
                    Object[] pp = new String[]{longName};
                    error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.bad-opt-long", (Object[])pp));
                    return;
                }
                if (option.takesArgument) {
                    if (no) {
                        Object[] pp = new String[]{longName};
                        error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.no-arg-long", (Object[])pp));
                        return;
                    }
                    if (i == args.size() - 1) {
                        Object[] pp = new String[]{longName};
                        error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.need-arg-long", (Object[])pp));
                        return;
                    }
                    values.put(longName, args.elementAt(i + 1));
                    args.removeElementAt(i + 1);
                    continue;
                }
                if (no) {
                    values.put(longName, Boolean.FALSE);
                    continue;
                }
                values.put(longName, Boolean.TRUE);
                continue;
            }
            if (!arg.startsWith("-") && !arg.startsWith("+") || arg.length() == 1) continue;
            args.removeElementAt(i);
            --i;
            boolean no = arg.charAt(0) == '+';
            for (int j = 1; j < arg.length(); ++j) {
                char shortName = arg.charAt(j);
                Option option = null;
                for (int k = 0; k < options.length; ++k) {
                    if (options[k].shortName != shortName) continue;
                    option = options[k];
                    break;
                }
                if (option == null) {
                    Object[] pp = new String[]{String.valueOf(shortName)};
                    error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.bad-opt", (Object[])pp));
                    return;
                }
                if (no) {
                    values.put(option.longName, Boolean.FALSE);
                    continue;
                }
                values.put(option.longName, Boolean.TRUE);
            }
        }
        int min = this.getMinArguments();
        int max = this.getMaxArguments();
        if (args.size() < this.getMinArguments() || max != -1 && args.size() > this.getMaxArguments()) {
            error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.bad-args"));
            return;
        }
        this.execute(console, output, error, args, values);
    }

    protected abstract void execute(Console var1, Output var2, Output var3, Vector<String> var4, Hashtable<String, Object> var5);

    static class version
    extends SystemShellBuiltIn {
        version() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            output.print(null, jEdit.getProperty((String)"plugin.console.ConsolePlugin.version"));
        }
    }

    static class unset
    extends SystemShellBuiltIn {
        unset() {
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            Map<String, String> variables = ConsolePlugin.getSystemShell().getVariables();
            variables.remove(args.elementAt(0));
        }
    }

    static class unalias
    extends SystemShellBuiltIn {
        unalias() {
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            Hashtable<String, String> aliases2 = ConsolePlugin.getSystemShell().getAliases();
            aliases2.remove(args.elementAt(0));
        }
    }

    static class set
    extends SystemShellBuiltIn {
        set() {
        }

        public int getMinArguments() {
            return 2;
        }

        public int getMaxArguments() {
            return 2;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            Map<String, String> variables = ConsolePlugin.getSystemShell().getVariables();
            variables.put((String)args.elementAt(0), (String)args.elementAt(1));
        }
    }

    static class run
    extends SystemShellBuiltIn {
        run() {
        }

        public int getMinArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            String currentDirectory = SystemShellBuiltIn.getConsoleState((Console)console).currentDirectory;
            for (int i = 0; i < args.size(); ++i) {
                Macros.runScript((View)console.getView(), (String)MiscUtilities.constructPath((String)currentDirectory, (String)((String)args.get(i))), (boolean)false);
            }
        }
    }

    static class pwd
    extends SystemShellBuiltIn {
        pwd() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            SystemShell.ConsoleState cs = SystemShellBuiltIn.getConsoleState(console);
            output.writeAttrs(null, cs.currentDirectory + "\n");
        }
    }

    static class pushd
    extends SystemShellBuiltIn {
        pushd() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            SystemShell.ConsoleState state = SystemShellBuiltIn.getConsoleState(console);
            Stack<String> directoryStack = state.directoryStack;
            directoryStack.push(state.currentDirectory);
            if (args.size() > 0) {
                state.setCurrentDirectory(console, args.get(0).toString());
            }
            Object[] pp = new String[]{state.currentDirectory};
            error.print(null, jEdit.getProperty((String)"console.shell.pushd.ok", (Object[])pp));
        }
    }

    static class popd
    extends SystemShellBuiltIn {
        popd() {
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            SystemShell.ConsoleState state = SystemShellBuiltIn.getConsoleState(console);
            Stack<String> directoryStack = state.directoryStack;
            if (directoryStack.isEmpty()) {
                error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.popd.error"));
                return;
            }
            String newDir = directoryStack.pop();
            state.setCurrentDirectory(console, newDir);
        }
    }

    static class kill
    extends SystemShellBuiltIn {
        kill() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            SystemShell.ConsoleState state = SystemShellBuiltIn.getConsoleState(console);
            ConsoleProcess process = state.getProcess();
            if (process == null) {
                error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.noproc"));
                return;
            }
        }
    }

    static class help
    extends SystemShellBuiltIn {
        static String HELP_PATH = "jeditresource:/Console.jar!/index.html";

        help() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            if (args.size() == 1) {
                String help2;
                String cmd = (String)args.get(0);
                if (cmd.startsWith("%")) {
                    cmd = cmd.substring(1);
                }
                if ((help2 = jEdit.getProperty((String)("console.shell." + cmd + ".usage"))) != null) {
                    error.print(null, help2);
                } else {
                    ActionContext ac = jEdit.getActionContext();
                    EditAction ea = ac.getAction("help");
                    ea.invoke(jEdit.getActiveView());
                }
            } else {
                new HelpViewer(HELP_PATH);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class env
    extends SystemShellBuiltIn {
        env() {
        }

        @Override
        public int getMinArguments() {
            return 0;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        @Override
        public void execute(Console console, Output output, Output error, Vector<String> args, Hashtable<String, Object> values) {
            Map<String, String> variables = ConsolePlugin.getSystemShell().getVariables();
            StringList returnValue = new StringList();
            for (Map.Entry<String, String> ent : variables.entrySet()) {
                returnValue.add((Object)(ent.getKey() + "=" + ent.getValue()));
            }
            Collections.sort(returnValue, new MiscUtilities.StringICaseCompare());
            for (int i = 0; i < returnValue.size(); ++i) {
                output.print(null, (String)returnValue.get(i));
            }
        }
    }

    static class edit
    extends SystemShellBuiltIn {
        edit() {
        }

        public int getMinArguments() {
            return 1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            String currentDirectory = SystemShellBuiltIn.getConsoleState((Console)console).currentDirectory;
            for (int i = 0; i < args.size(); ++i) {
                jEdit.openFile((View)console.getView(), (String)currentDirectory, (String)((String)args.elementAt(i)), (boolean)false, null);
            }
        }
    }

    static class echo
    extends SystemShellBuiltIn {
        echo() {
        }

        public int getMinArguments() {
            return 1;
        }

        public int getMaxArguments() {
            return -1;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            for (int i = 0; i < args.size(); ++i) {
                output.print(null, (String)args.elementAt(i));
            }
        }
    }

    static class dirstack
    extends SystemShellBuiltIn {
        dirstack() {
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            Stack<String> directoryStack = SystemShellBuiltIn.getConsoleState((Console)console).directoryStack;
            for (int i = 0; i < directoryStack.size(); ++i) {
                output.print(null, (String)directoryStack.elementAt(i));
            }
        }
    }

    static class clear
    extends SystemShellBuiltIn {
        clear() {
        }

        public int getMinArguments() {
            return 0;
        }

        public int getMaxArguments() {
            return 0;
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            console.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class cd
    extends SystemShellBuiltIn {
        cd() {
        }

        @Override
        public int getMaxArguments() {
            return 1;
        }

        @Override
        public void execute(Console console, Output output, Output error, Vector<String> args, Hashtable<String, Object> values) {
            SystemShell.ConsoleState state = SystemShellBuiltIn.getConsoleState(console);
            if (args.size() == 0) {
                state.setCurrentDirectory(console, System.getProperty("user.home"));
            } else {
                String arg = args.elementAt(0);
                if (arg.equals("-")) {
                    state.gotoLastDirectory(console);
                } else {
                    int colonPos;
                    state.setCurrentDirectory(console, MiscUtilities.constructPath((String)state.currentDirectory, (String)arg));
                    if (OperatingSystem.isDOSDerived() && (colonPos = arg.indexOf(":")) > 0) {
                        char driveLetter = arg.charAt(0);
                        args = state.changeDrive(driveLetter);
                    }
                }
            }
        }
    }

    static class browse
    extends SystemShellBuiltIn {
        browse() {
        }

        public int getMaxArguments() {
            return 1;
        }

        public Option[] getOptions() {
            return new Option[]{new Option('n', "new-window", false)};
        }

        public void execute(Console console, Output output, Output error, Vector args, Hashtable values) {
            String directory;
            String currentDirectory = SystemShellBuiltIn.getConsoleState((Console)console).currentDirectory;
            String string = directory = args.size() == 0 ? currentDirectory : MiscUtilities.constructPath((String)currentDirectory, (String)((String)args.elementAt(0)));
            if (values.get("new-window") != null) {
                VFSBrowser.browseDirectoryInNewWindow((View)console.getView(), (String)directory);
            } else {
                VFSBrowser.browseDirectory((View)console.getView(), (String)directory);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class aliases
    extends SystemShellBuiltIn {
        aliases() {
        }

        @Override
        public int getMinArguments() {
            return 0;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        @Override
        public void execute(Console console, Output output, Output error, Vector<String> args, Hashtable<String, Object> values) {
            Hashtable<String, String> aliases2 = ConsolePlugin.getSystemShell().getAliases();
            StringList returnValue = new StringList();
            for (Map.Entry<String, String> ent : aliases2.entrySet()) {
                returnValue.add((Object)(ent.getKey() + "=" + ent.getValue()));
            }
            Collections.sort(returnValue, new MiscUtilities.StringICaseCompare());
            for (int i = 0; i < returnValue.size(); ++i) {
                output.print(null, (String)returnValue.get(i));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class alias
    extends SystemShellBuiltIn {
        alias() {
        }

        @Override
        public int getMinArguments() {
            return 2;
        }

        @Override
        public int getMaxArguments() {
            return 2;
        }

        @Override
        public void execute(Console console, Output output, Output error, Vector<String> args, Hashtable<String, Object> values) {
            Hashtable<String, String> aliases2 = ConsolePlugin.getSystemShell().getAliases();
            aliases2.put(args.elementAt(0), args.elementAt(1));
        }
    }

    public class Option {
        public char shortName;
        public String longName;
        public boolean takesArgument;

        public Option(char shortName, String longName, boolean takesArgument) {
            this.shortName = shortName;
            this.longName = longName;
            this.takesArgument = takesArgument;
        }
    }
}

