/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.ConsoleHistoryText;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.gjt.sp.jedit.gui.HistoryModel;

public class ConsolePane
extends JTextPane {
    public static final String InputStart = "InputStart";
    public static final Object Input = new Object();
    public static final Object Actions = new Object();
    private static final Cursor MoveCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor DefaultCursor = Cursor.getPredefinedCursor(2);
    private EventListenerList listenerList;
    private ConsoleHistoryText history;
    private transient DocumentHandler documentHandler;

    public ConsolePane() {
        this.setInputStart(0);
        MouseHandler mouse = new MouseHandler();
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
        this.history = new ConsoleHistoryText(this);
        this.listenerList = new EventListenerList();
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), new EnterAction());
        inputMap.put(KeyStroke.getKeyStroke('\b'), new BackspaceAction());
        inputMap.put(KeyStroke.getKeyStroke(85, 2), new DeleteInputAction());
        inputMap.put(KeyStroke.getKeyStroke(36, 0), new HomeAction());
        inputMap.put(KeyStroke.getKeyStroke(36, 1), new SelectHomeAction());
        HistoryUpAction hup = new HistoryUpAction(actionMap.get("caret-up"));
        inputMap.put(KeyStroke.getKeyStroke(38, 0), hup);
        inputMap.put(KeyStroke.getKeyStroke(80, 2), hup);
        HistoryDownAction down = new HistoryDownAction(actionMap.get("caret-down"));
        inputMap.put(KeyStroke.getKeyStroke(40, 0), down);
        inputMap.put(KeyStroke.getKeyStroke(78, 2), down);
        inputMap.put(KeyStroke.getKeyStroke(38, 1), new SearchUpAction(actionMap.get("selection-up")));
        inputMap.put(KeyStroke.getKeyStroke(40, 1), new SearchDownAction(actionMap.get("selection-down")));
        inputMap.put(KeyStroke.getKeyStroke(8, 0), new DummyAction());
        this.documentHandler = new DocumentHandler();
        this.setDocument(this.getDocument());
    }

    public void paste() {
        Document d = this.getDocument();
        if (d != null) {
            int endpos = d.getLength();
            int startpos = this.getInputStart();
            if (this.getCaretPosition() < startpos) {
                this.setCaretPosition(endpos);
            }
        }
        super.paste();
    }

    public void setDocument(Document doc) {
        if (this.documentHandler != null && this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this.documentHandler);
        }
        super.setDocument(doc);
        doc.addDocumentListener(this.documentHandler);
    }

    public HistoryModel getHistoryModel() {
        return this.history.getModel();
    }

    public void setHistoryModel(String name) {
        this.history.setModel(name);
    }

    public void setHistoryIndex(int index) {
        this.history.setIndex(index);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void fireActionEvent(String code) {
        ActionEvent evt = new ActionEvent(this, 1001, code);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != ActionListener.class) continue;
            ActionListener l = (ActionListener)listeners[i + 1];
            l.actionPerformed(evt);
        }
    }

    public String getInput() {
        try {
            Document doc = this.getDocument();
            int cmdStart = this.getInputStart();
            int length = doc.getLength();
            String line = doc.getText(cmdStart, length - cmdStart);
            if (line.endsWith("\n")) {
                return line.substring(0, line.length() - 1);
            }
            return line;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInput(String line) {
        try {
            Document doc = this.getDocument();
            int cmdStart = this.getInputStart();
            doc.remove(cmdStart, doc.getLength() - cmdStart);
            doc.insertString(cmdStart, line, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getInputStart() {
        Document d = this.getDocument();
        Object p = d.getProperty(InputStart);
        Integer i = (Integer)p;
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void setInputStart(int cmdStart) {
        this.getDocument().putProperty(InputStart, cmdStart);
    }

    public String getPartialInput() {
        try {
            return this.getDocument().getText(this.getInputStart(), this.getCaretPosition() - this.getInputStart());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void eval(String eval) {
        if (eval == null) {
            return;
        }
        try {
            StyledDocument doc = (StyledDocument)this.getDocument();
            this.setCaretPosition(doc.getLength());
            doc.insertString(doc.getLength(), eval + "\n", this.getCharacterAttributes());
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.fireActionEvent(eval);
    }

    public static AttributeSet colorAttributes(Color color) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        if (color != null) {
            style.addAttribute(StyleConstants.Foreground, color);
        }
        return style;
    }

    protected void processKeyEvent(KeyEvent e) {
        int endpos = this.getDocument().getLength();
        int startpos = this.getInputStart();
        if (e.getID() == 400 && this.getCaretPosition() < startpos) {
            this.setCaretPosition(endpos);
        }
        super.processKeyEvent(e);
    }

    private AttributeSet getAttributes(int pos) {
        StyledDocument doc = (StyledDocument)this.getDocument();
        Element e = doc.getCharacterElement(pos);
        return e.getAttributes();
    }

    private Object[] getActions(int pos) {
        AttributeSet a = this.getAttributes(pos);
        if (a == null) {
            return null;
        }
        return (Object[])a.getAttribute(Actions);
    }

    private void clickLink(int pos) {
        Object[] actions = this.getActions(pos);
        if (actions == null || actions.length == 0) {
            return;
        }
        if (actions.length == 0) {
            ((Action)actions[0]).actionPerformed(new ActionEvent(this, 1001, null));
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < actions.length; ++i) {
            popup.add(new JMenuItem((Action)actions[i]));
        }
        try {
            StyledDocument doc = (StyledDocument)this.getDocument();
            Element e = doc.getCharacterElement(pos);
            Point pt = this.modelToView(e.getStartOffset()).getLocation();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            popup.show(this, pt.x, pt.y + fm.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            int offset = e.getOffset();
            int length = e.getLength();
            int cmdStart = ConsolePane.this.getInputStart();
            if (offset < cmdStart) {
                cmdStart += length;
            }
            ConsolePane.this.setInputStart(cmdStart);
        }

        public void removeUpdate(DocumentEvent e) {
            int offset = e.getOffset();
            int length = e.getLength();
            int cmdStart = ConsolePane.this.getInputStart();
            if (offset < cmdStart) {
                cmdStart = offset + length > cmdStart ? offset : (cmdStart -= length);
            }
            ConsolePane.this.setInputStart(cmdStart);
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    class DummyAction
    extends AbstractAction {
        DummyAction() {
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class SearchDownAction
    extends AbstractAction {
        private Action delegate;

        SearchDownAction(Action delegate) {
            this.delegate = delegate;
        }

        public void actionPerformed(ActionEvent evt) {
            if (ConsolePane.this.getCaretPosition() >= ConsolePane.this.getInputStart()) {
                ConsolePane.this.history.doForwardSearch();
            } else {
                this.delegate.actionPerformed(evt);
            }
        }
    }

    class SearchUpAction
    extends AbstractAction {
        private Action delegate;

        SearchUpAction(Action delegate) {
            this.delegate = delegate;
        }

        public void actionPerformed(ActionEvent evt) {
            if (ConsolePane.this.getCaretPosition() >= ConsolePane.this.getInputStart()) {
                ConsolePane.this.history.doBackwardSearch();
            } else {
                this.delegate.actionPerformed(evt);
            }
        }
    }

    class HistoryDownAction
    extends AbstractAction {
        private Action delegate;

        HistoryDownAction(Action delegate) {
            this.delegate = delegate;
        }

        public void actionPerformed(ActionEvent evt) {
            if (ConsolePane.this.getCaretPosition() >= ConsolePane.this.getInputStart()) {
                ConsolePane.this.history.historyNext();
            } else {
                this.delegate.actionPerformed(evt);
            }
        }
    }

    class HistoryUpAction
    extends AbstractAction {
        private Action delegate;

        HistoryUpAction(Action delegate) {
            this.delegate = delegate;
        }

        public void actionPerformed(ActionEvent evt) {
            if (ConsolePane.this.getCaretPosition() >= ConsolePane.this.getInputStart()) {
                ConsolePane.this.history.historyPrevious();
            } else {
                this.delegate.actionPerformed(evt);
            }
        }
    }

    class SelectHomeAction
    extends AbstractAction {
        SelectHomeAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConsolePane.this.select(ConsolePane.this.getInputStart(), ConsolePane.this.getCaretPosition());
        }
    }

    class HomeAction
    extends AbstractAction {
        HomeAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConsolePane.this.setCaretPosition(ConsolePane.this.getInputStart());
        }
    }

    class DeleteInputAction
    extends SelectHomeAction {
        DeleteInputAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            ConsolePane.this.replaceSelection("");
        }
    }

    class BackspaceAction
    extends AbstractAction {
        BackspaceAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (ConsolePane.this.getSelectionStart() != ConsolePane.this.getSelectionEnd()) {
                ConsolePane.this.replaceSelection("");
                return;
            }
            int caret = ConsolePane.this.getCaretPosition();
            if (caret == ConsolePane.this.getInputStart()) {
                ConsolePane.this.getToolkit().beep();
                return;
            }
            try {
                ConsolePane.this.getDocument().remove(caret - 1, 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConsolePane.this.fireActionEvent(ConsolePane.this.getInput());
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            Point pt = new Point(e.getX(), e.getY());
            int pos = ConsolePane.this.viewToModel(pt);
            if (pos >= 0) {
                ConsolePane.this.clickLink(pos);
            }
        }

        public void mouseMoved(MouseEvent e) {
            Point pt = new Point(e.getX(), e.getY());
            int pos = ConsolePane.this.viewToModel(pt);
            if (pos >= 0) {
                Cursor cursor = ConsolePane.this.getActions(pos) != null ? MoveCursor : DefaultCursor;
                if (ConsolePane.this.getCursor() != cursor) {
                    ConsolePane.this.setCursor(cursor);
                }
            }
        }
    }
}

