/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;

public class IsabelleProcess {
    private volatile Process proc = null;
    private volatile String pid = null;
    private volatile boolean closing = false;
    private LinkedBlockingQueue<String> output = null;
    public volatile String session = null;
    public LinkedBlockingQueue<Result> results;
    private volatile BufferedWriter outputWriter;
    private OutputThread outputThread;
    private volatile BufferedReader inputReader;
    private InputThread inputThread;
    private volatile BufferedReader errorReader;
    private ErrorThread errorThread;
    private ExitThread exitThread;

    private synchronized void putResult(Result.Kind kind, Properties properties, String string) {
        try {
            this.results.put(new Result(kind, properties, string));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void putResult(Result.Kind kind, String string) {
        this.putResult(kind, null, string);
    }

    public synchronized void interrupt() throws IsabelleProcessException {
        block5: {
            if (this.proc != null && this.pid != null) {
                String string = System.getProperty("isabelle.kill", "kill");
                String[] stringArray = new String[]{string, "-INT", this.pid};
                try {
                    this.putResult(Result.Kind.SIGNAL, "INT");
                    int n = Runtime.getRuntime().exec(stringArray).waitFor();
                    if (n != 0) {
                        throw new IsabelleProcessException("Cannot interrupt: kill command failed");
                    }
                    break block5;
                }
                catch (IOException iOException) {
                    throw new IsabelleProcessException(iOException.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    throw new IsabelleProcessException("Cannot interrupt: aborted");
                }
            }
            throw new IsabelleProcessException("Cannot interrupt: no process");
        }
    }

    public synchronized void kill() throws IsabelleProcessException {
        if (this.proc != null) {
            this.tryClose();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new IsabelleProcessException("Cannot kill: no process");
        }
        this.putResult(Result.Kind.SIGNAL, "KILL");
        this.proc.destroy();
        this.proc = null;
    }

    public static String encodeString(String string) {
        Locale locale = null;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c == '\\' || c == '\"') {
                stringBuffer.append(String.format(locale, "\\%03d", (int)c));
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static String encodeProperties(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("(");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(IsabelleProcess.encodeString(string));
            stringBuffer.append(" = ");
            stringBuffer.append(IsabelleProcess.encodeString(properties.getProperty(string)));
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public synchronized void output(String string) throws IsabelleProcessException {
        if (this.proc != null && !this.closing) {
            try {
                this.output.put(string);
            }
            catch (InterruptedException interruptedException) {
                throw new IsabelleProcessException("Cannot output: aborted");
            }
        } else {
            if (this.proc == null) {
                throw new IsabelleProcessException("Cannot output: no process");
            }
            throw new IsabelleProcessException("Cannot output: already closing");
        }
    }

    public synchronized void close() throws IsabelleProcessException {
        this.output("\u0000");
        this.closing = true;
    }

    public synchronized void tryClose() {
        if (this.proc != null && !this.closing) {
            try {
                this.close();
            }
            catch (IsabelleProcessException isabelleProcessException) {
                // empty catch block
            }
        }
    }

    private synchronized void outputSync(String string) throws IsabelleProcessException {
        this.output(" \\<^sync>\n; " + string + " \\<^sync>;\n");
    }

    public synchronized void command(String string) throws IsabelleProcessException {
        this.outputSync("Isabelle.command " + IsabelleProcess.encodeString(string));
    }

    public synchronized void command(Properties properties, String string) throws IsabelleProcessException {
        this.outputSync("Isabelle.command " + IsabelleProcess.encodeProperties(properties) + " " + IsabelleProcess.encodeString(string));
    }

    public synchronized void ML(String string) throws IsabelleProcessException {
        this.outputSync("ML_val " + IsabelleProcess.encodeString(string));
    }

    public synchronized void ML(Properties properties, String string) throws IsabelleProcessException {
        this.command(properties, "ML_val " + IsabelleProcess.encodeString(string));
    }

    public IsabelleProcess(String[] stringArray, String string) throws IsabelleProcessException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        String string4 = "UTF-8";
        string2 = System.getProperty("isabelle.shell");
        string3 = System.getProperty("isabelle.home");
        if (string2 != null && string3 != null) {
            arrayList.add(string2);
            arrayList.add(string3 + "/bin/isabelle-process");
        } else if (string3 != null) {
            arrayList.add(string3 + "/bin/isabelle-process");
        } else {
            if (string2 != null) {
                throw new IsabelleProcessException("Cannot start process: isabelle.shell property requires isabelle.home");
            }
            arrayList.add("isabelle-process");
        }
        arrayList.add("-W");
        if (stringArray != null) {
            for (String string5 : stringArray) {
                arrayList.add(string5);
            }
        }
        if (string != null) {
            arrayList.add(string);
        }
        try {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            this.proc = Runtime.getRuntime().exec(stringArray2);
        }
        catch (IOException iOException) {
            throw new IsabelleProcessException(iOException.getMessage());
        }
        try {
            this.outputWriter = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream(), string4));
            this.inputReader = new BufferedReader(new InputStreamReader(this.proc.getInputStream(), string4));
            this.errorReader = new BufferedReader(new InputStreamReader(this.proc.getErrorStream(), string4));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.proc.destroy();
            throw new Error(unsupportedEncodingException.getMessage());
        }
        this.output = new LinkedBlockingQueue();
        this.outputThread = new OutputThread();
        this.results = new LinkedBlockingQueue();
        this.inputThread = new InputThread();
        this.errorThread = new ErrorThread();
        this.exitThread = new ExitThread();
        this.outputThread.start();
        this.inputThread.start();
        this.errorThread.start();
        this.exitThread.start();
    }

    public IsabelleProcess(String string) throws IsabelleProcessException {
        this(null, string);
    }

    public IsabelleProcess() throws IsabelleProcessException {
        this(null);
    }

    private class ExitThread
    extends Thread {
        private ExitThread() {
        }

        @Override
        public void run() {
            try {
                int n = IsabelleProcess.this.proc.waitFor();
                Thread.sleep(300L);
                IsabelleProcess.this.putResult(Result.Kind.SYSTEM, "Exit thread terminated");
                IsabelleProcess.this.putResult(Result.Kind.EXIT, Integer.toString(n));
                IsabelleProcess.this.proc = null;
            }
            catch (InterruptedException interruptedException) {
                IsabelleProcess.this.putResult(Result.Kind.SYSTEM, "Exit thread interrupted");
            }
        }
    }

    private class ErrorThread
    extends Thread {
        private ErrorThread() {
        }

        @Override
        public void run() {
            try {
                while (IsabelleProcess.this.errorReader != null) {
                    int n;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    while ((stringBuffer.length() == 0 || IsabelleProcess.this.errorReader.ready()) && (n = IsabelleProcess.this.errorReader.read()) > 0) {
                        stringBuffer.append((char)n);
                    }
                    if (stringBuffer.length() > 0) {
                        IsabelleProcess.this.putResult(Result.Kind.STDERR, stringBuffer.toString());
                        continue;
                    }
                    IsabelleProcess.this.errorReader.close();
                    IsabelleProcess.this.errorReader = null;
                    IsabelleProcess.this.tryClose();
                }
            }
            catch (IOException iOException) {
                IsabelleProcess.this.putResult(Result.Kind.SYSTEM, iOException.getMessage() + " (error thread)");
            }
            IsabelleProcess.this.putResult(Result.Kind.SYSTEM, "Error thread terminated");
        }
    }

    private class InputThread
    extends Thread {
        private InputThread() {
        }

        @Override
        public void run() {
            Result.Kind kind = Result.Kind.STDOUT;
            Properties properties = null;
            StringBuffer stringBuffer = new StringBuffer(100);
            try {
                while (IsabelleProcess.this.inputReader != null) {
                    if (kind == Result.Kind.STDOUT) {
                        int n = -1;
                        while ((stringBuffer.length() == 0 || IsabelleProcess.this.inputReader.ready()) && (n = IsabelleProcess.this.inputReader.read()) > 0 && n != 2) {
                            stringBuffer.append((char)n);
                        }
                        if (stringBuffer.length() > 0) {
                            IsabelleProcess.this.putResult(kind, stringBuffer.toString());
                            stringBuffer = new StringBuffer(100);
                        }
                        if (n == -1) {
                            IsabelleProcess.this.inputReader.close();
                            IsabelleProcess.this.inputReader = null;
                            IsabelleProcess.this.tryClose();
                            continue;
                        }
                        if (n != 2) continue;
                        n = IsabelleProcess.this.inputReader.read();
                        switch (n) {
                            case 65: {
                                kind = Result.Kind.WRITELN;
                                break;
                            }
                            case 66: {
                                kind = Result.Kind.PRIORITY;
                                break;
                            }
                            case 67: {
                                kind = Result.Kind.TRACING;
                                break;
                            }
                            case 68: {
                                kind = Result.Kind.WARNING;
                                break;
                            }
                            case 69: {
                                kind = Result.Kind.ERROR;
                                break;
                            }
                            case 70: {
                                kind = Result.Kind.DEBUG;
                                break;
                            }
                            case 71: {
                                kind = Result.Kind.PROMPT;
                                break;
                            }
                            case 72: {
                                kind = Result.Kind.INIT;
                                break;
                            }
                            default: {
                                kind = Result.Kind.STDOUT;
                            }
                        }
                        properties = null;
                        continue;
                    }
                    String string = null;
                    string = IsabelleProcess.this.inputReader.readLine();
                    if (string != null) {
                        int n = string.length();
                        if (string.endsWith("\u0002,")) {
                            int n2 = string.indexOf("=");
                            if (n2 <= 0) continue;
                            String string2 = string.substring(0, n2);
                            String string3 = string.substring(n2 + 1, n - 2);
                            if (properties == null) {
                                properties = new Properties();
                            }
                            if (properties.containsKey(string2)) continue;
                            properties.setProperty(string2, string3);
                            continue;
                        }
                        if (string.endsWith("\u0002.")) {
                            if (kind == Result.Kind.INIT && properties != null) {
                                IsabelleProcess.this.pid = properties.getProperty("pid");
                                IsabelleProcess.this.session = properties.getProperty("session");
                            }
                            stringBuffer.append(string.substring(0, n - 2));
                            IsabelleProcess.this.putResult(kind, properties, stringBuffer.toString());
                            stringBuffer = new StringBuffer(100);
                            kind = Result.Kind.STDOUT;
                            continue;
                        }
                        stringBuffer.append(string);
                        stringBuffer.append("\n");
                        continue;
                    }
                    IsabelleProcess.this.inputReader.close();
                    IsabelleProcess.this.inputReader = null;
                    IsabelleProcess.this.tryClose();
                }
            }
            catch (IOException iOException) {
                IsabelleProcess.this.putResult(Result.Kind.SYSTEM, iOException.getMessage() + " (input thread)");
            }
            IsabelleProcess.this.putResult(Result.Kind.SYSTEM, "Input thread terminated");
        }
    }

    private class OutputThread
    extends Thread {
        private OutputThread() {
        }

        @Override
        public void run() {
            while (IsabelleProcess.this.outputWriter != null) {
                try {
                    String string = (String)IsabelleProcess.this.output.take();
                    if (string.equals("\u0000")) {
                        IsabelleProcess.this.outputWriter.close();
                        IsabelleProcess.this.outputWriter = null;
                        continue;
                    }
                    IsabelleProcess.this.putResult(Result.Kind.STDIN, string);
                    IsabelleProcess.this.outputWriter.write(string);
                    IsabelleProcess.this.outputWriter.flush();
                }
                catch (InterruptedException interruptedException) {
                    IsabelleProcess.this.putResult(Result.Kind.SYSTEM, "Output thread interrupted");
                }
                catch (IOException iOException) {
                    IsabelleProcess.this.putResult(Result.Kind.SYSTEM, iOException.getMessage() + " (output thread)");
                }
            }
            IsabelleProcess.this.putResult(Result.Kind.SYSTEM, "Output thread terminated");
        }
    }

    public static class Property {
        public static String ID = "id";
        public static String LINE = "line";
        public static String FILE = "file";
    }

    public static class Result {
        public Kind kind;
        public Properties props;
        public String result;

        public Result(Kind kind, Properties properties, String string) {
            this.kind = kind;
            this.props = properties;
            this.result = string;
        }

        public boolean isRaw() {
            return this.kind == Kind.STDOUT || this.kind == Kind.STDERR;
        }

        public boolean isSystem() {
            return this.kind == Kind.STDIN || this.kind == Kind.SIGNAL || this.kind == Kind.EXIT || this.kind == Kind.PROMPT || this.kind == Kind.SYSTEM;
        }

        public String toString() {
            if (this.props == null) {
                return this.kind.toString() + " [[" + this.result + "]]";
            }
            return this.kind.toString() + " " + this.props.toString() + " [[" + this.result + "]]";
        }

        public static enum Kind {
            STDIN,
            STDOUT,
            STDERR,
            SIGNAL,
            EXIT,
            WRITELN,
            PRIORITY,
            TRACING,
            WARNING,
            ERROR,
            DEBUG,
            PROMPT,
            INIT,
            SYSTEM;

        }
    }

    public static class IsabelleProcessException
    extends Exception {
        public IsabelleProcessException() {
        }

        public IsabelleProcessException(String string) {
            super(string);
        }
    }
}

