(*
    Universal property and evaluation homomorphism of univariate polynomials
    $Id: PolyHomo.thy,v 1.6 2003/04/30 08:01:35 ballarin Exp $
    Author: Clemens Ballarin, started 15 April 1997
*)

PolyHomo = UnivPoly2 +

consts
  EVAL2	:: "['a::ring => 'b, 'b, 'a up] => 'b::ring"
  EVAL	:: "['a::ring, 'a up] => 'a"

defs
  EVAL2_def	"EVAL2 phi a p ==
                 setsum (%i. phi (coeff p i) * a ^ i) {..deg p}"
  EVAL_def	"EVAL == EVAL2 (%x. x)"

end
